/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import icc.ICCProfile;
import icc.tags.ICCCurveType;
import icc.tags.ICCTag;

public class ICCCurveTypeReverse
extends ICCTag {
    private static final String eol = System.getProperty("line.separator");
    public final int type;
    public final int reserved;
    public final int nEntries;
    public final int[] entry;

    public String toString() {
        StringBuffer rep = new StringBuffer("[").append(super.toString()).append(eol);
        rep.append("num entries = " + String.valueOf(this.nEntries) + eol);
        rep.append("data length = " + String.valueOf(this.entry.length) + eol);
        int i = 0;
        while (i < this.nEntries) {
            rep.append(String.valueOf(ICCProfile.toHexString(this.entry[i])) + eol);
            ++i;
        }
        return rep.append("]").toString();
    }

    public static double CurveToDouble(int entry) {
        return ICCCurveType.CurveToDouble(entry);
    }

    public static short DoubleToCurve(int entry) {
        return ICCCurveType.DoubleToCurve(entry);
    }

    public static double CurveGammaToDouble(int entry) {
        return ICCCurveType.CurveGammaToDouble(entry);
    }

    protected ICCCurveTypeReverse(int signature, byte[] data, int offset, int length) {
        super(signature, data, offset, offset + 8);
        this.type = ICCProfile.getInt(data, offset);
        this.reserved = ICCProfile.getInt(data, offset + 4);
        this.nEntries = ICCProfile.getInt(data, offset + 8);
        this.entry = new int[this.nEntries];
        int i = 0;
        while (i < this.nEntries) {
            this.entry[this.nEntries - 1 + i] = ICCProfile.getShort(data, offset + 12 + i * 2) & 0xFFFF;
            ++i;
        }
    }

    public final int entry(int i) {
        return this.entry[i];
    }
}

