/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import icc.ICCProfile;
import icc.tags.ICCCurveType;
import icc.tags.ICCCurveTypeReverse;
import icc.tags.ICCTextDescriptionType;
import icc.tags.ICCTextType;
import icc.tags.ICCXYZType;
import icc.tags.ICCXYZTypeReverse;

public abstract class ICCTag {
    private static final String sdwCprtSignature = "cprt";
    private static final String sdwDescSignature = "desc";
    private static final String sdwWtPtSignature = "wtpt";
    private static final String sdwBkPtSignature = "bkpt";
    private static final String sdwRXYZSignature = "rXYZ";
    private static final String sdwGXYZSignature = "gXYZ";
    private static final String sdwBXYZSignature = "bXYZ";
    private static final String sdwKXYZSignature = "kXYZ";
    private static final String sdwRTRCSignature = "rTRC";
    private static final String sdwGTRCSignature = "gTRC";
    private static final String sdwBTRCSignature = "bTRC";
    private static final String sdwKTRCSignature = "kTRC";
    private static final String sdwDmndSignature = "dmnd";
    private static final String sdwDmddSignature = "dmdd";
    private static final int kdwCprtSignature = ICCProfile.getInt("cprt".getBytes(), 0);
    private static final int kdwDescSignature = ICCProfile.getInt("desc".getBytes(), 0);
    private static final int kdwWtPtSignature = ICCProfile.getInt("wtpt".getBytes(), 0);
    private static final int kdwBkPtSignature = ICCProfile.getInt("bkpt".getBytes(), 0);
    private static final int kdwRXYZSignature = ICCProfile.getInt("rXYZ".getBytes(), 0);
    private static final int kdwGXYZSignature = ICCProfile.getInt("gXYZ".getBytes(), 0);
    private static final int kdwBXYZSignature = ICCProfile.getInt("bXYZ".getBytes(), 0);
    private static final int kdwKXYZSignature = ICCProfile.getInt("kXYZ".getBytes(), 0);
    private static final int kdwRTRCSignature = ICCProfile.getInt("rTRC".getBytes(), 0);
    private static final int kdwGTRCSignature = ICCProfile.getInt("gTRC".getBytes(), 0);
    private static final int kdwBTRCSignature = ICCProfile.getInt("bTRC".getBytes(), 0);
    private static final int kdwKTRCSignature = ICCProfile.getInt("kTRC".getBytes(), 0);
    private static final int kdwDmndSignature = ICCProfile.getInt("dmnd".getBytes(), 0);
    private static final int kdwDmddSignature = ICCProfile.getInt("dmdd".getBytes(), 0);
    private static final String sdwTextDescType = "desc";
    private static final String sdwTextType = "text";
    private static final String sdwCurveType = "curv";
    private static final String sdwCurveTypeReverse = "vruc";
    private static final String sdwXYZType = "XYZ ";
    private static final String sdwXYZTypeReverse = " ZYX";
    private static final int kdwTextDescType = ICCProfile.getInt("desc".getBytes(), 0);
    private static final int kdwTextType = ICCProfile.getInt("text".getBytes(), 0);
    private static final int kdwCurveType = ICCProfile.getInt("curv".getBytes(), 0);
    private static final int kdwCurveTypeReverse = ICCProfile.getInt("vruc".getBytes(), 0);
    private static final int kdwXYZType = ICCProfile.getInt("XYZ ".getBytes(), 0);
    private static final int kdwXYZTypeReverse = ICCProfile.getInt(" ZYX".getBytes(), 0);
    public final int signature;
    public final int type;
    public final byte[] data;
    public final int offset;
    public final int count;

    public static String typeString(int type) {
        if (type == kdwTextDescType) {
            return "desc";
        }
        if (type == kdwTextType) {
            return "desc";
        }
        if (type == kdwCurveType) {
            return sdwCurveType;
        }
        if (type == kdwCurveTypeReverse) {
            return sdwCurveTypeReverse;
        }
        if (type == kdwXYZType) {
            return sdwXYZType;
        }
        if (type == kdwXYZTypeReverse) {
            return sdwXYZTypeReverse;
        }
        return "bad tag type";
    }

    public static String signatureString(int signature) {
        if (signature == kdwCprtSignature) {
            return sdwCprtSignature;
        }
        if (signature == kdwDescSignature) {
            return "desc";
        }
        if (signature == kdwWtPtSignature) {
            return sdwWtPtSignature;
        }
        if (signature == kdwBkPtSignature) {
            return sdwBkPtSignature;
        }
        if (signature == kdwRXYZSignature) {
            return sdwRXYZSignature;
        }
        if (signature == kdwGXYZSignature) {
            return sdwGXYZSignature;
        }
        if (signature == kdwBXYZSignature) {
            return sdwBXYZSignature;
        }
        if (signature == kdwRTRCSignature) {
            return sdwRTRCSignature;
        }
        if (signature == kdwGTRCSignature) {
            return sdwGTRCSignature;
        }
        if (signature == kdwBTRCSignature) {
            return sdwBTRCSignature;
        }
        if (signature == kdwKTRCSignature) {
            return sdwKTRCSignature;
        }
        if (signature == kdwDmndSignature) {
            return sdwDmndSignature;
        }
        if (signature == kdwDmddSignature) {
            return sdwDmddSignature;
        }
        return "bad tag signature";
    }

    public static ICCTag createInstance(int signature, byte[] data, int offset, int count) {
        int type = ICCProfile.getInt(data, offset);
        if (type == kdwTextDescType) {
            return new ICCTextDescriptionType(signature, data, offset, count);
        }
        if (type == kdwTextType) {
            return new ICCTextType(signature, data, offset, count);
        }
        if (type == kdwXYZType) {
            return new ICCXYZType(signature, data, offset, count);
        }
        if (type == kdwXYZTypeReverse) {
            return new ICCXYZTypeReverse(signature, data, offset, count);
        }
        if (type == kdwCurveType) {
            return new ICCCurveType(signature, data, offset, count);
        }
        if (type == kdwCurveTypeReverse) {
            return new ICCCurveTypeReverse(signature, data, offset, count);
        }
        throw new IllegalArgumentException("bad tag type");
    }

    protected ICCTag(int signature, byte[] data, int offset, int count) {
        this.signature = signature;
        this.data = data;
        this.offset = offset;
        this.count = count;
        this.type = ICCProfile.getInt(data, offset);
    }

    public String toString() {
        return String.valueOf(ICCTag.signatureString(this.signature)) + ":" + ICCTag.typeString(this.type);
    }
}

