/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import colorspace.ColorSpace;
import icc.ICCProfile;
import icc.tags.ICCTag;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ICCTagTable
extends Hashtable {
    private static final String eol = System.getProperty("line.separator");
    private static final int offTagCount = 128;
    private static final int offTags = 132;
    private final Vector trios = new Vector();
    private int tagCount;

    public String toString() {
        StringBuffer rep = new StringBuffer("[ICCTagTable containing " + this.tagCount + " tags:");
        StringBuffer body = new StringBuffer("  ");
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            ICCTag tag = (ICCTag)this.get(key);
            body.append(eol).append(tag.toString());
        }
        rep.append(ColorSpace.indent("  ", body));
        return rep.append("]").toString();
    }

    public static ICCTagTable createInstance(byte[] data) {
        ICCTagTable tags = new ICCTagTable(data);
        return tags;
    }

    protected ICCTagTable(byte[] data) {
        this.tagCount = ICCProfile.getInt(data, 128);
        int offset = 132;
        int i = 0;
        while (i < this.tagCount) {
            int signature = ICCProfile.getInt(data, offset);
            int tagOffset = ICCProfile.getInt(data, offset + 4);
            int length = ICCProfile.getInt(data, offset + 8);
            this.trios.addElement(new Triplet(signature, tagOffset, length));
            offset += 12;
            ++i;
        }
        Enumeration enumeration = this.trios.elements();
        while (enumeration.hasMoreElements()) {
            Triplet trio = (Triplet)enumeration.nextElement();
            ICCTag tag = ICCTag.createInstance(trio.signature, data, trio.offset, trio.count);
            this.put(new Integer(tag.signature), tag);
        }
    }

    public void write(RandomAccessFile raf) throws IOException {
        int ntags = this.trios.size();
        int countOff = 128;
        int tagOff = countOff + 4;
        int dataOff = tagOff + 3 * ntags * 4;
        raf.seek(countOff);
        raf.writeInt(ntags);
        int currentTagOff = tagOff;
        int currentDataOff = dataOff;
        Enumeration enumeration = this.trios.elements();
        while (enumeration.hasMoreElements()) {
            Triplet trio = (Triplet)enumeration.nextElement();
            ICCTag tag = (ICCTag)this.get(new Integer(trio.signature));
            raf.seek(currentTagOff);
            raf.writeInt(tag.signature);
            raf.writeInt(currentDataOff);
            raf.writeInt(tag.count);
            currentTagOff += 3 * 12;
            raf.seek(currentDataOff);
            raf.write(tag.data, tag.offset, tag.count);
            currentDataOff += tag.count;
        }
    }

    private static class Triplet {
        private int signature;
        private int offset;
        private int count;
        public static final int size = 12;

        Triplet(int signature, int offset, int count) {
            this.signature = signature;
            this.offset = offset;
            this.count = count;
        }
    }
}

