/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import jj2000.disp.ImgScrollPane;

public class ImgMouseListener
extends MouseAdapter
implements MouseMotionListener {
    ImgScrollPane isp;
    int startMouseX;
    int startMouseY;
    int startScrollX;
    int startScrollY;
    Cursor prevCursor;

    public ImgMouseListener(ImgScrollPane isp) {
        this.isp = isp;
    }

    public void mousePressed(MouseEvent e) {
        this.startMouseX = e.getX();
        this.startMouseY = e.getY();
        this.startScrollX = this.isp.getHAdjustable().getValue();
        this.startScrollY = this.isp.getVAdjustable().getValue();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.prevCursor != null) {
            this.isp.setCursor(this.prevCursor);
            this.prevCursor = null;
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.prevCursor == null) {
            this.prevCursor = this.isp.getCursor();
            this.isp.setCursor(Cursor.getPredefinedCursor(13));
        }
        int scrollX = this.startScrollX + this.startMouseX - evt.getX();
        int scrollY = this.startScrollY + this.startMouseY - evt.getY();
        this.isp.setScrollPosition(scrollX, scrollY);
    }

    public void mouseMoved(MouseEvent evt) {
    }
}

