/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream;

import java.util.Hashtable;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.wavelet.FilterTypes;

public class HeaderInfo
implements Markers,
ProgressionType,
FilterTypes,
Cloneable {
    public SIZ siz;
    public Hashtable sot = new Hashtable();
    public Hashtable cod = new Hashtable();
    public Hashtable coc = new Hashtable();
    public Hashtable rgn = new Hashtable();
    public Hashtable qcd = new Hashtable();
    public Hashtable qcc = new Hashtable();
    public Hashtable poc = new Hashtable();
    public CRG crg;
    public Hashtable com = new Hashtable();
    private int ncom = 0;

    public SIZ getNewSIZ() {
        return new SIZ();
    }

    public SOT getNewSOT() {
        return new SOT();
    }

    public COD getNewCOD() {
        return new COD();
    }

    public COC getNewCOC() {
        return new COC();
    }

    public RGN getNewRGN() {
        return new RGN();
    }

    public QCD getNewQCD() {
        return new QCD();
    }

    public QCC getNewQCC() {
        return new QCC();
    }

    public POC getNewPOC() {
        return new POC();
    }

    public CRG getNewCRG() {
        return new CRG();
    }

    public COM getNewCOM() {
        ++this.ncom;
        return new COM();
    }

    public int getNumCOM() {
        return this.ncom;
    }

    public String toStringMainHeader() {
        int nc = this.siz.csiz;
        String str = "" + this.siz;
        if (this.cod.get("main") != null) {
            str = String.valueOf(str) + (COD)this.cod.get("main");
        }
        int c = 0;
        while (c < nc) {
            if (this.coc.get("main_c" + c) != null) {
                str = String.valueOf(str) + (COC)this.coc.get("main_c" + c);
            }
            ++c;
        }
        if (this.qcd.get("main") != null) {
            str = String.valueOf(str) + (QCD)this.qcd.get("main");
        }
        c = 0;
        while (c < nc) {
            if (this.qcc.get("main_c" + c) != null) {
                str = String.valueOf(str) + (QCC)this.qcc.get("main_c" + c);
            }
            ++c;
        }
        c = 0;
        while (c < nc) {
            if (this.rgn.get("main_c" + c) != null) {
                str = String.valueOf(str) + (RGN)this.rgn.get("main_c" + c);
            }
            ++c;
        }
        if (this.poc.get("main") != null) {
            str = String.valueOf(str) + (POC)this.poc.get("main");
        }
        if (this.crg != null) {
            str = String.valueOf(str) + this.crg;
        }
        int i = 0;
        while (i < this.ncom) {
            if (this.com.get("main_" + i) != null) {
                str = String.valueOf(str) + (COM)this.com.get("main_" + i);
            }
            ++i;
        }
        return str;
    }

    public String toStringTileHeader(int t, int ntp) {
        int nc = this.siz.csiz;
        String str = "";
        int i = 0;
        while (i < ntp) {
            str = String.valueOf(str) + "Tile-part " + i + ", tile " + t + ":\n";
            str = String.valueOf(str) + (SOT)this.sot.get("t" + t + "_tp" + i);
            ++i;
        }
        if (this.cod.get("t" + t) != null) {
            str = String.valueOf(str) + (COD)this.cod.get("t" + t);
        }
        int c = 0;
        while (c < nc) {
            if (this.coc.get("t" + t + "_c" + c) != null) {
                str = String.valueOf(str) + (COC)this.coc.get("t" + t + "_c" + c);
            }
            ++c;
        }
        if (this.qcd.get("t" + t) != null) {
            str = String.valueOf(str) + (QCD)this.qcd.get("t" + t);
        }
        c = 0;
        while (c < nc) {
            if (this.qcc.get("t" + t + "_c" + c) != null) {
                str = String.valueOf(str) + (QCC)this.qcc.get("t" + t + "_c" + c);
            }
            ++c;
        }
        c = 0;
        while (c < nc) {
            if (this.rgn.get("t" + t + "_c" + c) != null) {
                str = String.valueOf(str) + (RGN)this.rgn.get("t" + t + "_c" + c);
            }
            ++c;
        }
        if (this.poc.get("t" + t) != null) {
            str = String.valueOf(str) + (POC)this.poc.get("t" + t);
        }
        return str;
    }

    public String toStringThNoSOT(int t, int ntp) {
        int nc = this.siz.csiz;
        String str = "";
        if (this.cod.get("t" + t) != null) {
            str = String.valueOf(str) + (COD)this.cod.get("t" + t);
        }
        int c = 0;
        while (c < nc) {
            if (this.coc.get("t" + t + "_c" + c) != null) {
                str = String.valueOf(str) + (COC)this.coc.get("t" + t + "_c" + c);
            }
            ++c;
        }
        if (this.qcd.get("t" + t) != null) {
            str = String.valueOf(str) + (QCD)this.qcd.get("t" + t);
        }
        c = 0;
        while (c < nc) {
            if (this.qcc.get("t" + t + "_c" + c) != null) {
                str = String.valueOf(str) + (QCC)this.qcc.get("t" + t + "_c" + c);
            }
            ++c;
        }
        c = 0;
        while (c < nc) {
            if (this.rgn.get("t" + t + "_c" + c) != null) {
                str = String.valueOf(str) + (RGN)this.rgn.get("t" + t + "_c" + c);
            }
            ++c;
        }
        if (this.poc.get("t" + t) != null) {
            str = String.valueOf(str) + (POC)this.poc.get("t" + t);
        }
        return str;
    }

    public HeaderInfo getCopy(int nt) {
        HeaderInfo nhi = null;
        try {
            nhi = (HeaderInfo)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Cannot clone HeaderInfo instance");
        }
        nhi.siz = this.siz.getCopy();
        if (this.cod.get("main") != null) {
            COD ms = (COD)this.cod.get("main");
            nhi.cod.put("main", ms.getCopy());
        }
        int t = 0;
        while (t < nt) {
            if (this.cod.get("t" + t) != null) {
                COD ms = (COD)this.cod.get("t" + t);
                nhi.cod.put("t" + t, ms.getCopy());
            }
            ++t;
        }
        return nhi;
    }

    public class SIZ
    implements Cloneable {
        public int lsiz;
        public int rsiz;
        public int xsiz;
        public int ysiz;
        public int x0siz;
        public int y0siz;
        public int xtsiz;
        public int ytsiz;
        public int xt0siz;
        public int yt0siz;
        public int csiz;
        public int[] ssiz;
        public int[] xrsiz;
        public int[] yrsiz;
        private int[] compWidth = null;
        private int maxCompWidth = -1;
        private int[] compHeight = null;
        private int maxCompHeight = -1;
        private int numTiles = -1;
        private boolean[] origSigned = null;
        private int[] origBitDepth = null;

        public int getCompImgWidth(int c) {
            if (this.compWidth == null) {
                this.compWidth = new int[this.csiz];
                int cc = 0;
                while (cc < this.csiz) {
                    this.compWidth[cc] = (int)(Math.ceil((double)this.xsiz / (double)this.xrsiz[cc]) - Math.ceil((double)this.x0siz / (double)this.xrsiz[cc]));
                    ++cc;
                }
            }
            return this.compWidth[c];
        }

        public int getMaxCompWidth() {
            if (this.compWidth == null) {
                this.compWidth = new int[this.csiz];
                int cc = 0;
                while (cc < this.csiz) {
                    this.compWidth[cc] = (int)(Math.ceil((double)this.xsiz / (double)this.xrsiz[cc]) - Math.ceil((double)this.x0siz / (double)this.xrsiz[cc]));
                    ++cc;
                }
            }
            if (this.maxCompWidth == -1) {
                int c = 0;
                while (c < this.csiz) {
                    if (this.compWidth[c] > this.maxCompWidth) {
                        this.maxCompWidth = this.compWidth[c];
                    }
                    ++c;
                }
            }
            return this.maxCompWidth;
        }

        public int getCompImgHeight(int c) {
            if (this.compHeight == null) {
                this.compHeight = new int[this.csiz];
                int cc = 0;
                while (cc < this.csiz) {
                    this.compHeight[cc] = (int)(Math.ceil((double)this.ysiz / (double)this.yrsiz[cc]) - Math.ceil((double)this.y0siz / (double)this.yrsiz[cc]));
                    ++cc;
                }
            }
            return this.compHeight[c];
        }

        public int getMaxCompHeight() {
            if (this.compHeight == null) {
                this.compHeight = new int[this.csiz];
                int cc = 0;
                while (cc < this.csiz) {
                    this.compHeight[cc] = (int)(Math.ceil((double)this.ysiz / (double)this.yrsiz[cc]) - Math.ceil((double)this.y0siz / (double)this.yrsiz[cc]));
                    ++cc;
                }
            }
            if (this.maxCompHeight == -1) {
                int c = 0;
                while (c < this.csiz) {
                    if (this.compHeight[c] != this.maxCompHeight) {
                        this.maxCompHeight = this.compHeight[c];
                    }
                    ++c;
                }
            }
            return this.maxCompHeight;
        }

        public int getNumTiles() {
            if (this.numTiles == -1) {
                this.numTiles = (this.xsiz - this.xt0siz + this.xtsiz - 1) / this.xtsiz * ((this.ysiz - this.yt0siz + this.ytsiz - 1) / this.ytsiz);
            }
            return this.numTiles;
        }

        public boolean isOrigSigned(int c) {
            if (this.origSigned == null) {
                this.origSigned = new boolean[this.csiz];
                int cc = 0;
                while (cc < this.csiz) {
                    this.origSigned[cc] = this.ssiz[cc] >>> 7 == 1;
                    ++cc;
                }
            }
            return this.origSigned[c];
        }

        public int getOrigBitDepth(int c) {
            if (this.origBitDepth == null) {
                this.origBitDepth = new int[this.csiz];
                int cc = 0;
                while (cc < this.csiz) {
                    this.origBitDepth[cc] = (this.ssiz[cc] & 0x7F) + 1;
                    ++cc;
                }
            }
            return this.origBitDepth[c];
        }

        public SIZ getCopy() {
            SIZ ms = null;
            try {
                ms = (SIZ)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Cannot clone SIZ marker segment");
            }
            return ms;
        }

        public String toString() {
            String str = "\n --- SIZ (" + this.lsiz + " bytes) ---\n";
            str = String.valueOf(str) + " Capabilities : " + this.rsiz + "\n";
            str = String.valueOf(str) + " Image dim.   : " + (this.xsiz - this.x0siz) + "x" + (this.ysiz - this.y0siz) + ", (off=" + this.x0siz + "," + this.y0siz + ")\n";
            str = String.valueOf(str) + " Tile dim.    : " + this.xtsiz + "x" + this.ytsiz + ", (off=" + this.xt0siz + "," + this.yt0siz + ")\n";
            str = String.valueOf(str) + " Component(s) : " + this.csiz + "\n";
            str = String.valueOf(str) + " Orig. depth  : ";
            int i = 0;
            while (i < this.csiz) {
                str = String.valueOf(str) + this.getOrigBitDepth(i) + " ";
                ++i;
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + " Orig. signed : ";
            i = 0;
            while (i < this.csiz) {
                str = String.valueOf(str) + this.isOrigSigned(i) + " ";
                ++i;
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + " Subs. factor : ";
            i = 0;
            while (i < this.csiz) {
                str = String.valueOf(str) + this.xrsiz[i] + "," + this.yrsiz[i] + " ";
                ++i;
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class SOT {
        public int lsot;
        public int isot;
        public int psot;
        public int tpsot;
        public int tnsot;

        public String toString() {
            String str = "\n --- SOT (" + this.lsot + " bytes) ---\n";
            str = String.valueOf(str) + "Tile index         : " + this.isot + "\n";
            str = String.valueOf(str) + "Tile-part length   : " + this.psot + " bytes\n";
            str = String.valueOf(str) + "Tile-part index    : " + this.tpsot + "\n";
            str = String.valueOf(str) + "Num. of tile-parts : " + this.tnsot + "\n";
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class COD
    implements Cloneable {
        public int lcod;
        public int scod;
        public int sgcod_po;
        public int sgcod_nl;
        public int sgcod_mct;
        public int spcod_ndl;
        public int spcod_cw;
        public int spcod_ch;
        public int spcod_cs;
        public int[] spcod_t = new int[1];
        public int[] spcod_ps;

        public COD getCopy() {
            COD ms = null;
            try {
                ms = (COD)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Cannot clone SIZ marker segment");
            }
            return ms;
        }

        public String toString() {
            String str = "\n --- COD (" + this.lcod + " bytes) ---\n";
            str = String.valueOf(str) + " Coding style   : ";
            if (this.scod == 0) {
                str = String.valueOf(str) + "Default";
            } else {
                int cb0y;
                if ((this.scod & 1) != 0) {
                    str = String.valueOf(str) + "Precints ";
                }
                if ((this.scod & 2) != 0) {
                    str = String.valueOf(str) + "SOP ";
                }
                if ((this.scod & 4) != 0) {
                    str = String.valueOf(str) + "EPH ";
                }
                int cb0x = (this.scod & 8) != 0 ? 1 : 0;
                int n = cb0y = (this.scod & 0x10) != 0 ? 1 : 0;
                if (cb0x != 0 || cb0y != 0) {
                    str = String.valueOf(str) + "Code-blocks offset";
                    str = String.valueOf(str) + "\n Cblk partition : " + cb0x + "," + cb0y;
                }
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + " Cblk style     : ";
            if (this.spcod_cs == 0) {
                str = String.valueOf(str) + "Default";
            } else {
                if ((this.spcod_cs & 1) != 0) {
                    str = String.valueOf(str) + "Bypass ";
                }
                if ((this.spcod_cs & 2) != 0) {
                    str = String.valueOf(str) + "Reset ";
                }
                if ((this.spcod_cs & 4) != 0) {
                    str = String.valueOf(str) + "Terminate ";
                }
                if ((this.spcod_cs & 8) != 0) {
                    str = String.valueOf(str) + "Vert_causal ";
                }
                if ((this.spcod_cs & 0x10) != 0) {
                    str = String.valueOf(str) + "Predict ";
                }
                if ((this.spcod_cs & 0x20) != 0) {
                    str = String.valueOf(str) + "Seg_symb ";
                }
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + " Num. of levels : " + this.spcod_ndl + "\n";
            switch (this.sgcod_po) {
                case 0: {
                    str = String.valueOf(str) + " Progress. type : LY_RES_COMP_POS_PROG\n";
                    break;
                }
                case 1: {
                    str = String.valueOf(str) + " Progress. type : RES_LY_COMP_POS_PROG\n";
                    break;
                }
                case 2: {
                    str = String.valueOf(str) + " Progress. type : RES_POS_COMP_LY_PROG\n";
                    break;
                }
                case 3: {
                    str = String.valueOf(str) + " Progress. type : POS_COMP_RES_LY_PROG\n";
                    break;
                }
                case 4: {
                    str = String.valueOf(str) + " Progress. type : COMP_POS_RES_LY_PROG\n";
                }
            }
            str = String.valueOf(str) + " Num. of layers : " + this.sgcod_nl + "\n";
            str = String.valueOf(str) + " Cblk dimension : " + (1 << this.spcod_cw + 2) + "x" + (1 << this.spcod_ch + 2) + "\n";
            switch (this.spcod_t[0]) {
                case 0: {
                    str = String.valueOf(str) + " Filter         : 9-7 irreversible\n";
                    break;
                }
                case 1: {
                    str = String.valueOf(str) + " Filter         : 5-3 reversible\n";
                }
            }
            str = String.valueOf(str) + " Multi comp tr. : " + (this.sgcod_mct == 1) + "\n";
            if (this.spcod_ps != null) {
                str = String.valueOf(str) + " Precincts      : ";
                int i = 0;
                while (i < this.spcod_ps.length) {
                    str = String.valueOf(str) + (1 << (this.spcod_ps[i] & 0xF)) + "x" + (1 << ((this.spcod_ps[i] & 0xF0) >> 4)) + " ";
                    ++i;
                }
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class COC {
        public int lcoc;
        public int ccoc;
        public int scoc;
        public int spcoc_ndl;
        public int spcoc_cw;
        public int spcoc_ch;
        public int spcoc_cs;
        public int[] spcoc_t = new int[1];
        public int[] spcoc_ps;

        public String toString() {
            String str = "\n --- COC (" + this.lcoc + " bytes) ---\n";
            str = String.valueOf(str) + " Component      : " + this.ccoc + "\n";
            str = String.valueOf(str) + " Coding style   : ";
            if (this.scoc == 0) {
                str = String.valueOf(str) + "Default";
            } else {
                if ((this.scoc & 1) != 0) {
                    str = String.valueOf(str) + "Precints ";
                }
                if ((this.scoc & 2) != 0) {
                    str = String.valueOf(str) + "SOP ";
                }
                if ((this.scoc & 4) != 0) {
                    str = String.valueOf(str) + "EPH ";
                }
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + " Cblk style     : ";
            if (this.spcoc_cs == 0) {
                str = String.valueOf(str) + "Default";
            } else {
                if ((this.spcoc_cs & 1) != 0) {
                    str = String.valueOf(str) + "Bypass ";
                }
                if ((this.spcoc_cs & 2) != 0) {
                    str = String.valueOf(str) + "Reset ";
                }
                if ((this.spcoc_cs & 4) != 0) {
                    str = String.valueOf(str) + "Terminate ";
                }
                if ((this.spcoc_cs & 8) != 0) {
                    str = String.valueOf(str) + "Vert_causal ";
                }
                if ((this.spcoc_cs & 0x10) != 0) {
                    str = String.valueOf(str) + "Predict ";
                }
                if ((this.spcoc_cs & 0x20) != 0) {
                    str = String.valueOf(str) + "Seg_symb ";
                }
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + " Num. of levels : " + this.spcoc_ndl + "\n";
            str = String.valueOf(str) + " Cblk dimension : " + (1 << this.spcoc_cw + 2) + "x" + (1 << this.spcoc_ch + 2) + "\n";
            switch (this.spcoc_t[0]) {
                case 0: {
                    str = String.valueOf(str) + " Filter         : 9-7 irreversible\n";
                    break;
                }
                case 1: {
                    str = String.valueOf(str) + " Filter         : 5-3 reversible\n";
                }
            }
            if (this.spcoc_ps != null) {
                str = String.valueOf(str) + " Precincts      : ";
                int i = 0;
                while (i < this.spcoc_ps.length) {
                    str = String.valueOf(str) + (1 << (this.spcoc_ps[i] & 0xF)) + "x" + (1 << ((this.spcoc_ps[i] & 0xF0) >> 4)) + " ";
                    ++i;
                }
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class RGN {
        public int lrgn;
        public int crgn;
        public int srgn;
        public int sprgn;

        public String toString() {
            String str = "\n --- RGN (" + this.lrgn + " bytes) ---\n";
            str = String.valueOf(str) + " Component : " + this.crgn + "\n";
            str = this.srgn == 0 ? String.valueOf(str) + " ROI style : Implicit\n" : String.valueOf(str) + " ROI style : Unsupported\n";
            str = String.valueOf(str) + " ROI shift : " + this.sprgn + "\n";
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class QCD {
        public int lqcd;
        public int sqcd;
        public int[][] spqcd;
        private int qType = -1;
        private int gb = -1;

        public int getQuantType() {
            if (this.qType == -1) {
                this.qType = this.sqcd & 0xFFFFFF1F;
            }
            return this.qType;
        }

        public int getNumGuardBits() {
            if (this.gb == -1) {
                this.gb = this.sqcd >> 5 & 7;
            }
            return this.gb;
        }

        public String toString() {
            String str = "\n --- QCD (" + this.lqcd + " bytes) ---\n";
            str = String.valueOf(str) + " Quant. type    : ";
            int qt = this.getQuantType();
            if (qt == 0) {
                str = String.valueOf(str) + "No quantization \n";
            } else if (qt == 1) {
                str = String.valueOf(str) + "Scalar derived\n";
            } else if (qt == 2) {
                str = String.valueOf(str) + "Scalar expounded\n";
            }
            str = String.valueOf(str) + " Guard bits     : " + this.getNumGuardBits() + "\n";
            if (qt == 0) {
                str = String.valueOf(str) + " Exponents   :\n";
                int i = 0;
                while (i < this.spqcd.length) {
                    int j = 0;
                    while (j < this.spqcd[i].length) {
                        int exp;
                        if (i == 0 && j == 0) {
                            exp = this.spqcd[0][0] >> 3 & 0x1F;
                            str = String.valueOf(str) + "\tr=0 : " + exp + "\n";
                        } else if (i != 0 && j > 0) {
                            exp = this.spqcd[i][j] >> 3 & 0x1F;
                            str = String.valueOf(str) + "\tr=" + i + ",s=" + j + " : " + exp + "\n";
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                str = String.valueOf(str) + " Exp / Mantissa : \n";
                int i = 0;
                while (i < this.spqcd.length) {
                    int j = 0;
                    while (j < this.spqcd[i].length) {
                        double mantissa;
                        int exp;
                        if (i == 0 && j == 0) {
                            exp = this.spqcd[0][0] >> 11 & 0x1F;
                            mantissa = (-1.0f - (float)(this.spqcd[0][0] & 0x7FF) / 2048.0f) / (float)(-1 << exp);
                            str = String.valueOf(str) + "\tr=0 : " + exp + " / " + mantissa + "\n";
                        } else if (i != 0 && j > 0) {
                            exp = this.spqcd[i][j] >> 11 & 0x1F;
                            mantissa = (-1.0f - (float)(this.spqcd[i][j] & 0x7FF) / 2048.0f) / (float)(-1 << exp);
                            str = String.valueOf(str) + "\tr=" + i + ",s=" + j + " : " + exp + " / " + mantissa + "\n";
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class QCC {
        public int lqcc;
        public int cqcc;
        public int sqcc;
        public int[][] spqcc;
        private int qType = -1;
        private int gb = -1;

        public int getQuantType() {
            if (this.qType == -1) {
                this.qType = this.sqcc & 0xFFFFFF1F;
            }
            return this.qType;
        }

        public int getNumGuardBits() {
            if (this.gb == -1) {
                this.gb = this.sqcc >> 5 & 7;
            }
            return this.gb;
        }

        public String toString() {
            String str = "\n --- QCC (" + this.lqcc + " bytes) ---\n";
            str = String.valueOf(str) + " Component      : " + this.cqcc + "\n";
            str = String.valueOf(str) + " Quant. type    : ";
            int qt = this.getQuantType();
            if (qt == 0) {
                str = String.valueOf(str) + "No quantization \n";
            } else if (qt == 1) {
                str = String.valueOf(str) + "Scalar derived\n";
            } else if (qt == 2) {
                str = String.valueOf(str) + "Scalar expounded\n";
            }
            str = String.valueOf(str) + " Guard bits     : " + this.getNumGuardBits() + "\n";
            if (qt == 0) {
                str = String.valueOf(str) + " Exponents   :\n";
                int i = 0;
                while (i < this.spqcc.length) {
                    int j = 0;
                    while (j < this.spqcc[i].length) {
                        int exp;
                        if (i == 0 && j == 0) {
                            exp = this.spqcc[0][0] >> 3 & 0x1F;
                            str = String.valueOf(str) + "\tr=0 : " + exp + "\n";
                        } else if (i != 0 && j > 0) {
                            exp = this.spqcc[i][j] >> 3 & 0x1F;
                            str = String.valueOf(str) + "\tr=" + i + ",s=" + j + " : " + exp + "\n";
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                str = String.valueOf(str) + " Exp / Mantissa : \n";
                int i = 0;
                while (i < this.spqcc.length) {
                    int j = 0;
                    while (j < this.spqcc[i].length) {
                        double mantissa;
                        int exp;
                        if (i == 0 && j == 0) {
                            exp = this.spqcc[0][0] >> 11 & 0x1F;
                            mantissa = (-1.0f - (float)(this.spqcc[0][0] & 0x7FF) / 2048.0f) / (float)(-1 << exp);
                            str = String.valueOf(str) + "\tr=0 : " + exp + " / " + mantissa + "\n";
                        } else if (i != 0 && j > 0) {
                            exp = this.spqcc[i][j] >> 11 & 0x1F;
                            mantissa = (-1.0f - (float)(this.spqcc[i][j] & 0x7FF) / 2048.0f) / (float)(-1 << exp);
                            str = String.valueOf(str) + "\tr=" + i + ",s=" + j + " : " + exp + " / " + mantissa + "\n";
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class POC {
        public int lpoc;
        public int[] rspoc;
        public int[] cspoc;
        public int[] lyepoc;
        public int[] repoc;
        public int[] cepoc;
        public int[] ppoc;

        public String toString() {
            String str = "\n --- POC (" + this.lpoc + " bytes) ---\n";
            str = String.valueOf(str) + " Chg_idx RSpoc CSpoc LYEpoc REpoc CEpoc Ppoc\n";
            int chg = 0;
            while (chg < this.rspoc.length) {
                str = String.valueOf(str) + "   " + chg + "      " + this.rspoc[chg] + "     " + this.cspoc[chg] + "     " + this.lyepoc[chg] + "      " + this.repoc[chg] + "     " + this.cepoc[chg];
                switch (this.ppoc[chg]) {
                    case 0: {
                        str = String.valueOf(str) + "  LY_RES_COMP_POS_PROG\n";
                        break;
                    }
                    case 1: {
                        str = String.valueOf(str) + "  RES_LY_COMP_POS_PROG\n";
                        break;
                    }
                    case 2: {
                        str = String.valueOf(str) + "  RES_POS_COMP_LY_PROG\n";
                        break;
                    }
                    case 3: {
                        str = String.valueOf(str) + "  POS_COMP_RES_LY_PROG\n";
                        break;
                    }
                    case 4: {
                        str = String.valueOf(str) + "  COMP_POS_RES_LY_PROG\n";
                    }
                }
                ++chg;
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class CRG {
        public int lcrg;
        public int[] xcrg;
        public int[] ycrg;

        public String toString() {
            String str = "\n --- CRG (" + this.lcrg + " bytes) ---\n";
            int c = 0;
            while (c < this.xcrg.length) {
                str = String.valueOf(str) + " Component " + c + " offset : " + this.xcrg[c] + "," + this.ycrg[c] + "\n";
                ++c;
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }

    public class COM {
        public int lcom;
        public int rcom;
        public byte[] ccom;

        public String toString() {
            String str = "\n --- COM (" + this.lcom + " bytes) ---\n";
            if (this.rcom == 0) {
                str = String.valueOf(str) + " Registration : General use (binary values)\n";
            } else if (this.rcom == 1) {
                str = String.valueOf(str) + " Registration : General use (IS 8859-15:1999 (Latin) values)\n";
                str = String.valueOf(str) + " Text         : " + new String(this.ccom) + "\n";
            } else {
                str = String.valueOf(str) + " Registration : Unknown\n";
            }
            str = String.valueOf(str) + "\n";
            return str;
        }
    }
}

