/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.io.BinaryDataOutput;
import jj2000.j2k.quantization.quantizer.StdQuantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class HeaderEncoder
implements Markers,
StdEntropyCoderOptions {
    public static final char OPT_PREFIX = 'H';
    private static final String[][] pinfo;
    private int defimgn;
    private int deftilenr;
    private int nComp;
    private boolean enJJ2KMarkSeg = true;
    private String otherCOMMarkSeg = null;
    protected ByteArrayOutputStream baos;
    protected DataOutputStream hbuf;
    protected ImgData origSrc;
    protected boolean[] isOrigSig;
    protected PostCompRateAllocator ralloc;
    protected ForwardWT dwt;
    protected Tiler tiler;
    protected ROIScaler roiSc;
    protected EncoderSpecs encSpec;

    static {
        String[][] stringArrayArray = new String[2][];
        String[] stringArray = new String[4];
        stringArray[0] = "Hjj2000_COM";
        stringArray[2] = "Writes or not the JJ2000 COM marker in the codestream";
        stringArray[3] = "on";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[0] = "HCOM";
        stringArray2[1] = "<Comment 1>[#<Comment 2>[#<Comment3...>]]";
        stringArray2[2] = "Adds COM marker segments in the codestream. Comments must be separated with '#' and are written into distinct maker segments.";
        stringArrayArray[1] = stringArray2;
        pinfo = stringArrayArray;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public HeaderEncoder(ImgData origsrc, boolean[] isorigsig, ForwardWT dwt, Tiler tiler, EncoderSpecs encSpec, ROIScaler roiSc, PostCompRateAllocator ralloc, ParameterList pl) {
        pl.checkList('H', ParameterList.toNameArray(pinfo));
        if (origsrc.getNumComps() != isorigsig.length) {
            throw new IllegalArgumentException();
        }
        this.origSrc = origsrc;
        this.isOrigSig = isorigsig;
        this.dwt = dwt;
        this.tiler = tiler;
        this.encSpec = encSpec;
        this.roiSc = roiSc;
        this.ralloc = ralloc;
        this.baos = new ByteArrayOutputStream();
        this.hbuf = new DataOutputStream(this.baos);
        this.nComp = origsrc.getNumComps();
        this.enJJ2KMarkSeg = pl.getBooleanParameter("Hjj2000_COM");
        this.otherCOMMarkSeg = pl.getParameter("HCOM");
    }

    public void reset() {
        this.baos.reset();
        this.hbuf = new DataOutputStream(this.baos);
    }

    protected byte[] getBuffer() {
        return this.baos.toByteArray();
    }

    public int getLength() {
        return this.hbuf.size();
    }

    public void writeTo(BinaryDataOutput out) throws IOException {
        byte[] buf = this.getBuffer();
        int len = this.getLength();
        int i = 0;
        while (i < len) {
            out.writeByte(buf[i]);
            ++i;
        }
    }

    protected int getBufferLength() {
        return this.baos.size();
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.getBuffer(), 0, this.getBufferLength());
    }

    private void writeSOC() throws IOException {
        this.hbuf.writeShort(-177);
    }

    private void writeSIZ() throws IOException {
        this.hbuf.writeShort(-175);
        int markSegLen = 38 + 3 * this.nComp;
        this.hbuf.writeShort(markSegLen);
        this.hbuf.writeShort(0);
        this.hbuf.writeInt(this.tiler.getImgWidth() + this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgHeight() + this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getNomTileWidth());
        this.hbuf.writeInt(this.tiler.getNomTileHeight());
        Coord torig = this.tiler.getTilingOrigin(null);
        this.hbuf.writeInt(torig.x);
        this.hbuf.writeInt(torig.y);
        this.hbuf.writeShort(this.nComp);
        int c = 0;
        while (c < this.nComp) {
            int tmp = this.origSrc.getNomRangeBits(c) - 1;
            this.hbuf.write(tmp |= (this.isOrigSig[c] ? 1 : 0) << 7);
            this.hbuf.write(this.tiler.getCompSubsX(c));
            this.hbuf.write(this.tiler.getCompSubsY(c));
            ++c;
        }
    }

    protected void writeCOD(boolean mh, int tileIdx) throws IOException {
        AnWTFilter[][] filt;
        Progression[] prog;
        int mrl = 0;
        int a = 0;
        int ppx = 0;
        int ppy = 0;
        if (mh) {
            mrl = (Integer)this.encSpec.dls.getDefault();
            ppx = this.encSpec.pss.getPPX(-1, -1, mrl);
            ppy = this.encSpec.pss.getPPY(-1, -1, mrl);
            prog = (Progression[])this.encSpec.pocs.getDefault();
        } else {
            mrl = (Integer)this.encSpec.dls.getTileDef(tileIdx);
            ppx = this.encSpec.pss.getPPX(tileIdx, -1, mrl);
            ppy = this.encSpec.pss.getPPY(tileIdx, -1, mrl);
            prog = (Progression[])this.encSpec.pocs.getTileDef(tileIdx);
        }
        boolean precinctPartitionUsed = ppx != 65535 || ppy != 65535;
        if (precinctPartitionUsed) {
            a = mrl + 1;
        }
        this.hbuf.writeShort(-174);
        int markSegLen = 12 + a;
        this.hbuf.writeShort(markSegLen);
        int tmp = 0;
        if (precinctPartitionUsed) {
            tmp = 1;
        }
        if (mh) {
            if (this.encSpec.sops.getDefault().toString().equalsIgnoreCase("on")) {
                tmp |= 2;
            }
        } else if (this.encSpec.sops.getTileDef(tileIdx).toString().equalsIgnoreCase("on")) {
            tmp |= 2;
        }
        if (mh) {
            if (this.encSpec.ephs.getDefault().toString().equalsIgnoreCase("on")) {
                tmp |= 4;
            }
        } else if (this.encSpec.ephs.getTileDef(tileIdx).toString().equalsIgnoreCase("on")) {
            tmp |= 4;
        }
        if (this.dwt.getCbULX() != 0) {
            tmp |= 8;
        }
        if (this.dwt.getCbULY() != 0) {
            tmp |= 0x10;
        }
        this.hbuf.write(tmp);
        this.hbuf.write(prog[0].type);
        this.hbuf.writeShort(this.ralloc.getNumLayers());
        String str = null;
        str = mh ? (String)this.encSpec.cts.getDefault() : (String)this.encSpec.cts.getTileDef(tileIdx);
        if (str.equals("none")) {
            this.hbuf.write(0);
        } else {
            this.hbuf.write(1);
        }
        this.hbuf.write(mrl);
        if (mh) {
            tmp = this.encSpec.cblks.getCBlkWidth((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.encSpec.cblks.getCBlkHeight((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        } else {
            tmp = this.encSpec.cblks.getCBlkWidth((byte)2, tileIdx, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.encSpec.cblks.getCBlkHeight((byte)2, tileIdx, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        }
        tmp = 0;
        if (mh) {
            if (((String)this.encSpec.bms.getDefault()).equals("on")) {
                tmp |= 1;
            }
            if (((String)this.encSpec.mqrs.getDefault()).equals("on")) {
                tmp |= 2;
            }
            if (((String)this.encSpec.rts.getDefault()).equals("on")) {
                tmp |= 4;
            }
            if (((String)this.encSpec.css.getDefault()).equals("on")) {
                tmp |= 8;
            }
            if (((String)this.encSpec.tts.getDefault()).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.encSpec.sss.getDefault()).equals("on")) {
                tmp |= 0x20;
            }
        } else {
            if (((String)this.encSpec.bms.getTileDef(tileIdx)).equals("on")) {
                tmp |= 1;
            }
            if (((String)this.encSpec.mqrs.getTileDef(tileIdx)).equals("on")) {
                tmp |= 2;
            }
            if (((String)this.encSpec.rts.getTileDef(tileIdx)).equals("on")) {
                tmp |= 4;
            }
            if (((String)this.encSpec.css.getTileDef(tileIdx)).equals("on")) {
                tmp |= 8;
            }
            if (((String)this.encSpec.tts.getTileDef(tileIdx)).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.encSpec.sss.getTileDef(tileIdx)).equals("on")) {
                tmp |= 0x20;
            }
        }
        this.hbuf.write(tmp);
        if (mh) {
            filt = (AnWTFilter[][])this.encSpec.wfs.getDefault();
            this.hbuf.write(filt[0][0].getFilterType());
        } else {
            filt = (AnWTFilter[][])this.encSpec.wfs.getTileDef(tileIdx);
            this.hbuf.write(filt[0][0].getFilterType());
        }
        if (precinctPartitionUsed) {
            Vector[] v = null;
            v = mh ? (Vector[])this.encSpec.pss.getDefault() : (Vector[])this.encSpec.pss.getTileDef(tileIdx);
            int r = mrl;
            while (r >= 0) {
                tmp = r >= v[1].size() ? ((Integer)v[1].elementAt(v[1].size() - 1)).intValue() : ((Integer)v[1].elementAt(r)).intValue();
                int yExp = MathUtil.log2(tmp) << 4 & 0xF0;
                tmp = r >= v[0].size() ? ((Integer)v[0].elementAt(v[0].size() - 1)).intValue() : ((Integer)v[0].elementAt(r)).intValue();
                int xExp = MathUtil.log2(tmp) & 0xF;
                this.hbuf.write(yExp | xExp);
                --r;
            }
        }
    }

    protected void writeCOC(boolean mh, int tileIdx, int compIdx) throws IOException {
        AnWTFilter[][] filt;
        Progression[] prog;
        int mrl = 0;
        int a = 0;
        int ppx = 0;
        int ppy = 0;
        if (mh) {
            mrl = (Integer)this.encSpec.dls.getCompDef(compIdx);
            ppx = this.encSpec.pss.getPPX(-1, compIdx, mrl);
            ppy = this.encSpec.pss.getPPY(-1, compIdx, mrl);
            prog = (Progression[])this.encSpec.pocs.getCompDef(compIdx);
        } else {
            mrl = (Integer)this.encSpec.dls.getTileCompVal(tileIdx, compIdx);
            ppx = this.encSpec.pss.getPPX(tileIdx, compIdx, mrl);
            ppy = this.encSpec.pss.getPPY(tileIdx, compIdx, mrl);
            prog = (Progression[])this.encSpec.pocs.getTileCompVal(tileIdx, compIdx);
        }
        boolean precinctPartitionUsed = ppx != 65535 || ppy != 65535;
        if (precinctPartitionUsed) {
            a = mrl + 1;
        }
        this.hbuf.writeShort(-173);
        int markSegLen = 8 + (this.nComp < 257 ? 1 : 2) + a;
        this.hbuf.writeShort(markSegLen);
        if (this.nComp < 257) {
            this.hbuf.write(compIdx);
        } else {
            this.hbuf.writeShort(compIdx);
        }
        int tmp = 0;
        if (precinctPartitionUsed) {
            tmp = 1;
        }
        this.hbuf.write(tmp);
        this.hbuf.write(mrl);
        if (mh) {
            tmp = this.encSpec.cblks.getCBlkWidth((byte)1, -1, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.encSpec.cblks.getCBlkHeight((byte)1, -1, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        } else {
            tmp = this.encSpec.cblks.getCBlkWidth((byte)3, tileIdx, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.encSpec.cblks.getCBlkHeight((byte)3, tileIdx, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        }
        tmp = 0;
        if (mh) {
            if (((String)this.encSpec.bms.getCompDef(compIdx)).equals("on")) {
                tmp |= 1;
            }
            if (((String)this.encSpec.mqrs.getCompDef(compIdx)).equalsIgnoreCase("on")) {
                tmp |= 2;
            }
            if (((String)this.encSpec.rts.getCompDef(compIdx)).equals("on")) {
                tmp |= 4;
            }
            if (((String)this.encSpec.css.getCompDef(compIdx)).equals("on")) {
                tmp |= 8;
            }
            if (((String)this.encSpec.tts.getCompDef(compIdx)).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.encSpec.sss.getCompDef(compIdx)).equals("on")) {
                tmp |= 0x20;
            }
        } else {
            if (((String)this.encSpec.bms.getTileCompVal(tileIdx, compIdx)).equals("on")) {
                tmp |= 1;
            }
            if (((String)this.encSpec.mqrs.getTileCompVal(tileIdx, compIdx)).equals("on")) {
                tmp |= 2;
            }
            if (((String)this.encSpec.rts.getTileCompVal(tileIdx, compIdx)).equals("on")) {
                tmp |= 4;
            }
            if (((String)this.encSpec.css.getTileCompVal(tileIdx, compIdx)).equals("on")) {
                tmp |= 8;
            }
            if (((String)this.encSpec.tts.getTileCompVal(tileIdx, compIdx)).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.encSpec.sss.getTileCompVal(tileIdx, compIdx)).equals("on")) {
                tmp |= 0x20;
            }
        }
        this.hbuf.write(tmp);
        if (mh) {
            filt = (AnWTFilter[][])this.encSpec.wfs.getCompDef(compIdx);
            this.hbuf.write(filt[0][0].getFilterType());
        } else {
            filt = (AnWTFilter[][])this.encSpec.wfs.getTileCompVal(tileIdx, compIdx);
            this.hbuf.write(filt[0][0].getFilterType());
        }
        if (precinctPartitionUsed) {
            Vector[] v = null;
            v = mh ? (Vector[])this.encSpec.pss.getCompDef(compIdx) : (Vector[])this.encSpec.pss.getTileCompVal(tileIdx, compIdx);
            int r = mrl;
            while (r >= 0) {
                tmp = r >= v[1].size() ? ((Integer)v[1].elementAt(v[1].size() - 1)).intValue() : ((Integer)v[1].elementAt(r)).intValue();
                int yExp = MathUtil.log2(tmp) << 4 & 0xF0;
                tmp = r >= v[0].size() ? ((Integer)v[0].elementAt(v[0].size() - 1)).intValue() : ((Integer)v[0].elementAt(r)).intValue();
                int xExp = MathUtil.log2(tmp) & 0xF;
                this.hbuf.write(yExp | xExp);
                --r;
            }
        }
    }

    protected void writeMainQCD() throws IOException {
        int nqcd;
        String qType = (String)this.encSpec.qts.getDefault();
        float baseStep = ((Float)this.encSpec.qsss.getDefault()).floatValue();
        int gb = (Integer)this.encSpec.gbs.getDefault();
        boolean isDerived = qType.equals("derived");
        boolean isReversible = qType.equals("reversible");
        int mrl = (Integer)this.encSpec.dls.getDefault();
        int nt = this.dwt.getNumTiles();
        int nc = this.dwt.getNumComps();
        int[] tcIdx = new int[2];
        boolean notFound = true;
        int t = 0;
        while (t < nt && notFound) {
            int c = 0;
            while (c < nc && notFound) {
                int tmpI = (Integer)this.encSpec.dls.getTileCompVal(t, c);
                String tmpStr = (String)this.encSpec.qts.getTileCompVal(t, c);
                if (tmpI == mrl && tmpStr.equals(qType)) {
                    tcIdx[0] = t;
                    tcIdx[1] = c;
                    notFound = false;
                }
                ++c;
            }
            ++t;
        }
        if (notFound) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in main QCD marker segment. You have found a JJ2000 bug.");
        }
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(tcIdx[0], tcIdx[1]);
        this.defimgn = this.dwt.getNomRangeBits(tcIdx[1]);
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-164);
        switch (qstyle) {
            case 1: {
                nqcd = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcd = 0;
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    SubbandAn csb = sb;
                    while (csb != null) {
                        ++nqcd;
                        csb = (SubbandAn)csb.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (isReversible ? nqcd : 2 * nqcd);
        this.hbuf.writeShort(markSegLen);
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    SubbandAn csb = sb;
                    while (csb != null) {
                        int tmp = this.defimgn + csb.anGainExp;
                        this.hbuf.write(tmp << 3);
                        csb = (SubbandAn)csb.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            case 1: {
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    SubbandAn csb = sb;
                    while (csb != null) {
                        float step = baseStep / (csb.l2Norm * (float)(1 << csb.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                        csb = (SubbandAn)csb.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeMainQCC(int compIdx) throws IOException {
        SubbandAn sb2;
        SubbandAn sb;
        int nqcc;
        int tIdx = 0;
        int imgnr = this.dwt.getNomRangeBits(compIdx);
        String qType = (String)this.encSpec.qts.getCompDef(compIdx);
        float baseStep = ((Float)this.encSpec.qsss.getCompDef(compIdx)).floatValue();
        int gb = (Integer)this.encSpec.gbs.getCompDef(compIdx);
        boolean isReversible = qType.equals("reversible");
        boolean isDerived = qType.equals("derived");
        int mrl = (Integer)this.encSpec.dls.getCompDef(compIdx);
        int nt = this.dwt.getNumTiles();
        int nc = this.dwt.getNumComps();
        boolean notFound = true;
        int t = 0;
        while (t < nt && notFound) {
            int c = 0;
            while (c < nc && notFound) {
                int tmpI = (Integer)this.encSpec.dls.getTileCompVal(t, c);
                String tmpStr = (String)this.encSpec.qts.getTileCompVal(t, c);
                if (tmpI == mrl && tmpStr.equals(qType)) {
                    tIdx = t;
                    notFound = false;
                }
                ++c;
            }
            ++t;
        }
        if (notFound) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in main QCC (c=" + compIdx + ") marker segment. " + "You have found a JJ2000 bug.");
        }
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(tIdx, compIdx);
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (qstyle) {
            case 1: {
                nqcc = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcc = 0;
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                while (sb.resLvl != 0) {
                    sb = sb.subb_LL;
                }
                int j = 0;
                while (j <= mrl) {
                    sb2 = sb;
                    while (sb2 != null) {
                        ++nqcc;
                        sb2 = (SubbandAn)sb2.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (this.nComp < 257 ? 1 : 2) + (isReversible ? nqcc : 2 * nqcc);
        this.hbuf.writeShort(markSegLen);
        if (this.nComp < 257) {
            this.hbuf.write(compIdx);
        } else {
            this.hbuf.writeShort(compIdx);
        }
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    sb2 = sb;
                    while (sb2 != null) {
                        int tmp = imgnr + sb2.anGainExp;
                        this.hbuf.write(tmp << 3);
                        sb2 = (SubbandAn)sb2.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            case 1: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    sb2 = sb;
                    while (sb2 != null) {
                        float step = baseStep / (sb2.l2Norm * (float)(1 << sb2.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                        sb2 = (SubbandAn)sb2.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeTileQCD(int tIdx) throws IOException {
        SubbandAn csb;
        SubbandAn sb;
        int nqcd;
        String qType = (String)this.encSpec.qts.getTileDef(tIdx);
        float baseStep = ((Float)this.encSpec.qsss.getTileDef(tIdx)).floatValue();
        int mrl = (Integer)this.encSpec.dls.getTileDef(tIdx);
        int nc = this.dwt.getNumComps();
        boolean notFound = true;
        int compIdx = 0;
        int c = 0;
        while (c < nc && notFound) {
            int tmpI = (Integer)this.encSpec.dls.getTileCompVal(tIdx, c);
            String tmpStr = (String)this.encSpec.qts.getTileCompVal(tIdx, c);
            if (tmpI == mrl && tmpStr.equals(qType)) {
                compIdx = c;
                notFound = false;
            }
            ++c;
        }
        if (notFound) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in tile QCD (t=" + tIdx + ") marker segment. " + "You have found a JJ2000 bug.");
        }
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(tIdx, compIdx);
        this.deftilenr = this.dwt.getNomRangeBits(compIdx);
        int gb = (Integer)this.encSpec.gbs.getTileDef(tIdx);
        boolean isDerived = qType.equals("derived");
        boolean isReversible = qType.equals("reversible");
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-164);
        switch (qstyle) {
            case 1: {
                nqcd = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcd = 0;
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    csb = sb;
                    while (csb != null) {
                        ++nqcd;
                        csb = (SubbandAn)csb.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (isReversible ? nqcd : 2 * nqcd);
        this.hbuf.writeShort(markSegLen);
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    csb = sb;
                    while (csb != null) {
                        int tmp = this.deftilenr + csb.anGainExp;
                        this.hbuf.write(tmp << 3);
                        csb = (SubbandAn)csb.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            case 1: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    csb = sb;
                    while (csb != null) {
                        float step = baseStep / (csb.l2Norm * (float)(1 << csb.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                        csb = (SubbandAn)csb.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeTileQCC(int t, int compIdx) throws IOException {
        SubbandAn sb2;
        SubbandAn sb;
        int nqcc;
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(t, compIdx);
        int imgnr = this.dwt.getNomRangeBits(compIdx);
        String qType = (String)this.encSpec.qts.getTileCompVal(t, compIdx);
        float baseStep = ((Float)this.encSpec.qsss.getTileCompVal(t, compIdx)).floatValue();
        int gb = (Integer)this.encSpec.gbs.getTileCompVal(t, compIdx);
        boolean isReversible = qType.equals("reversible");
        boolean isDerived = qType.equals("derived");
        int mrl = (Integer)this.encSpec.dls.getTileCompVal(t, compIdx);
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (qstyle) {
            case 1: {
                nqcc = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcc = 0;
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                while (sb.resLvl != 0) {
                    sb = sb.subb_LL;
                }
                int j = 0;
                while (j <= mrl) {
                    sb2 = sb;
                    while (sb2 != null) {
                        ++nqcc;
                        sb2 = (SubbandAn)sb2.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (this.nComp < 257 ? 1 : 2) + (isReversible ? nqcc : 2 * nqcc);
        this.hbuf.writeShort(markSegLen);
        if (this.nComp < 257) {
            this.hbuf.write(compIdx);
        } else {
            this.hbuf.writeShort(compIdx);
        }
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    sb2 = sb;
                    while (sb2 != null) {
                        int tmp = imgnr + sb2.anGainExp;
                        this.hbuf.write(tmp << 3);
                        sb2 = (SubbandAn)sb2.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            case 1: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                int j = 0;
                while (j <= mrl) {
                    sb2 = sb;
                    while (sb2 != null) {
                        float step = baseStep / (sb2.l2Norm * (float)(1 << sb2.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                        sb2 = (SubbandAn)sb2.nextSubband();
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                    ++j;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writePOC(boolean mh, int tileIdx) throws IOException {
        int markSegLen = 0;
        Progression[] prog = null;
        prog = mh ? (Progression[])this.encSpec.pocs.getDefault() : (Progression[])this.encSpec.pocs.getTileDef(tileIdx);
        int lenCompField = this.nComp < 257 ? 1 : 2;
        this.hbuf.writeShort(-161);
        int npoc = prog.length;
        markSegLen = 2 + npoc * (1 + lenCompField + 2 + 1 + lenCompField + 1);
        this.hbuf.writeShort(markSegLen);
        int i = 0;
        while (i < npoc) {
            this.hbuf.write(prog[i].rs);
            if (lenCompField == 2) {
                this.hbuf.writeShort(prog[i].cs);
            } else {
                this.hbuf.write(prog[i].cs);
            }
            this.hbuf.writeShort(prog[i].lye);
            this.hbuf.write(prog[i].re);
            if (lenCompField == 2) {
                this.hbuf.writeShort(prog[i].ce);
            } else {
                this.hbuf.write(prog[i].ce);
            }
            this.hbuf.write(prog[i].type);
            ++i;
        }
    }

    public void encodeMainHeader() throws IOException {
        this.writeSOC();
        this.writeSIZ();
        boolean isEresUsed = ((String)this.encSpec.tts.getDefault()).equals("predict");
        this.writeCOD(true, 0);
        int i = 0;
        while (i < this.nComp) {
            boolean isEresUsedinComp = ((String)this.encSpec.tts.getCompDef(i)).equals("predict");
            if (this.encSpec.wfs.isCompSpecified(i) || this.encSpec.dls.isCompSpecified(i) || this.encSpec.bms.isCompSpecified(i) || this.encSpec.mqrs.isCompSpecified(i) || this.encSpec.rts.isCompSpecified(i) || this.encSpec.sss.isCompSpecified(i) || this.encSpec.css.isCompSpecified(i) || this.encSpec.pss.isCompSpecified(i) || this.encSpec.cblks.isCompSpecified(i) || isEresUsed != isEresUsedinComp) {
                this.writeCOC(true, 0, i);
            }
            ++i;
        }
        this.writeMainQCD();
        i = 0;
        while (i < this.nComp) {
            if (this.dwt.getNomRangeBits(i) != this.defimgn || this.encSpec.qts.isCompSpecified(i) || this.encSpec.qsss.isCompSpecified(i) || this.encSpec.dls.isCompSpecified(i) || this.encSpec.gbs.isCompSpecified(i)) {
                this.writeMainQCC(i);
            }
            ++i;
        }
        Progression[] prog = (Progression[])this.encSpec.pocs.getDefault();
        if (prog.length > 1) {
            this.writePOC(true, 0);
        }
        this.writeCOM();
    }

    private void writeCOM() throws IOException {
        if (this.enJJ2KMarkSeg) {
            String str = "Created by: JJ2000 version 5.1";
            this.hbuf.writeShort(-156);
            int markSegLen = 4 + str.length();
            this.hbuf.writeShort(markSegLen);
            this.hbuf.writeShort(1);
            byte[] chars = str.getBytes();
            int i = 0;
            while (i < chars.length) {
                this.hbuf.writeByte(chars[i]);
                ++i;
            }
        }
        if (this.otherCOMMarkSeg != null) {
            StringTokenizer stk = new StringTokenizer(this.otherCOMMarkSeg, "#");
            while (stk.hasMoreTokens()) {
                String str = stk.nextToken();
                this.hbuf.writeShort(-156);
                int markSegLen = 4 + str.length();
                this.hbuf.writeShort(markSegLen);
                this.hbuf.writeShort(1);
                byte[] chars = str.getBytes();
                int i = 0;
                while (i < chars.length) {
                    this.hbuf.writeByte(chars[i]);
                    ++i;
                }
            }
        }
    }

    private void writeRGN(int tIdx) throws IOException {
        int i = 0;
        while (i < this.nComp) {
            this.hbuf.writeShort(-162);
            int markSegLen = 4 + (this.nComp < 257 ? 1 : 2);
            this.hbuf.writeShort(markSegLen);
            if (this.nComp < 257) {
                this.hbuf.writeByte(i);
            } else {
                this.hbuf.writeShort(i);
            }
            this.hbuf.writeByte(0);
            this.hbuf.writeByte((Integer)this.encSpec.rois.getTileCompVal(tIdx, i));
            ++i;
        }
    }

    public void encodeTilePartHeader(int tileLength, int tileIdx) throws IOException {
        Progression[] prog;
        Coord numTiles = this.ralloc.getNumTiles(null);
        this.ralloc.setTile(tileIdx % numTiles.x, tileIdx / numTiles.x);
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-112);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(10);
        if (tileIdx > 65534) {
            throw new IllegalArgumentException("Trying to write a tile-part header whose tile index is too high");
        }
        this.hbuf.writeByte(tileIdx >> 8);
        this.hbuf.writeByte(tileIdx);
        int tmp = tileLength;
        this.hbuf.writeByte(tmp >> 24);
        this.hbuf.writeByte(tmp >> 16);
        this.hbuf.writeByte(tmp >> 8);
        this.hbuf.writeByte(tmp);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(1);
        boolean isEresUsed = ((String)this.encSpec.tts.getDefault()).equals("predict");
        boolean isEresUsedInTile = ((String)this.encSpec.tts.getTileDef(tileIdx)).equals("predict");
        boolean tileCODwritten = false;
        if (this.encSpec.wfs.isTileSpecified(tileIdx) || this.encSpec.cts.isTileSpecified(tileIdx) || this.encSpec.dls.isTileSpecified(tileIdx) || this.encSpec.bms.isTileSpecified(tileIdx) || this.encSpec.mqrs.isTileSpecified(tileIdx) || this.encSpec.rts.isTileSpecified(tileIdx) || this.encSpec.css.isTileSpecified(tileIdx) || this.encSpec.pss.isTileSpecified(tileIdx) || this.encSpec.sops.isTileSpecified(tileIdx) || this.encSpec.sss.isTileSpecified(tileIdx) || this.encSpec.pocs.isTileSpecified(tileIdx) || this.encSpec.ephs.isTileSpecified(tileIdx) || this.encSpec.cblks.isTileSpecified(tileIdx) || isEresUsed != isEresUsedInTile) {
            this.writeCOD(false, tileIdx);
            tileCODwritten = true;
        }
        int c = 0;
        while (c < this.nComp) {
            boolean isEresUsedInTileComp = ((String)this.encSpec.tts.getTileCompVal(tileIdx, c)).equals("predict");
            if (this.encSpec.wfs.isTileCompSpecified(tileIdx, c) || this.encSpec.dls.isTileCompSpecified(tileIdx, c) || this.encSpec.bms.isTileCompSpecified(tileIdx, c) || this.encSpec.mqrs.isTileCompSpecified(tileIdx, c) || this.encSpec.rts.isTileCompSpecified(tileIdx, c) || this.encSpec.css.isTileCompSpecified(tileIdx, c) || this.encSpec.pss.isTileCompSpecified(tileIdx, c) || this.encSpec.sss.isTileCompSpecified(tileIdx, c) || this.encSpec.cblks.isTileCompSpecified(tileIdx, c) || isEresUsedInTileComp != isEresUsed) {
                this.writeCOC(false, tileIdx, c);
            } else if (tileCODwritten && (this.encSpec.wfs.isCompSpecified(c) || this.encSpec.dls.isCompSpecified(c) || this.encSpec.bms.isCompSpecified(c) || this.encSpec.mqrs.isCompSpecified(c) || this.encSpec.rts.isCompSpecified(c) || this.encSpec.sss.isCompSpecified(c) || this.encSpec.css.isCompSpecified(c) || this.encSpec.pss.isCompSpecified(c) || this.encSpec.cblks.isCompSpecified(c) || this.encSpec.tts.isCompSpecified(c) && ((String)this.encSpec.tts.getCompDef(c)).equals("predict"))) {
                this.writeCOC(false, tileIdx, c);
            }
            ++c;
        }
        boolean tileQCDwritten = false;
        if (this.encSpec.qts.isTileSpecified(tileIdx) || this.encSpec.qsss.isTileSpecified(tileIdx) || this.encSpec.dls.isTileSpecified(tileIdx) || this.encSpec.gbs.isTileSpecified(tileIdx)) {
            this.writeTileQCD(tileIdx);
            tileQCDwritten = true;
        } else {
            this.deftilenr = this.defimgn;
        }
        int c2 = 0;
        while (c2 < this.nComp) {
            if (this.dwt.getNomRangeBits(c2) != this.deftilenr || this.encSpec.qts.isTileCompSpecified(tileIdx, c2) || this.encSpec.qsss.isTileCompSpecified(tileIdx, c2) || this.encSpec.dls.isTileCompSpecified(tileIdx, c2) || this.encSpec.gbs.isTileCompSpecified(tileIdx, c2)) {
                this.writeTileQCC(tileIdx, c2);
            } else if (tileQCDwritten && (this.encSpec.qts.isCompSpecified(c2) || this.encSpec.qsss.isCompSpecified(c2) || this.encSpec.dls.isCompSpecified(c2) || this.encSpec.gbs.isCompSpecified(c2))) {
                this.writeTileQCC(tileIdx, c2);
            }
            ++c2;
        }
        if (this.roiSc.useRoi() && !this.roiSc.getBlockAligned()) {
            this.writeRGN(tileIdx);
        }
        if (this.encSpec.pocs.isTileSpecified(tileIdx) && (prog = (Progression[])this.encSpec.pocs.getTileDef(tileIdx)).length > 1) {
            this.writePOC(false, tileIdx);
        }
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-109);
    }
}

