/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy;

import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.IntegerSpec;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.util.ParameterList;

public class ProgressionSpec
extends ModuleSpec {
    public ProgressionSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
        if (type != 1) {
            throw new Error("Illegal use of class ProgressionSpec !");
        }
    }

    public ProgressionSpec(int nt, int nc, int nl, IntegerSpec dls, byte type, ParameterList pl) {
        super(nt, nc, type);
        int i;
        Object[] prog;
        String param = pl.getParameter("Aptype");
        int mode = -1;
        if (param == null) {
            mode = pl.getParameter("Rroi") == null ? this.checkProgMode("res") : this.checkProgMode("layer");
            if (mode == -1) {
                String errMsg = "Unknown progression type : '" + param + "'";
                throw new IllegalArgumentException(errMsg);
            }
            Progression[] prog2 = new Progression[]{new Progression(mode, 0, nc, 0, dls.getMax() + 1, nl)};
            this.setDefault(prog2);
            return;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        String word = null;
        String errMsg = null;
        boolean needInteger = false;
        int intType = 0;
        Vector<Progression> progression = new Vector<Progression>();
        int tmp = 0;
        Progression curProg = null;
        block17: while (stk.hasMoreTokens()) {
            word = stk.nextToken();
            switch (word.charAt(0)) {
                case 't': {
                    if (progression.size() > 0) {
                        curProg.ce = nc;
                        curProg.lye = nl;
                        curProg.re = dls.getMax() + 1;
                        prog = new Progression[progression.size()];
                        progression.copyInto(prog);
                        if (curSpecType == 0) {
                            this.setDefault(prog);
                        } else if (curSpecType == 2) {
                            i = tileSpec.length - 1;
                            while (i >= 0) {
                                if (tileSpec[i]) {
                                    this.setTileDef(i, prog);
                                }
                                --i;
                            }
                        }
                    }
                    progression.removeAllElements();
                    intType = -1;
                    needInteger = false;
                    tileSpec = ProgressionSpec.parseIdx(word, this.nTiles);
                    curSpecType = 2;
                    break;
                }
                default: {
                    if (needInteger) {
                        try {
                            tmp = new Integer(word);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Progression order specification has missing parameters: " + param);
                        }
                        switch (intType) {
                            case 0: {
                                if (tmp < 0 || tmp > dls.getMax() + 1) {
                                    throw new IllegalArgumentException("Invalid res_start in '-Aptype' option: " + tmp);
                                }
                                curProg.rs = tmp;
                                break;
                            }
                            case 1: {
                                if (tmp < 0 || tmp > nc) {
                                    throw new IllegalArgumentException("Invalid comp_start in '-Aptype' option: " + tmp);
                                }
                                curProg.cs = tmp;
                                break;
                            }
                            case 2: {
                                if (tmp < 0) {
                                    throw new IllegalArgumentException("Invalid layer_end in '-Aptype' option: " + tmp);
                                }
                                if (tmp > nl) {
                                    tmp = nl;
                                }
                                curProg.lye = tmp;
                                break;
                            }
                            case 3: {
                                if (tmp < 0) {
                                    throw new IllegalArgumentException("Invalid res_end in '-Aptype' option: " + tmp);
                                }
                                if (tmp > dls.getMax() + 1) {
                                    tmp = dls.getMax() + 1;
                                }
                                curProg.re = tmp;
                                break;
                            }
                            case 4: {
                                if (tmp < 0) {
                                    throw new IllegalArgumentException("Invalid comp_end in '-Aptype' option: " + tmp);
                                }
                                if (tmp > nc) {
                                    tmp = nc;
                                }
                                curProg.ce = tmp;
                            }
                        }
                        if (intType < 4) {
                            ++intType;
                            needInteger = true;
                            break;
                        }
                        if (intType == 4) {
                            intType = 0;
                            needInteger = false;
                            break;
                        }
                        throw new Error("Error in usage of 'Aptype' option: " + param);
                    }
                    if (needInteger) continue block17;
                    mode = this.checkProgMode(word);
                    if (mode == -1) {
                        errMsg = "Unknown progression type : '" + word + "'";
                        throw new IllegalArgumentException(errMsg);
                    }
                    needInteger = true;
                    intType = 0;
                    curProg = progression.size() == 0 ? new Progression(mode, 0, nc, 0, dls.getMax() + 1, nl) : new Progression(mode, 0, nc, 0, dls.getMax() + 1, nl);
                    progression.addElement(curProg);
                }
            }
        }
        if (progression.size() == 0) {
            mode = pl.getParameter("Rroi") == null ? this.checkProgMode("res") : this.checkProgMode("layer");
            if (mode == -1) {
                errMsg = "Unknown progression type : '" + param + "'";
                throw new IllegalArgumentException(errMsg);
            }
            prog = new Progression[]{new Progression(mode, 0, nc, 0, dls.getMax() + 1, nl)};
            this.setDefault(prog);
            return;
        }
        curProg.ce = nc;
        curProg.lye = nl;
        curProg.re = dls.getMax() + 1;
        prog = new Progression[progression.size()];
        progression.copyInto(prog);
        if (curSpecType == 0) {
            this.setDefault(prog);
        } else if (curSpecType == 2) {
            i = tileSpec.length - 1;
            while (i >= 0) {
                if (tileSpec[i]) {
                    this.setTileDef(i, prog);
                }
                --i;
            }
        }
        if (this.getDefault() == null) {
            int ndefspec = 0;
            int t = nt - 1;
            while (t >= 0) {
                int c = nc - 1;
                while (c >= 0) {
                    if (this.specValType[t][c] == 0) {
                        ++ndefspec;
                    }
                    --c;
                }
                --t;
            }
            if (ndefspec != 0) {
                mode = pl.getParameter("Rroi") == null ? this.checkProgMode("res") : this.checkProgMode("layer");
                if (mode == -1) {
                    errMsg = "Unknown progression type : '" + param + "'";
                    throw new IllegalArgumentException(errMsg);
                }
                prog = new Progression[]{new Progression(mode, 0, nc, 0, dls.getMax() + 1, nl)};
                this.setDefault(prog);
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        int c = nc - 1;
                        while (c >= 0) {
                            if (this.specValType[0][c] == 2) {
                                this.specValType[0][c] = 0;
                            }
                            --c;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        t = nt - 1;
                        while (t >= 0) {
                            if (this.specValType[t][0] == 1) {
                                this.specValType[t][0] = 0;
                            }
                            --t;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }

    private int checkProgMode(String mode) {
        if (mode.equals("res")) {
            return 1;
        }
        if (mode.equals("layer")) {
            return 0;
        }
        if (mode.equals("pos-comp")) {
            return 3;
        }
        if (mode.equals("comp-pos")) {
            return 4;
        }
        if (mode.equals("res-pos")) {
            return 2;
        }
        return -1;
    }
}

