/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi.encoder;

import jj2000.j2k.roi.encoder.SubbandROIMask;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.WaveletFilter;

public class SubbandRectROIMask
extends SubbandROIMask {
    public int[] ulxs;
    public int[] ulys;
    public int[] lrxs;
    public int[] lrys;

    public SubbandRectROIMask(Subband sb, int[] ulxs, int[] ulys, int[] lrxs, int[] lrys, int nr) {
        super(sb.ulx, sb.uly, sb.w, sb.h);
        this.ulxs = ulxs;
        this.ulys = ulys;
        this.lrxs = lrxs;
        this.lrys = lrys;
        if (sb.isNode) {
            this.isNode = true;
            int horEvenLow = sb.ulcx % 2;
            int verEvenLow = sb.ulcy % 2;
            WaveletFilter hFilter = sb.getHorWFilter();
            WaveletFilter vFilter = sb.getVerWFilter();
            int hlnSup = hFilter.getSynLowNegSupport();
            int hhnSup = hFilter.getSynHighNegSupport();
            int hlpSup = hFilter.getSynLowPosSupport();
            int hhpSup = hFilter.getSynHighPosSupport();
            int vlnSup = vFilter.getSynLowNegSupport();
            int vhnSup = vFilter.getSynHighNegSupport();
            int vlpSup = vFilter.getSynLowPosSupport();
            int vhpSup = vFilter.getSynHighPosSupport();
            int[] lulxs = new int[nr];
            int[] lulys = new int[nr];
            int[] llrxs = new int[nr];
            int[] llrys = new int[nr];
            int[] hulxs = new int[nr];
            int[] hulys = new int[nr];
            int[] hlrxs = new int[nr];
            int[] hlrys = new int[nr];
            int r = nr - 1;
            while (r >= 0) {
                int x = ulxs[r];
                if (horEvenLow == 0) {
                    lulxs[r] = (x + 1 - hlnSup) / 2;
                    hulxs[r] = (x - hhnSup) / 2;
                } else {
                    lulxs[r] = (x - hlnSup) / 2;
                    hulxs[r] = (x + 1 - hhnSup) / 2;
                }
                int y = ulys[r];
                if (verEvenLow == 0) {
                    lulys[r] = (y + 1 - vlnSup) / 2;
                    hulys[r] = (y - vhnSup) / 2;
                } else {
                    lulys[r] = (y - vlnSup) / 2;
                    hulys[r] = (y + 1 - vhnSup) / 2;
                }
                x = lrxs[r];
                if (horEvenLow == 0) {
                    llrxs[r] = (x + hlpSup) / 2;
                    hlrxs[r] = (x - 1 + hhpSup) / 2;
                } else {
                    llrxs[r] = (x - 1 + hlpSup) / 2;
                    hlrxs[r] = (x + hhpSup) / 2;
                }
                y = lrys[r];
                if (verEvenLow == 0) {
                    llrys[r] = (y + vlpSup) / 2;
                    hlrys[r] = (y - 1 + vhpSup) / 2;
                } else {
                    llrys[r] = (y - 1 + vlpSup) / 2;
                    hlrys[r] = (y + vhpSup) / 2;
                }
                --r;
            }
            this.hh = new SubbandRectROIMask(sb.getHH(), hulxs, hulys, hlrxs, hlrys, nr);
            this.lh = new SubbandRectROIMask(sb.getLH(), lulxs, hulys, llrxs, hlrys, nr);
            this.hl = new SubbandRectROIMask(sb.getHL(), hulxs, lulys, hlrxs, llrys, nr);
            this.ll = new SubbandRectROIMask(sb.getLL(), lulxs, lulys, llrxs, llrys, nr);
        }
    }
}

