/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.io.BEBufferedRandomAccessFile;
import jj2000.j2k.io.BufferedRandomAccessFile;

public class CodestreamManipulator {
    private boolean ppmUsed;
    private boolean pptUsed;
    private boolean tempSop;
    private boolean tempEph;
    private int nt;
    private int pptp;
    private String outname;
    private static int TP_HEAD_LEN = 14;
    private static int MAX_TPSOT = 16;
    private int maxtp;
    private int[] ppt;
    private Integer[] positions;
    private byte[] mainHeader;
    private byte[][][] tileParts;
    private byte[][] tileHeaders;
    private byte[][][] packetHeaders;
    private byte[][][] packetData;
    private byte[][][] sopMarkSeg;

    public CodestreamManipulator(String outname, int nt, int pptp, boolean ppm, boolean ppt, boolean tempSop, boolean tempEph) {
        this.ppt = new int[this.nt];
        this.outname = outname;
        this.nt = nt;
        this.pptp = pptp;
        this.ppmUsed = ppm;
        this.pptUsed = ppt;
        this.tempSop = tempSop;
        this.tempEph = tempEph;
    }

    public int doCodestreamManipulation() throws IOException {
        int addedHeaderBytes = 0;
        this.ppt = new int[this.nt];
        this.tileParts = new byte[this.nt][][];
        this.tileHeaders = new byte[this.nt][];
        this.packetHeaders = new byte[this.nt][][];
        this.packetData = new byte[this.nt][][];
        this.sopMarkSeg = new byte[this.nt][][];
        if (!this.ppmUsed && !this.pptUsed && this.pptp == 0) {
            return 0;
        }
        BEBufferedRandomAccessFile fi = new BEBufferedRandomAccessFile(this.outname, "rw+");
        addedHeaderBytes -= fi.length();
        this.parseAndFind(fi);
        this.readAndBuffer(fi);
        fi.close();
        fi = new BEBufferedRandomAccessFile(this.outname, "rw");
        this.createTileParts();
        this.writeNewCodestream(fi);
        fi.flush();
        fi.close();
        return addedHeaderBytes += fi.length();
    }

    private void parseAndFind(BufferedRandomAccessFile fi) throws IOException {
        int scod;
        int length;
        int pos;
        int sop = 0;
        int eph = 0;
        Vector<Integer> markPos = new Vector<Integer>();
        short marker = (short)fi.readUnsignedShort();
        marker = (short)fi.readUnsignedShort();
        while (marker != -112) {
            pos = fi.getPos();
            length = fi.readUnsignedShort();
            if (marker == -174) {
                scod = fi.readUnsignedByte();
                if (this.tempSop) {
                    scod &= 0xFD;
                }
                if (this.tempEph) {
                    scod &= 0xFB;
                }
                fi.seek(pos + 2);
                fi.write(scod);
            }
            fi.seek(pos + length);
            marker = (short)fi.readUnsignedShort();
        }
        pos = fi.getPos();
        fi.seek(pos - 2);
        int t = 0;
        while (t < this.nt) {
            fi.readUnsignedShort();
            pos = fi.getPos();
            markPos.addElement(new Integer(fi.getPos()));
            fi.readInt();
            length = fi.readInt();
            fi.readUnsignedShort();
            int tileEnd = pos + length - 2;
            marker = (short)fi.readUnsignedShort();
            while (marker != -109) {
                pos = fi.getPos();
                length = fi.readUnsignedShort();
                if (marker == -174) {
                    scod = fi.readUnsignedByte();
                    if (this.tempSop) {
                        scod &= 0xFD;
                    }
                    if (this.tempEph) {
                        scod &= 0xFB;
                    }
                    fi.seek(pos + 2);
                    fi.write(scod);
                }
                fi.seek(pos + length);
                marker = (short)fi.readUnsignedShort();
            }
            sop = 0;
            eph = 0;
            int i = fi.getPos();
            while (i < tileEnd) {
                short halfMarker = (short)fi.readUnsignedByte();
                if (halfMarker == 255) {
                    marker = (short)((halfMarker << 8) + fi.readUnsignedByte());
                    ++i;
                    if (marker == -111) {
                        markPos.addElement(new Integer(fi.getPos()));
                        int n = t;
                        this.ppt[n] = this.ppt[n] + 1;
                        ++sop;
                        fi.skipBytes(4);
                        i += 4;
                    }
                    if (marker == -110) {
                        markPos.addElement(new Integer(fi.getPos()));
                        ++eph;
                    }
                }
                ++i;
            }
            ++t;
        }
        markPos.addElement(new Integer(fi.getPos() + 2));
        this.positions = new Integer[markPos.size()];
        markPos.copyInto(this.positions);
    }

    private void readAndBuffer(BufferedRandomAccessFile fi) throws IOException {
        fi.seek(0);
        int length = this.positions[0] - 2;
        this.mainHeader = new byte[length];
        fi.readFully(this.mainHeader, 0, length);
        int markIndex = 0;
        int t = 0;
        while (t < this.nt) {
            int prem = this.ppt[t];
            this.packetHeaders[t] = new byte[prem][];
            this.packetData[t] = new byte[prem][];
            this.sopMarkSeg[t] = new byte[prem][];
            length = this.positions[markIndex + 1] - this.positions[markIndex];
            this.tileHeaders[t] = new byte[length];
            fi.readFully(this.tileHeaders[t], 0, length);
            ++markIndex;
            int p = 0;
            while (p < prem) {
                length = this.positions[markIndex + 1] - this.positions[markIndex];
                if (this.tempSop) {
                    length -= 6;
                    fi.skipBytes(6);
                } else {
                    length -= 6;
                    this.sopMarkSeg[t][p] = new byte[6];
                    fi.readFully(this.sopMarkSeg[t][p], 0, 6);
                }
                if (!this.tempEph) {
                    length += 2;
                }
                this.packetHeaders[t][p] = new byte[length];
                fi.readFully(this.packetHeaders[t][p], 0, length);
                length = this.positions[++markIndex + 1] - this.positions[markIndex];
                length -= 2;
                if (this.tempEph) {
                    fi.skipBytes(2);
                }
                this.packetData[t][p] = new byte[length];
                fi.readFully(this.packetData[t][p], 0, length);
                ++markIndex;
                ++p;
            }
            ++t;
        }
    }

    private void createTileParts() throws IOException {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        this.tileParts = new byte[this.nt][][];
        this.maxtp = 0;
        int t = 0;
        while (t < this.nt) {
            if (this.pptp == 0) {
                this.pptp = this.ppt[t];
            }
            int prem = this.ppt[t];
            int numTileParts = (int)Math.ceil((double)prem / (double)this.pptp);
            int numPackets = this.packetHeaders[t].length;
            this.maxtp = numTileParts > this.maxtp ? numTileParts : this.maxtp;
            this.tileParts[t] = new byte[numTileParts][];
            int tppStart = 0;
            int pIndex = 0;
            int p = 0;
            boolean phIndex = false;
            int tilePart = 0;
            while (tilePart < numTileParts) {
                int nomnp;
                int np = nomnp = this.pptp > prem ? prem : this.pptp;
                if (tilePart == 0) {
                    temp.write(this.tileHeaders[t], 0, this.tileHeaders[t].length - 2);
                } else {
                    temp.write(new byte[TP_HEAD_LEN - 2], 0, TP_HEAD_LEN - 2);
                }
                if (this.pptUsed) {
                    int i;
                    int pptLength = 3;
                    int pptIndex = 0;
                    p = pIndex;
                    while (np > 0) {
                        int phLength = this.packetHeaders[t][p].length;
                        if (pptLength + phLength > 65535) {
                            temp.write(0xFFFFFF);
                            temp.write(-159);
                            temp.write(pptLength >>> 8);
                            temp.write(pptLength);
                            temp.write(pptIndex++);
                            i = pIndex;
                            while (i < p) {
                                temp.write(this.packetHeaders[t][i], 0, this.packetHeaders[t][i].length);
                                ++i;
                            }
                            pptLength = 3;
                            pIndex = p;
                        }
                        pptLength += phLength;
                        ++p;
                        --np;
                    }
                    temp.write(0xFFFFFF);
                    temp.write(-159);
                    temp.write(pptLength >>> 8);
                    temp.write(pptLength);
                    temp.write(pptIndex);
                    i = pIndex;
                    while (i < p) {
                        temp.write(this.packetHeaders[t][i], 0, this.packetHeaders[t][i].length);
                        ++i;
                    }
                }
                pIndex = p;
                np = nomnp;
                temp.write(0xFFFFFF);
                temp.write(-109);
                p = tppStart;
                while (p < tppStart + np) {
                    if (!this.tempSop) {
                        temp.write(this.sopMarkSeg[t][p], 0, 6);
                    }
                    if (!this.ppmUsed && !this.pptUsed) {
                        temp.write(this.packetHeaders[t][p], 0, this.packetHeaders[t][p].length);
                    }
                    temp.write(this.packetData[t][p], 0, this.packetData[t][p].length);
                    ++p;
                }
                tppStart += np;
                byte[] tempByteArr = temp.toByteArray();
                this.tileParts[t][tilePart] = tempByteArr;
                int length = temp.size();
                if (tilePart == 0) {
                    tempByteArr[6] = (byte)(length >>> 24);
                    tempByteArr[7] = (byte)(length >>> 16);
                    tempByteArr[8] = (byte)(length >>> 8);
                    tempByteArr[9] = (byte)length;
                    tempByteArr[10] = 0;
                    tempByteArr[11] = (byte)numTileParts;
                } else {
                    tempByteArr[0] = -1;
                    tempByteArr[1] = -112;
                    tempByteArr[2] = 0;
                    tempByteArr[3] = 10;
                    tempByteArr[4] = (byte)(t >>> 8);
                    tempByteArr[5] = (byte)t;
                    tempByteArr[6] = (byte)(length >>> 24);
                    tempByteArr[7] = (byte)(length >>> 16);
                    tempByteArr[8] = (byte)(length >>> 8);
                    tempByteArr[9] = (byte)length;
                    tempByteArr[10] = (byte)tilePart;
                    tempByteArr[11] = (byte)numTileParts;
                }
                temp.reset();
                prem -= np;
                ++tilePart;
            }
            ++t;
        }
        temp.close();
    }

    private void writeNewCodestream(BufferedRandomAccessFile fi) throws IOException {
        int length;
        byte[] temp;
        int tp;
        int t;
        int numTiles = this.tileParts.length;
        int[][] packetHeaderLengths = new int[numTiles][this.maxtp];
        fi.write(this.mainHeader, 0, this.mainHeader.length);
        if (this.ppmUsed) {
            int p;
            int pStop;
            int pStart;
            int numPackets;
            int totNumPackets;
            ByteArrayOutputStream ppmMarkerSegment = new ByteArrayOutputStream();
            int ppmIndex = 0;
            int[] prem = new int[numTiles];
            t = 0;
            while (t < numTiles) {
                prem[t] = this.packetHeaders[t].length;
                ++t;
            }
            tp = 0;
            while (tp < this.maxtp) {
                t = 0;
                while (t < numTiles) {
                    if (this.tileParts[t].length > tp) {
                        totNumPackets = this.packetHeaders[t].length;
                        numPackets = tp == this.tileParts[t].length - 1 ? prem[t] : this.pptp;
                        pStart = totNumPackets - prem[t];
                        pStop = pStart + numPackets;
                        p = pStart;
                        while (p < pStop) {
                            int[] nArray = packetHeaderLengths[t];
                            int n = tp;
                            nArray[n] = nArray[n] + this.packetHeaders[t][p].length;
                            ++p;
                        }
                        int n = t;
                        prem[n] = prem[n] - numPackets;
                    }
                    ++t;
                }
                ++tp;
            }
            ppmMarkerSegment.write(0xFFFFFF);
            ppmMarkerSegment.write(-160);
            ppmMarkerSegment.write(0);
            ppmMarkerSegment.write(0);
            ppmMarkerSegment.write(0);
            int ppmLength = 3;
            ++ppmIndex;
            t = 0;
            while (t < numTiles) {
                prem[t] = this.packetHeaders[t].length;
                ++t;
            }
            tp = 0;
            while (tp < this.maxtp) {
                t = 0;
                while (t < numTiles) {
                    if (this.tileParts[t].length > tp) {
                        totNumPackets = this.packetHeaders[t].length;
                        numPackets = tp == this.tileParts[t].length - 1 ? prem[t] : this.pptp;
                        pStart = totNumPackets - prem[t];
                        pStop = pStart + numPackets;
                        if (ppmLength + 4 > 65535) {
                            temp = ppmMarkerSegment.toByteArray();
                            length = temp.length - 2;
                            temp[2] = (byte)(length >>> 8);
                            temp[3] = (byte)length;
                            fi.write(temp, 0, length + 2);
                            ppmMarkerSegment.reset();
                            ppmMarkerSegment.write(0xFFFFFF);
                            ppmMarkerSegment.write(-160);
                            ppmMarkerSegment.write(0);
                            ppmMarkerSegment.write(0);
                            ppmMarkerSegment.write(ppmIndex++);
                            ppmLength = 3;
                        }
                        length = packetHeaderLengths[t][tp];
                        ppmMarkerSegment.write(length >>> 24);
                        ppmMarkerSegment.write(length >>> 16);
                        ppmMarkerSegment.write(length >>> 8);
                        ppmMarkerSegment.write(length);
                        ppmLength += 4;
                        p = pStart;
                        while (p < pStop) {
                            length = this.packetHeaders[t][p].length;
                            if (ppmLength + length > 65535) {
                                temp = ppmMarkerSegment.toByteArray();
                                length = temp.length - 2;
                                temp[2] = (byte)(length >>> 8);
                                temp[3] = (byte)length;
                                fi.write(temp, 0, length + 2);
                                ppmMarkerSegment.reset();
                                ppmMarkerSegment.write(0xFFFFFF);
                                ppmMarkerSegment.write(-160);
                                ppmMarkerSegment.write(0);
                                ppmMarkerSegment.write(0);
                                ppmMarkerSegment.write(ppmIndex++);
                                ppmLength = 3;
                            }
                            ppmMarkerSegment.write(this.packetHeaders[t][p], 0, this.packetHeaders[t][p].length);
                            ppmLength += this.packetHeaders[t][p].length;
                            ++p;
                        }
                        int n = t;
                        prem[n] = prem[n] - numPackets;
                    }
                    ++t;
                }
                ++tp;
            }
            temp = ppmMarkerSegment.toByteArray();
            length = temp.length - 2;
            temp[2] = (byte)(length >>> 8);
            temp[3] = (byte)length;
            fi.write(temp, 0, length + 2);
        }
        tp = 0;
        while (tp < this.maxtp) {
            t = 0;
            while (t < this.nt) {
                if (this.tileParts[t].length > tp) {
                    temp = this.tileParts[t][tp];
                    length = temp.length;
                    fi.write(temp, 0, length);
                }
                ++t;
            }
            ++tp;
        }
        fi.writeShort(-39);
    }
}

