/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.rahas.RahasData;
import org.apache.rahas.TokenCanceler;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TokenRequestDispatcherConfig;
import org.apache.rahas.TrustException;

public class TokenRequestDispatcher {
    private TokenRequestDispatcherConfig config;

    public TokenRequestDispatcher(TokenRequestDispatcherConfig config) throws TrustException {
        this.config = config;
    }

    public TokenRequestDispatcher(OMElement config) throws TrustException {
        this(TokenRequestDispatcherConfig.load(config));
    }

    public TokenRequestDispatcher(String configFilePath) throws TrustException {
        this(TokenRequestDispatcherConfig.load(configFilePath));
    }

    public SOAPEnvelope handle(MessageContext inMsgCtx, MessageContext outMsgCtx) throws TrustException {
        RahasData data = new RahasData(inMsgCtx);
        String reqType = data.getRequestType();
        String tokenType = data.getTokenType();
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue".equals(reqType)) {
            TokenIssuer issuer = tokenType == null || tokenType.trim().length() == 0 ? this.config.getDefaultIssuerInstace() : this.config.getIssuer(tokenType);
            SOAPEnvelope response = issuer.issue(data);
            outMsgCtx.getOptions().setAction(issuer.getResponseAction(data));
            return response;
        }
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Validate".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate".equals(reqType)) {
            throw new UnsupportedOperationException("TODO: handle validate requests");
        }
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Renew".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew".equals(reqType)) {
            throw new UnsupportedOperationException("TODO: handle renew requests");
        }
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel".equals(reqType)) {
            TokenCanceler canceler = this.config.getDefaultCancelerInstance();
            SOAPEnvelope response = canceler.cancel(data);
            outMsgCtx.getOptions().setAction(canceler.getResponseAction(data));
            return response;
        }
        throw new TrustException("InvalidRequest");
    }
}

