/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.Binding;
import org.apache.ws.secpolicy.model.Trust10;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

public class STSClient {
    private static final String RAMPART_POLICY = "rampartPolicy";
    private static Log log = LogFactory.getLog((Class)STSClient.class);
    private String action;
    private OMElement rstTemplate;
    private int version = 1;
    private Options options;
    private Trust10 trust10;
    private AlgorithmSuite algorithmSuite;
    private byte[] requestorEntropy;
    private String addressingNs = "http://www.w3.org/2005/08/addressing";
    private int keySize;
    private String soapVersion = "http://www.w3.org/2003/05/soap-envelope";
    private int ttl = 300;
    private Crypto crypto;
    private CallbackHandler cbHandler;
    private ConfigurationContext configCtx;

    public STSClient(ConfigurationContext configCtx) throws TrustException {
        if (configCtx == null) {
            throw new TrustException("stsClientCfgCtxNull");
        }
        this.configCtx = configCtx;
    }

    public Token requestSecurityToken(Policy servicePolicy, String issuerAddress, Policy issuerPolicy, String appliesTo) throws TrustException {
        try {
            QName rstQn = new QName("requestSecurityToken");
            String requestType = TrustUtil.getWSTNamespace(this.version) + "/Issue";
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            client.getOptions().setProperty(RAMPART_POLICY, (Object)issuerPolicy);
            client.getOptions().setSoapVersionURI(this.soapVersion);
            this.processPolicy(issuerPolicy, servicePolicy);
            OMElement response = client.sendReceive(rstQn, this.createIssueRequest(requestType, appliesTo));
            return this.processIssueResponse(this.version, response);
        }
        catch (AxisFault e) {
            e.printStackTrace();
            log.error((Object)"errorInObtainingToken", (Throwable)e);
            throw new TrustException("errorInObtainingToken", new String[]{issuerAddress});
        }
    }

    public boolean cancelToken(String issuerAddress, String tokenId, String action) throws TrustException {
        try {
            QName rstQn = new QName("cancelSecurityToken");
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            if (action != null) {
                client.getOptions().setAction(action);
            }
            return this.processCancelResponse(client.sendReceive(rstQn, this.createCancelRequest(tokenId)));
        }
        catch (AxisFault e) {
            log.error((Object)"errorInCancelingToken", (Throwable)e);
            throw new TrustException("errorInCancelingToken", e);
        }
    }

    private ServiceClient getServiceClient(QName rstQn, String issuerAddress) throws AxisFault {
        AxisService axisService = new AxisService("SecurityTokenService" + UUIDGenerator.getUUID());
        axisService.setClientSide(true);
        OutInAxisOperation operation = new OutInAxisOperation(rstQn);
        axisService.addOperation((AxisOperation)operation);
        ServiceClient client = new ServiceClient(this.configCtx, axisService);
        if (this.options != null) {
            client.setOptions(this.options);
        }
        client.getOptions().setAction(this.action);
        client.getOptions().setTo(new EndpointReference(issuerAddress));
        client.engageModule(new QName("rampart"));
        return client;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token processIssueResponse(int version, OMElement result) throws TrustException {
        String ns;
        OMElement reqAttElem;
        OMElement rstr = result;
        if (version == 2) {
            rstr = result.getFirstElement();
        }
        OMElement reqAttRef = (reqAttElem = rstr.getFirstChildWithName(new QName(ns = TrustUtil.getWSTNamespace(version), "RequestedAttachedReference"))) == null ? null : reqAttElem.getFirstElement();
        OMElement reqUnattElem = rstr.getFirstChildWithName(new QName(ns, "RequestedUnattachedReference"));
        OMElement reqUnattRef = reqUnattElem == null ? null : reqUnattElem.getFirstElement();
        OMElement reqSecTok = rstr.getFirstChildWithName(new QName(ns, "RequestedSecurityToken"));
        if (reqSecTok == null) {
            throw new TrustException("reqestedSecTokMissing");
        }
        OMElement tokenElem = reqSecTok.getFirstElement();
        String id = this.findIdentifier(reqAttRef, reqUnattRef, tokenElem);
        if (id == null) {
            throw new TrustException("cannotObtainTokenIdentifier");
        }
        OMElement lifeTimeEle = rstr.getFirstChildWithName(new QName(ns, "Lifetime"));
        Token token = new Token(id, tokenElem, lifeTimeEle);
        token.setAttachedReference(reqAttRef);
        token.setUnattachedReference(reqUnattRef);
        OMElement rpt = rstr.getFirstChildWithName(new QName(ns, "RequestedProofToken"));
        byte[] secret = null;
        if (rpt != null) {
            OMElement child = rpt.getFirstElement();
            if (child == null) {
                throw new TrustException("invalidRPT");
            }
            if (child.getQName().equals(new QName(ns, "BinarySecret"))) {
                String b64Secret = child.getText();
                secret = Base64.decode((String)b64Secret);
            } else if (child.getQName().equals(new QName(ns, "EncryptedKey"))) {
                try {
                    Element domChild = (Element)new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), child.getXMLStreamReader()).getDocumentElement();
                    EncryptedKeyProcessor processor = new EncryptedKeyProcessor();
                    processor.handleToken(domChild, null, this.crypto, this.cbHandler, null, new Vector(), null);
                    secret = processor.getDecryptedBytes();
                }
                catch (WSSecurityException e) {
                    throw new TrustException("errorInProcessingEncryptedKey", e);
                }
            } else if (child.getQName().equals(new QName(ns, "ComputedKey"))) {
                OMElement serviceEntrElem = rstr.getFirstChildWithName(new QName(ns, "Entropy"));
                OMElement binSecElem = serviceEntrElem.getFirstElement();
                if (binSecElem == null || binSecElem.getText() == null || "".equals(binSecElem.getText().trim())) throw new TrustException("serviceEntropyMissing");
                byte[] serviceEntr = Base64.decode((String)binSecElem.getText());
                P_SHA1 p_sha1 = new P_SHA1();
                int length = this.keySize > 0 ? this.keySize : this.algorithmSuite.getMaximumSymmetricKeyLength();
                try {
                    secret = p_sha1.createKey(this.requestorEntropy, serviceEntr, 0, (long)(length / 8));
                }
                catch (ConversationException e) {
                    throw new TrustException("keyDerivationError", e);
                }
            }
        } else if (this.requestorEntropy != null) {
            secret = this.requestorEntropy;
        }
        token.setSecret(secret);
        return token;
    }

    private boolean processCancelResponse(OMElement response) {
        return response.getFirstChildWithName(new QName("RequestedTokenCancelled")) != null;
    }

    private String findIdentifier(OMElement reqAttRef, OMElement reqUnattRef, OMElement token) {
        String id = reqAttRef != null ? this.getIdFromSTR(reqAttRef) : (reqUnattRef != null ? this.getIdFromSTR(reqUnattRef) : token.getAttributeValue(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")));
        return id;
    }

    private String getIdFromSTR(OMElement refElem) {
        OMElement child = refElem.getFirstElement();
        if (child == null) {
            return null;
        }
        if (child.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"))) {
            return child.getText();
        }
        if (child.getQName().equals(Reference.TOKEN)) {
            return child.getAttributeValue(new QName("URI"));
        }
        return null;
    }

    private void processPolicy(Policy issuerPolicy, Policy servicePolicy) {
        Assertion tempAssertion;
        Iterator iter;
        if (issuerPolicy != null) {
            log.debug((Object)"Processing Issuer policy");
            List issuerAssertions = (List)issuerPolicy.getAlternatives().next();
            iter = issuerAssertions.iterator();
            while (iter.hasNext()) {
                tempAssertion = (Assertion)iter.next();
                if (!(tempAssertion instanceof Binding)) continue;
                log.debug((Object)"Extracting algo suite from issuer policy binding");
                this.algorithmSuite = ((Binding)tempAssertion).getAlgorithmSuite();
            }
        }
        if (servicePolicy != null) {
            log.debug((Object)"Processing service policy to find Trust10 assertion");
            List assertions = (List)servicePolicy.getAlternatives().next();
            iter = assertions.iterator();
            while (iter.hasNext()) {
                tempAssertion = (Assertion)iter.next();
                if (!(tempAssertion instanceof Trust10)) continue;
                log.debug((Object)"Extracting Trust10 assertion from service policy");
                this.trust10 = (Trust10)tempAssertion;
            }
        }
    }

    private OMElement createIssueRequest(String requestType, String appliesTo) throws TrustException {
        log.debug((Object)("Creating request with request type: " + requestType + " and applies to: " + appliesTo));
        OMElement rst = TrustUtil.createRequestSecurityTokenElement(this.version);
        TrustUtil.createRequestTypeElement(this.version, rst, requestType);
        if (appliesTo != null) {
            TrustUtil.createAppliesToElement(rst, appliesTo, this.addressingNs);
        }
        TrustUtil.createLifetimeElement(this.version, rst, this.ttl * 1000);
        if (this.rstTemplate != null) {
            log.debug((Object)("Using RSTTemplate: " + this.rstTemplate.toString()));
            Iterator templateChildren = this.rstTemplate.getChildElements();
            while (templateChildren.hasNext()) {
                OMNode child = (OMNode)templateChildren.next();
                rst.addChild(child);
                if (!(child instanceof OMElement) || !((OMElement)child).getQName().equals(new QName(TrustUtil.getWSTNamespace(this.version), "KeySize"))) continue;
                log.debug((Object)"Extracting key size from the RSTTemplate: ");
                OMElement childElem = (OMElement)child;
                this.keySize = childElem.getText() != null && !"".equals(childElem.getText()) ? Integer.parseInt(childElem.getText()) : -1;
                log.debug((Object)("Key size from RSTTemplate: " + this.keySize));
            }
        }
        try {
            if (this.trust10 != null) {
                log.debug((Object)"Processing Trust10 assertion");
                if (this.trust10.isRequireClientEntropy()) {
                    log.debug((Object)"Requires client entropy");
                    OMElement ent = TrustUtil.createEntropyElement(this.version, rst);
                    OMElement binSec = TrustUtil.createBinarySecretElement(this.version, ent, "/Nonce");
                    this.requestorEntropy = WSSecurityUtil.generateNonce((int)this.algorithmSuite.getMaximumSymmetricKeyLength());
                    binSec.setText(Base64.encode((byte[])this.requestorEntropy));
                    log.debug((Object)("Clien entropy : " + Base64.encode((byte[])this.requestorEntropy)));
                    TrustUtil.createComputedKeyAlgorithm(this.version, rst, "/CK/PSHA1");
                }
            }
        }
        catch (Exception e) {
            throw new TrustException("errorSettingUpRequestorEntropy", e);
        }
        return rst;
    }

    private OMElement createCancelRequest(String tokenId) throws TrustException {
        return TrustUtil.createCancelRequest(tokenId, this.version);
    }

    public void setTrust10(Trust10 trust10) {
        this.trust10 = trust10;
    }

    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public void setAddressingNs(String addressingNs) {
        this.addressingNs = addressingNs;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setCryptoInfo(Crypto crypto, CallbackHandler cbHandler) {
        this.crypto = crypto;
        this.cbHandler = cbHandler;
    }

    public void setCryptoInfo(Crypto crypto, String privKeyPasswd) {
        this.crypto = crypto;
        this.cbHandler = new CBHandler(privKeyPasswd);
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setRstTemplate(OMElement rstTemplate) {
        this.rstTemplate = rstTemplate;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    private class CBHandler
    implements CallbackHandler {
        private String passwd;

        private CBHandler(String passwd) {
            this.passwd = passwd;
        }

        public void handle(Callback[] cb) throws IOException, UnsupportedCallbackException {
            ((WSPasswordCallback)cb[0]).setPassword(this.passwd);
        }
    }
}

