/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.account.ws;

import gov.nih.tbi.account.ws.AuthenticationWebService;
import gov.nih.tbi.account.ws.model.UserLogin;
import gov.nih.tbi.commons.ws.HashMethods;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import org.apache.log4j.Logger;

public class AuthenticationProvider {
    private static Logger logger = Logger.getLogger(AuthenticationProvider.class);
    private static final String namespaceURI = "http://cxf.ws.account.tbi.nih.gov/";
    private static final String serviceName = "AuthenticationWebServiceImplService";
    private static final String portName = "AuthenticationWebServiceImplPort";
    private static final String wsdlExtension = "/tbi-portal/ws/authenticationWebService?wsdl";
    private static URL WSDL_LOCATION;
    private Service service;
    private AuthenticationWebService authenticationWebService;
    private UserLogin userLogin;

    public AuthenticationProvider(String serverLocation, String userName, String password) throws MalformedURLException {
        WSDL_LOCATION = new URL(AuthenticationProvider.class.getResource("."), serverLocation + wsdlExtension);
        this.userLogin = new UserLogin(userName, HashMethods.getClientHash(userName), HashMethods.getClientHash(HashMethods.getServerHash(userName), password));
        this.service = Service.create((URL)WSDL_LOCATION, (QName)new QName(namespaceURI, serviceName));
        this.authenticationWebService = this.getWebService();
        if (!this.authenticationWebService.authenticate(this.userLogin).booleanValue()) {
            throw new RuntimeException("User failed to authenticate");
        }
    }

    public AuthenticationProvider(String serverLocation) throws MalformedURLException {
        this(serverLocation, "anonymous", "");
    }

    @WebEndpoint(name="authenticationWebService")
    private AuthenticationWebService getWebService() {
        return (AuthenticationWebService)this.service.getPort(new QName(namespaceURI, portName), AuthenticationWebService.class);
    }

    protected UserLogin getUserLogin() {
        return this.userLogin;
    }
}

