/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.validation;

import gov.nih.tbi.commons.model.DataType;
import gov.nih.tbi.commons.model.InputRestrictions;
import gov.nih.tbi.dictionary.model.AbstractDataElement;
import gov.nih.tbi.dictionary.model.hibernate.DataStructure;
import gov.nih.tbi.dictionary.model.hibernate.ValueRange;
import gov.nih.tbi.dictionary.validation.CellValidator;
import gov.nih.tbi.dictionary.validation.ValidationUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeValidator
extends CellValidator {
    public RangeValidator() {
    }

    public RangeValidator(List<DataStructure> dictionary) {
        super(dictionary);
    }

    @Override
    public boolean validate(AbstractDataElement iElement, String data) {
        Vector range = new Vector();
        return this.inRange(data, iElement);
    }

    public boolean inRange(String data, AbstractDataElement iElement) {
        boolean result;
        if (DataType.ALPHANUMERIC.equals((Object)iElement.getType())) {
            if (InputRestrictions.FREE_FORM.equals((Object)iElement.getRestrictions())) {
                return true;
            }
            result = this.stringInRange(data, null, iElement);
        } else if (DataType.DATE.equals((Object)iElement.getType())) {
            result = this.dateInRange(data, null, "dd-MMM-yyyy");
        } else if (DataType.GUID.equals((Object)iElement.getType())) {
            result = true;
        } else if (DataType.NUMERIC.equals((Object)iElement.getType())) {
            result = this.floatInRange(data, null, iElement);
        } else {
            return false;
        }
        return result;
    }

    private boolean floatInRange(String data, HashSet<String> valueRange, AbstractDataElement iElement) {
        String[] dataArr;
        for (String value : dataArr = data.split(";")) {
            float num = Float.parseFloat(value);
            if (iElement.getMinimumValue() != null && num <= (float)iElement.getMinimumValue().intValue()) {
                return false;
            }
            if (iElement.getMaximumValue() != null && num >= (float)iElement.getMaximumValue().intValue()) {
                return false;
            }
            if (InputRestrictions.FREE_FORM.equals((Object)iElement.getRestrictions())) continue;
            boolean found = false;
            for (ValueRange vr : iElement.getValueRangeList()) {
                if (!vr.getValueRange().equalsIgnoreCase(value.trim())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean dateInRange(String data, HashSet<String> valueRange, String format) {
        Date date = ValidationUtil.parseDate(data, format);
        return !date.after(new Date());
    }

    private boolean stringInRange(String data, HashSet<String> valueRange, AbstractDataElement iElement) {
        String[] dataArr;
        for (String value : dataArr = data.split(";")) {
            boolean found = false;
            for (ValueRange vr : iElement.getValueRangeList()) {
                if (!vr.getValueRange().equalsIgnoreCase(value.trim())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

