/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesConfigFileLoader {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFileLoader.class);

    public static Map<String, Profile> loadProfiles(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file is null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("AWS credential profiles file not found in the given path: " + file.getAbsolutePath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Map<String, Profile> map = ProfilesConfigFileLoader.loadProfiles(fis);
            return map;
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to load AWS credential profiles file at: " + file.getAbsolutePath(), ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Map<String, Profile> loadProfiles(InputStream is) throws IOException {
        ProfilesConfigFileLoaderHelper helper = new ProfilesConfigFileLoaderHelper();
        Map<String, Map<String, String>> allProfileProperties = helper.parseProfileProperties(new Scanner(is));
        LinkedHashMap<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();
        for (Map.Entry<String, Map<String, String>> entry : allProfileProperties.entrySet()) {
            String profileName = entry.getKey();
            Map<String, String> properties = entry.getValue();
            if (profileName.startsWith("profile ")) {
                LOG.warn((Object)"The legacy profile format requires the 'profile ' prefix before the profile name. The latest code does not require such prefix, and will consider it as part of the profile name. Please remove the prefix if you are seeing this warning.");
            }
            String accessKey = properties.get("aws_access_key_id");
            String secretKey = properties.get("aws_secret_access_key");
            String sessionToken = properties.get("aws_session_token");
            ProfilesConfigFileLoader.assertParameterNotEmpty(profileName, "Unable to load credentials into profile: ProfileName is empty.");
            if (accessKey == null) {
                throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Access Key ID is not specified.", profileName));
            }
            if (secretKey == null) {
                throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Secret Access Key is not specified.", profileName));
            }
            if (sessionToken == null) {
                profilesByName.put(profileName, new Profile(profileName, new BasicAWSCredentials(accessKey, secretKey)));
                continue;
            }
            if (sessionToken.isEmpty()) {
                throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Session Token is empty.", profileName));
            }
            profilesByName.put(profileName, new Profile(profileName, new BasicSessionCredentials(accessKey, secretKey, sessionToken)));
        }
        return profilesByName;
    }

    private static void assertParameterNotEmpty(String parameterValue, String errorMessage) {
        if (parameterValue == null || parameterValue.isEmpty()) {
            throw new AmazonClientException(errorMessage);
        }
    }

    private static class ProfilesConfigFileLoaderHelper
    extends AbstractProfilesConfigFileScanner {
        protected final Map<String, Map<String, String>> allProfileProperties = new LinkedHashMap<String, Map<String, String>>();

        private ProfilesConfigFileLoaderHelper() {
        }

        public Map<String, Map<String, String>> parseProfileProperties(Scanner scanner) {
            this.allProfileProperties.clear();
            this.run(scanner);
            return new LinkedHashMap<String, Map<String, String>>(this.allProfileProperties);
        }

        @Override
        protected void onEmptyOrCommentLine(String profileName, String line) {
        }

        @Override
        protected void onProfileStartingLine(String newProfileName, String line) {
            this.allProfileProperties.put(newProfileName, new HashMap());
        }

        @Override
        protected void onProfileEndingLine(String prevProfileName) {
        }

        @Override
        protected void onProfileProperty(String profileName, String propertyKey, String propertyValue, boolean isSupportedProperty, String line) {
            Map<String, String> properties;
            if (!isSupportedProperty) {
                LOG.info((Object)String.format("Skip unsupported property name %s in profile [%s].", propertyKey, profileName));
                return;
            }
            if (this.allProfileProperties.get(profileName) == null) {
                this.allProfileProperties.put(profileName, new HashMap());
            }
            if ((properties = this.allProfileProperties.get(profileName)).containsKey(propertyKey)) {
                throw new IllegalArgumentException("Duplicate property values for [" + propertyKey + "].");
            }
            properties.put(propertyKey, propertyValue);
        }

        @Override
        protected void onEndOfFile() {
        }
    }
}

