/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.ParameterDeclaration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetTemplateSummaryResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<ParameterDeclaration> parameters;
    private String description;
    private ListWithAutoConstructFlag<String> capabilities;
    private String capabilitiesReason;
    private String version;
    private String metadata;

    public List<ParameterDeclaration> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ListWithAutoConstructFlag();
            this.parameters.setAutoConstruct(true);
        }
        return this.parameters;
    }

    public void setParameters(Collection<ParameterDeclaration> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public GetTemplateSummaryResult withParameters(ParameterDeclaration ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<ParameterDeclaration>(parameters.length));
        }
        for (ParameterDeclaration value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public GetTemplateSummaryResult withParameters(Collection<ParameterDeclaration> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GetTemplateSummaryResult withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ListWithAutoConstructFlag();
            this.capabilities.setAutoConstruct(true);
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        ListWithAutoConstructFlag capabilitiesCopy = new ListWithAutoConstructFlag(capabilities.size());
        capabilitiesCopy.addAll(capabilities);
        this.capabilities = capabilitiesCopy;
    }

    public GetTemplateSummaryResult withCapabilities(String ... capabilities) {
        if (this.getCapabilities() == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String value : capabilities) {
            this.getCapabilities().add(value);
        }
        return this;
    }

    public GetTemplateSummaryResult withCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
        } else {
            ListWithAutoConstructFlag capabilitiesCopy = new ListWithAutoConstructFlag(capabilities.size());
            capabilitiesCopy.addAll(capabilities);
            this.capabilities = capabilitiesCopy;
        }
        return this;
    }

    public GetTemplateSummaryResult withCapabilities(Capability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (Capability member : capabilities) {
            capabilitiesCopy.add(member.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public String getCapabilitiesReason() {
        return this.capabilitiesReason;
    }

    public void setCapabilitiesReason(String capabilitiesReason) {
        this.capabilitiesReason = capabilitiesReason;
    }

    public GetTemplateSummaryResult withCapabilitiesReason(String capabilitiesReason) {
        this.capabilitiesReason = capabilitiesReason;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public GetTemplateSummaryResult withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public GetTemplateSummaryResult withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: " + this.getCapabilities() + ",");
        }
        if (this.getCapabilitiesReason() != null) {
            sb.append("CapabilitiesReason: " + this.getCapabilitiesReason() + ",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: " + this.getVersion() + ",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: " + this.getMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilitiesReason() == null ? 0 : this.getCapabilitiesReason().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryResult)) {
            return false;
        }
        GetTemplateSummaryResult other = (GetTemplateSummaryResult)obj;
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getCapabilitiesReason() == null ^ this.getCapabilitiesReason() == null) {
            return false;
        }
        if (other.getCapabilitiesReason() != null && !other.getCapabilitiesReason().equals(this.getCapabilitiesReason())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        return other.getMetadata() == null || other.getMetadata().equals(this.getMetadata());
    }

    public GetTemplateSummaryResult clone() {
        try {
            return (GetTemplateSummaryResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

