/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudsearchv2.AmazonCloudSearchAsync;
import com.amazonaws.services.cloudsearchv2.AmazonCloudSearchClient;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsRequest;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsResult;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesRequest;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCloudSearchAsyncClient
extends AmazonCloudSearchClient
implements AmazonCloudSearchAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCloudSearchAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudSearchAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudSearchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudSearchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCloudSearchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudSearchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudSearchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCloudSearchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudSearchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeAnalysisSchemesResult> describeAnalysisSchemesAsync(final DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAnalysisSchemesResult>(){

            @Override
            public DescribeAnalysisSchemesResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeAnalysisSchemes(describeAnalysisSchemesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAnalysisSchemesResult> describeAnalysisSchemesAsync(final DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest, final AsyncHandler<DescribeAnalysisSchemesRequest, DescribeAnalysisSchemesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAnalysisSchemesResult>(){

            @Override
            public DescribeAnalysisSchemesResult call() throws Exception {
                DescribeAnalysisSchemesResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeAnalysisSchemes(describeAnalysisSchemesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAnalysisSchemesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIndexFieldResult> deleteIndexFieldAsync(final DeleteIndexFieldRequest deleteIndexFieldRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteIndexFieldResult>(){

            @Override
            public DeleteIndexFieldResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteIndexField(deleteIndexFieldRequest);
            }
        });
    }

    @Override
    public Future<DeleteIndexFieldResult> deleteIndexFieldAsync(final DeleteIndexFieldRequest deleteIndexFieldRequest, final AsyncHandler<DeleteIndexFieldRequest, DeleteIndexFieldResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteIndexFieldResult>(){

            @Override
            public DeleteIndexFieldResult call() throws Exception {
                DeleteIndexFieldResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.deleteIndexField(deleteIndexFieldRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteIndexFieldRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAvailabilityOptionsResult> updateAvailabilityOptionsAsync(final UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateAvailabilityOptionsResult>(){

            @Override
            public UpdateAvailabilityOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateAvailabilityOptions(updateAvailabilityOptionsRequest);
            }
        });
    }

    @Override
    public Future<UpdateAvailabilityOptionsResult> updateAvailabilityOptionsAsync(final UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest, final AsyncHandler<UpdateAvailabilityOptionsRequest, UpdateAvailabilityOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateAvailabilityOptionsResult>(){

            @Override
            public UpdateAvailabilityOptionsResult call() throws Exception {
                UpdateAvailabilityOptionsResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.updateAvailabilityOptions(updateAvailabilityOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateAvailabilityOptionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIndexFieldsResult> describeIndexFieldsAsync(final DescribeIndexFieldsRequest describeIndexFieldsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIndexFieldsResult>(){

            @Override
            public DescribeIndexFieldsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeIndexFields(describeIndexFieldsRequest);
            }
        });
    }

    @Override
    public Future<DescribeIndexFieldsResult> describeIndexFieldsAsync(final DescribeIndexFieldsRequest describeIndexFieldsRequest, final AsyncHandler<DescribeIndexFieldsRequest, DescribeIndexFieldsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIndexFieldsResult>(){

            @Override
            public DescribeIndexFieldsResult call() throws Exception {
                DescribeIndexFieldsResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeIndexFields(describeIndexFieldsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeIndexFieldsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DefineExpressionResult> defineExpressionAsync(final DefineExpressionRequest defineExpressionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineExpressionResult>(){

            @Override
            public DefineExpressionResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.defineExpression(defineExpressionRequest);
            }
        });
    }

    @Override
    public Future<DefineExpressionResult> defineExpressionAsync(final DefineExpressionRequest defineExpressionRequest, final AsyncHandler<DefineExpressionRequest, DefineExpressionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineExpressionResult>(){

            @Override
            public DefineExpressionResult call() throws Exception {
                DefineExpressionResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.defineExpression(defineExpressionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(defineExpressionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceAccessPoliciesResult> updateServiceAccessPoliciesAsync(final UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateServiceAccessPoliciesResult>(){

            @Override
            public UpdateServiceAccessPoliciesResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateServiceAccessPolicies(updateServiceAccessPoliciesRequest);
            }
        });
    }

    @Override
    public Future<UpdateServiceAccessPoliciesResult> updateServiceAccessPoliciesAsync(final UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest, final AsyncHandler<UpdateServiceAccessPoliciesRequest, UpdateServiceAccessPoliciesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateServiceAccessPoliciesResult>(){

            @Override
            public UpdateServiceAccessPoliciesResult call() throws Exception {
                UpdateServiceAccessPoliciesResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.updateServiceAccessPolicies(updateServiceAccessPoliciesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateServiceAccessPoliciesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DefineSuggesterResult> defineSuggesterAsync(final DefineSuggesterRequest defineSuggesterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineSuggesterResult>(){

            @Override
            public DefineSuggesterResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.defineSuggester(defineSuggesterRequest);
            }
        });
    }

    @Override
    public Future<DefineSuggesterResult> defineSuggesterAsync(final DefineSuggesterRequest defineSuggesterRequest, final AsyncHandler<DefineSuggesterRequest, DefineSuggesterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineSuggesterResult>(){

            @Override
            public DefineSuggesterResult call() throws Exception {
                DefineSuggesterResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.defineSuggester(defineSuggesterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(defineSuggesterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAnalysisSchemeResult> deleteAnalysisSchemeAsync(final DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteAnalysisSchemeResult>(){

            @Override
            public DeleteAnalysisSchemeResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteAnalysisScheme(deleteAnalysisSchemeRequest);
            }
        });
    }

    @Override
    public Future<DeleteAnalysisSchemeResult> deleteAnalysisSchemeAsync(final DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest, final AsyncHandler<DeleteAnalysisSchemeRequest, DeleteAnalysisSchemeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteAnalysisSchemeResult>(){

            @Override
            public DeleteAnalysisSchemeResult call() throws Exception {
                DeleteAnalysisSchemeResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.deleteAnalysisScheme(deleteAnalysisSchemeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteAnalysisSchemeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<IndexDocumentsResult> indexDocumentsAsync(final IndexDocumentsRequest indexDocumentsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<IndexDocumentsResult>(){

            @Override
            public IndexDocumentsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.indexDocuments(indexDocumentsRequest);
            }
        });
    }

    @Override
    public Future<IndexDocumentsResult> indexDocumentsAsync(final IndexDocumentsRequest indexDocumentsRequest, final AsyncHandler<IndexDocumentsRequest, IndexDocumentsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<IndexDocumentsResult>(){

            @Override
            public IndexDocumentsResult call() throws Exception {
                IndexDocumentsResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.indexDocuments(indexDocumentsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(indexDocumentsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSuggestersResult> describeSuggestersAsync(final DescribeSuggestersRequest describeSuggestersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSuggestersResult>(){

            @Override
            public DescribeSuggestersResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeSuggesters(describeSuggestersRequest);
            }
        });
    }

    @Override
    public Future<DescribeSuggestersResult> describeSuggestersAsync(final DescribeSuggestersRequest describeSuggestersRequest, final AsyncHandler<DescribeSuggestersRequest, DescribeSuggestersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSuggestersResult>(){

            @Override
            public DescribeSuggestersResult call() throws Exception {
                DescribeSuggestersResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeSuggesters(describeSuggestersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSuggestersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateScalingParametersResult> updateScalingParametersAsync(final UpdateScalingParametersRequest updateScalingParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateScalingParametersResult>(){

            @Override
            public UpdateScalingParametersResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateScalingParameters(updateScalingParametersRequest);
            }
        });
    }

    @Override
    public Future<UpdateScalingParametersResult> updateScalingParametersAsync(final UpdateScalingParametersRequest updateScalingParametersRequest, final AsyncHandler<UpdateScalingParametersRequest, UpdateScalingParametersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateScalingParametersResult>(){

            @Override
            public UpdateScalingParametersResult call() throws Exception {
                UpdateScalingParametersResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.updateScalingParameters(updateScalingParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateScalingParametersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDomainNamesResult> listDomainNamesAsync(final ListDomainNamesRequest listDomainNamesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDomainNamesResult>(){

            @Override
            public ListDomainNamesResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.listDomainNames(listDomainNamesRequest);
            }
        });
    }

    @Override
    public Future<ListDomainNamesResult> listDomainNamesAsync(final ListDomainNamesRequest listDomainNamesRequest, final AsyncHandler<ListDomainNamesRequest, ListDomainNamesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDomainNamesResult>(){

            @Override
            public ListDomainNamesResult call() throws Exception {
                ListDomainNamesResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.listDomainNames(listDomainNamesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listDomainNamesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DefineIndexFieldResult> defineIndexFieldAsync(final DefineIndexFieldRequest defineIndexFieldRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineIndexFieldResult>(){

            @Override
            public DefineIndexFieldResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.defineIndexField(defineIndexFieldRequest);
            }
        });
    }

    @Override
    public Future<DefineIndexFieldResult> defineIndexFieldAsync(final DefineIndexFieldRequest defineIndexFieldRequest, final AsyncHandler<DefineIndexFieldRequest, DefineIndexFieldResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineIndexFieldResult>(){

            @Override
            public DefineIndexFieldResult call() throws Exception {
                DefineIndexFieldResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.defineIndexField(defineIndexFieldRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(defineIndexFieldRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(final CreateDomainRequest createDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDomainResult>(){

            @Override
            public CreateDomainResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.createDomain(createDomainRequest);
            }
        });
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(final CreateDomainRequest createDomainRequest, final AsyncHandler<CreateDomainRequest, CreateDomainResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDomainResult>(){

            @Override
            public CreateDomainResult call() throws Exception {
                CreateDomainResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.createDomain(createDomainRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDomainRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSuggesterResult> deleteSuggesterAsync(final DeleteSuggesterRequest deleteSuggesterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteSuggesterResult>(){

            @Override
            public DeleteSuggesterResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteSuggester(deleteSuggesterRequest);
            }
        });
    }

    @Override
    public Future<DeleteSuggesterResult> deleteSuggesterAsync(final DeleteSuggesterRequest deleteSuggesterRequest, final AsyncHandler<DeleteSuggesterRequest, DeleteSuggesterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteSuggesterResult>(){

            @Override
            public DeleteSuggesterResult call() throws Exception {
                DeleteSuggesterResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.deleteSuggester(deleteSuggesterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSuggesterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteExpressionResult> deleteExpressionAsync(final DeleteExpressionRequest deleteExpressionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteExpressionResult>(){

            @Override
            public DeleteExpressionResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteExpression(deleteExpressionRequest);
            }
        });
    }

    @Override
    public Future<DeleteExpressionResult> deleteExpressionAsync(final DeleteExpressionRequest deleteExpressionRequest, final AsyncHandler<DeleteExpressionRequest, DeleteExpressionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteExpressionResult>(){

            @Override
            public DeleteExpressionResult call() throws Exception {
                DeleteExpressionResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.deleteExpression(deleteExpressionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteExpressionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAvailabilityOptionsResult> describeAvailabilityOptionsAsync(final DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAvailabilityOptionsResult>(){

            @Override
            public DescribeAvailabilityOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeAvailabilityOptions(describeAvailabilityOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeAvailabilityOptionsResult> describeAvailabilityOptionsAsync(final DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest, final AsyncHandler<DescribeAvailabilityOptionsRequest, DescribeAvailabilityOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAvailabilityOptionsResult>(){

            @Override
            public DescribeAvailabilityOptionsResult call() throws Exception {
                DescribeAvailabilityOptionsResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeAvailabilityOptions(describeAvailabilityOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAvailabilityOptionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DefineAnalysisSchemeResult> defineAnalysisSchemeAsync(final DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineAnalysisSchemeResult>(){

            @Override
            public DefineAnalysisSchemeResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.defineAnalysisScheme(defineAnalysisSchemeRequest);
            }
        });
    }

    @Override
    public Future<DefineAnalysisSchemeResult> defineAnalysisSchemeAsync(final DefineAnalysisSchemeRequest defineAnalysisSchemeRequest, final AsyncHandler<DefineAnalysisSchemeRequest, DefineAnalysisSchemeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineAnalysisSchemeResult>(){

            @Override
            public DefineAnalysisSchemeResult call() throws Exception {
                DefineAnalysisSchemeResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.defineAnalysisScheme(defineAnalysisSchemeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(defineAnalysisSchemeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<BuildSuggestersResult> buildSuggestersAsync(final BuildSuggestersRequest buildSuggestersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BuildSuggestersResult>(){

            @Override
            public BuildSuggestersResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.buildSuggesters(buildSuggestersRequest);
            }
        });
    }

    @Override
    public Future<BuildSuggestersResult> buildSuggestersAsync(final BuildSuggestersRequest buildSuggestersRequest, final AsyncHandler<BuildSuggestersRequest, BuildSuggestersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BuildSuggestersResult>(){

            @Override
            public BuildSuggestersResult call() throws Exception {
                BuildSuggestersResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.buildSuggesters(buildSuggestersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(buildSuggestersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServiceAccessPoliciesResult> describeServiceAccessPoliciesAsync(final DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServiceAccessPoliciesResult>(){

            @Override
            public DescribeServiceAccessPoliciesResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeServiceAccessPolicies(describeServiceAccessPoliciesRequest);
            }
        });
    }

    @Override
    public Future<DescribeServiceAccessPoliciesResult> describeServiceAccessPoliciesAsync(final DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest, final AsyncHandler<DescribeServiceAccessPoliciesRequest, DescribeServiceAccessPoliciesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServiceAccessPoliciesResult>(){

            @Override
            public DescribeServiceAccessPoliciesResult call() throws Exception {
                DescribeServiceAccessPoliciesResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeServiceAccessPolicies(describeServiceAccessPoliciesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeServiceAccessPoliciesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDomainResult>(){

            @Override
            public DeleteDomainResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteDomain(deleteDomainRequest);
            }
        });
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest, final AsyncHandler<DeleteDomainRequest, DeleteDomainResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDomainResult>(){

            @Override
            public DeleteDomainResult call() throws Exception {
                DeleteDomainResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.deleteDomain(deleteDomainRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDomainRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExpressionsResult> describeExpressionsAsync(final DescribeExpressionsRequest describeExpressionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeExpressionsResult>(){

            @Override
            public DescribeExpressionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeExpressions(describeExpressionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeExpressionsResult> describeExpressionsAsync(final DescribeExpressionsRequest describeExpressionsRequest, final AsyncHandler<DescribeExpressionsRequest, DescribeExpressionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeExpressionsResult>(){

            @Override
            public DescribeExpressionsResult call() throws Exception {
                DescribeExpressionsResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeExpressions(describeExpressionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeExpressionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainsResult> describeDomainsAsync(final DescribeDomainsRequest describeDomainsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDomainsResult>(){

            @Override
            public DescribeDomainsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeDomains(describeDomainsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDomainsResult> describeDomainsAsync(final DescribeDomainsRequest describeDomainsRequest, final AsyncHandler<DescribeDomainsRequest, DescribeDomainsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDomainsResult>(){

            @Override
            public DescribeDomainsResult call() throws Exception {
                DescribeDomainsResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeDomains(describeDomainsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDomainsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingParametersResult> describeScalingParametersAsync(final DescribeScalingParametersRequest describeScalingParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingParametersResult>(){

            @Override
            public DescribeScalingParametersResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeScalingParameters(describeScalingParametersRequest);
            }
        });
    }

    @Override
    public Future<DescribeScalingParametersResult> describeScalingParametersAsync(final DescribeScalingParametersRequest describeScalingParametersRequest, final AsyncHandler<DescribeScalingParametersRequest, DescribeScalingParametersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingParametersResult>(){

            @Override
            public DescribeScalingParametersResult call() throws Exception {
                DescribeScalingParametersResult result;
                try {
                    result = AmazonCloudSearchAsyncClient.this.describeScalingParameters(describeScalingParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeScalingParametersRequest, result);
                return result;
            }
        });
    }
}

