/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeObjectsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineId;
    private ListWithAutoConstructFlag<String> objectIds;
    private Boolean evaluateExpressions;
    private String marker;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public DescribeObjectsRequest withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public List<String> getObjectIds() {
        if (this.objectIds == null) {
            this.objectIds = new ListWithAutoConstructFlag();
            this.objectIds.setAutoConstruct(true);
        }
        return this.objectIds;
    }

    public void setObjectIds(Collection<String> objectIds) {
        if (objectIds == null) {
            this.objectIds = null;
            return;
        }
        ListWithAutoConstructFlag objectIdsCopy = new ListWithAutoConstructFlag(objectIds.size());
        objectIdsCopy.addAll(objectIds);
        this.objectIds = objectIdsCopy;
    }

    public DescribeObjectsRequest withObjectIds(String ... objectIds) {
        if (this.getObjectIds() == null) {
            this.setObjectIds(new ArrayList<String>(objectIds.length));
        }
        for (String value : objectIds) {
            this.getObjectIds().add(value);
        }
        return this;
    }

    public DescribeObjectsRequest withObjectIds(Collection<String> objectIds) {
        if (objectIds == null) {
            this.objectIds = null;
        } else {
            ListWithAutoConstructFlag objectIdsCopy = new ListWithAutoConstructFlag(objectIds.size());
            objectIdsCopy.addAll(objectIds);
            this.objectIds = objectIdsCopy;
        }
        return this;
    }

    public Boolean isEvaluateExpressions() {
        return this.evaluateExpressions;
    }

    public void setEvaluateExpressions(Boolean evaluateExpressions) {
        this.evaluateExpressions = evaluateExpressions;
    }

    public DescribeObjectsRequest withEvaluateExpressions(Boolean evaluateExpressions) {
        this.evaluateExpressions = evaluateExpressions;
        return this;
    }

    public Boolean getEvaluateExpressions() {
        return this.evaluateExpressions;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeObjectsRequest withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getObjectIds() != null) {
            sb.append("ObjectIds: " + this.getObjectIds() + ",");
        }
        if (this.isEvaluateExpressions() != null) {
            sb.append("EvaluateExpressions: " + this.isEvaluateExpressions() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getObjectIds() == null ? 0 : this.getObjectIds().hashCode());
        hashCode = 31 * hashCode + (this.isEvaluateExpressions() == null ? 0 : this.isEvaluateExpressions().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsRequest)) {
            return false;
        }
        DescribeObjectsRequest other = (DescribeObjectsRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getObjectIds() == null ^ this.getObjectIds() == null) {
            return false;
        }
        if (other.getObjectIds() != null && !other.getObjectIds().equals(this.getObjectIds())) {
            return false;
        }
        if (other.isEvaluateExpressions() == null ^ this.isEvaluateExpressions() == null) {
            return false;
        }
        if (other.isEvaluateExpressions() != null && !other.isEvaluateExpressions().equals(this.isEvaluateExpressions())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    @Override
    public DescribeObjectsRequest clone() {
        return (DescribeObjectsRequest)super.clone();
    }
}

