/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.DirectoryVpcSettings;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateDirectoryRequestMarshaller
implements Marshaller<Request<CreateDirectoryRequest>, CreateDirectoryRequest> {
    @Override
    public Request<CreateDirectoryRequest> marshall(CreateDirectoryRequest createDirectoryRequest) {
        if (createDirectoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDirectoryRequest> request = new DefaultRequest<CreateDirectoryRequest>(createDirectoryRequest, "AWSDirectoryService");
        String target = "DirectoryService_20150416.CreateDirectory";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            DirectoryVpcSettings vpcSettings;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDirectoryRequest.getName() != null) {
                jsonWriter.key("Name").value(createDirectoryRequest.getName());
            }
            if (createDirectoryRequest.getShortName() != null) {
                jsonWriter.key("ShortName").value(createDirectoryRequest.getShortName());
            }
            if (createDirectoryRequest.getPassword() != null) {
                jsonWriter.key("Password").value(createDirectoryRequest.getPassword());
            }
            if (createDirectoryRequest.getDescription() != null) {
                jsonWriter.key("Description").value(createDirectoryRequest.getDescription());
            }
            if (createDirectoryRequest.getSize() != null) {
                jsonWriter.key("Size").value(createDirectoryRequest.getSize());
            }
            if ((vpcSettings = createDirectoryRequest.getVpcSettings()) != null) {
                ListWithAutoConstructFlag subnetIdsList;
                jsonWriter.key("VpcSettings");
                jsonWriter.object();
                if (vpcSettings.getVpcId() != null) {
                    jsonWriter.key("VpcId").value(vpcSettings.getVpcId());
                }
                if (!((subnetIdsList = (ListWithAutoConstructFlag)vpcSettings.getSubnetIds()) == null || subnetIdsList.isAutoConstruct() && subnetIdsList.isEmpty())) {
                    jsonWriter.key("SubnetIds");
                    jsonWriter.array();
                    for (String subnetIdsListValue : subnetIdsList) {
                        if (subnetIdsListValue == null) continue;
                        jsonWriter.value(subnetIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

