/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.RadiusSettings;
import com.amazonaws.services.directory.model.UpdateRadiusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateRadiusRequestMarshaller
implements Marshaller<Request<UpdateRadiusRequest>, UpdateRadiusRequest> {
    @Override
    public Request<UpdateRadiusRequest> marshall(UpdateRadiusRequest updateRadiusRequest) {
        if (updateRadiusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateRadiusRequest> request = new DefaultRequest<UpdateRadiusRequest>(updateRadiusRequest, "AWSDirectoryService");
        String target = "DirectoryService_20150416.UpdateRadius";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            RadiusSettings radiusSettings;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateRadiusRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(updateRadiusRequest.getDirectoryId());
            }
            if ((radiusSettings = updateRadiusRequest.getRadiusSettings()) != null) {
                jsonWriter.key("RadiusSettings");
                jsonWriter.object();
                ListWithAutoConstructFlag radiusServersList = (ListWithAutoConstructFlag)radiusSettings.getRadiusServers();
                if (!(radiusServersList == null || radiusServersList.isAutoConstruct() && radiusServersList.isEmpty())) {
                    jsonWriter.key("RadiusServers");
                    jsonWriter.array();
                    for (String radiusServersListValue : radiusServersList) {
                        if (radiusServersListValue == null) continue;
                        jsonWriter.value(radiusServersListValue);
                    }
                    jsonWriter.endArray();
                }
                if (radiusSettings.getRadiusPort() != null) {
                    jsonWriter.key("RadiusPort").value(radiusSettings.getRadiusPort());
                }
                if (radiusSettings.getRadiusTimeout() != null) {
                    jsonWriter.key("RadiusTimeout").value(radiusSettings.getRadiusTimeout());
                }
                if (radiusSettings.getRadiusRetries() != null) {
                    jsonWriter.key("RadiusRetries").value(radiusSettings.getRadiusRetries());
                }
                if (radiusSettings.getSharedSecret() != null) {
                    jsonWriter.key("SharedSecret").value(radiusSettings.getSharedSecret());
                }
                if (radiusSettings.getAuthenticationProtocol() != null) {
                    jsonWriter.key("AuthenticationProtocol").value(radiusSettings.getAuthenticationProtocol());
                }
                if (radiusSettings.getDisplayLabel() != null) {
                    jsonWriter.key("DisplayLabel").value(radiusSettings.getDisplayLabel());
                }
                if (radiusSettings.isUseSameUsername() != null) {
                    jsonWriter.key("UseSameUsername").value(radiusSettings.isUseSameUsername());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

