/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeVpcPeeringConnectionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeVpcPeeringConnectionsRequest> {
    private ListWithAutoConstructFlag<String> vpcPeeringConnectionIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getVpcPeeringConnectionIds() {
        if (this.vpcPeeringConnectionIds == null) {
            this.vpcPeeringConnectionIds = new ListWithAutoConstructFlag();
            this.vpcPeeringConnectionIds.setAutoConstruct(true);
        }
        return this.vpcPeeringConnectionIds;
    }

    public void setVpcPeeringConnectionIds(Collection<String> vpcPeeringConnectionIds) {
        if (vpcPeeringConnectionIds == null) {
            this.vpcPeeringConnectionIds = null;
            return;
        }
        ListWithAutoConstructFlag vpcPeeringConnectionIdsCopy = new ListWithAutoConstructFlag(vpcPeeringConnectionIds.size());
        vpcPeeringConnectionIdsCopy.addAll(vpcPeeringConnectionIds);
        this.vpcPeeringConnectionIds = vpcPeeringConnectionIdsCopy;
    }

    public DescribeVpcPeeringConnectionsRequest withVpcPeeringConnectionIds(String ... vpcPeeringConnectionIds) {
        if (this.getVpcPeeringConnectionIds() == null) {
            this.setVpcPeeringConnectionIds(new ArrayList<String>(vpcPeeringConnectionIds.length));
        }
        for (String value : vpcPeeringConnectionIds) {
            this.getVpcPeeringConnectionIds().add(value);
        }
        return this;
    }

    public DescribeVpcPeeringConnectionsRequest withVpcPeeringConnectionIds(Collection<String> vpcPeeringConnectionIds) {
        if (vpcPeeringConnectionIds == null) {
            this.vpcPeeringConnectionIds = null;
        } else {
            ListWithAutoConstructFlag vpcPeeringConnectionIdsCopy = new ListWithAutoConstructFlag(vpcPeeringConnectionIds.size());
            vpcPeeringConnectionIdsCopy.addAll(vpcPeeringConnectionIds);
            this.vpcPeeringConnectionIds = vpcPeeringConnectionIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeVpcPeeringConnectionsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeVpcPeeringConnectionsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeVpcPeeringConnectionsRequest> getDryRunRequest() {
        Request<DescribeVpcPeeringConnectionsRequest> request = new DescribeVpcPeeringConnectionsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcPeeringConnectionIds() != null) {
            sb.append("VpcPeeringConnectionIds: " + this.getVpcPeeringConnectionIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcPeeringConnectionIds() == null ? 0 : this.getVpcPeeringConnectionIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsRequest)) {
            return false;
        }
        DescribeVpcPeeringConnectionsRequest other = (DescribeVpcPeeringConnectionsRequest)obj;
        if (other.getVpcPeeringConnectionIds() == null ^ this.getVpcPeeringConnectionIds() == null) {
            return false;
        }
        if (other.getVpcPeeringConnectionIds() != null && !other.getVpcPeeringConnectionIds().equals(this.getVpcPeeringConnectionIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    @Override
    public DescribeVpcPeeringConnectionsRequest clone() {
        return (DescribeVpcPeeringConnectionsRequest)super.clone();
    }
}

