/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.ImportVolumeRequest;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportVolumeRequestMarshaller
implements Marshaller<Request<ImportVolumeRequest>, ImportVolumeRequest> {
    @Override
    public Request<ImportVolumeRequest> marshall(ImportVolumeRequest importVolumeRequest) {
        VolumeDetail volumeDetailVolume;
        DiskImageDetail diskImageDetailImage;
        if (importVolumeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportVolumeRequest> request = new DefaultRequest<ImportVolumeRequest>(importVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "ImportVolume");
        request.addParameter("Version", "2015-04-15");
        if (importVolumeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(importVolumeRequest.getAvailabilityZone()));
        }
        if ((diskImageDetailImage = importVolumeRequest.getImage()) != null) {
            if (diskImageDetailImage.getFormat() != null) {
                request.addParameter("Image.Format", StringUtils.fromString(diskImageDetailImage.getFormat()));
            }
            if (diskImageDetailImage.getBytes() != null) {
                request.addParameter("Image.Bytes", StringUtils.fromLong(diskImageDetailImage.getBytes()));
            }
            if (diskImageDetailImage.getImportManifestUrl() != null) {
                request.addParameter("Image.ImportManifestUrl", StringUtils.fromString(diskImageDetailImage.getImportManifestUrl()));
            }
        }
        if (importVolumeRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(importVolumeRequest.getDescription()));
        }
        if ((volumeDetailVolume = importVolumeRequest.getVolume()) != null && volumeDetailVolume.getSize() != null) {
            request.addParameter("Volume.Size", StringUtils.fromLong(volumeDetailVolume.getSize()));
        }
        return request;
    }
}

