/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeTasksRequestMarshaller
implements Marshaller<Request<DescribeTasksRequest>, DescribeTasksRequest> {
    @Override
    public Request<DescribeTasksRequest> marshall(DescribeTasksRequest describeTasksRequest) {
        if (describeTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTasksRequest> request = new DefaultRequest<DescribeTasksRequest>(describeTasksRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.DescribeTasks";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag tasksList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeTasksRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(describeTasksRequest.getCluster());
            }
            if (!((tasksList = (ListWithAutoConstructFlag)describeTasksRequest.getTasks()) == null || tasksList.isAutoConstruct() && tasksList.isEmpty())) {
                jsonWriter.key("tasks");
                jsonWriter.array();
                for (String tasksListValue : tasksList) {
                    if (tasksListValue == null) continue;
                    jsonWriter.value(tasksListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

