/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListTasksRequestMarshaller
implements Marshaller<Request<ListTasksRequest>, ListTasksRequest> {
    @Override
    public Request<ListTasksRequest> marshall(ListTasksRequest listTasksRequest) {
        if (listTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTasksRequest> request = new DefaultRequest<ListTasksRequest>(listTasksRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.ListTasks";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listTasksRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(listTasksRequest.getCluster());
            }
            if (listTasksRequest.getContainerInstance() != null) {
                jsonWriter.key("containerInstance").value(listTasksRequest.getContainerInstance());
            }
            if (listTasksRequest.getFamily() != null) {
                jsonWriter.key("family").value(listTasksRequest.getFamily());
            }
            if (listTasksRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listTasksRequest.getNextToken());
            }
            if (listTasksRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value(listTasksRequest.getMaxResults());
            }
            if (listTasksRequest.getStartedBy() != null) {
                jsonWriter.key("startedBy").value(listTasksRequest.getStartedBy());
            }
            if (listTasksRequest.getServiceName() != null) {
                jsonWriter.key("serviceName").value(listTasksRequest.getServiceName());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

