/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeCacheParametersRequestMarshaller
implements Marshaller<Request<DescribeCacheParametersRequest>, DescribeCacheParametersRequest> {
    @Override
    public Request<DescribeCacheParametersRequest> marshall(DescribeCacheParametersRequest describeCacheParametersRequest) {
        if (describeCacheParametersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCacheParametersRequest> request = new DefaultRequest<DescribeCacheParametersRequest>(describeCacheParametersRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeCacheParameters");
        request.addParameter("Version", "2015-02-02");
        if (describeCacheParametersRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString(describeCacheParametersRequest.getCacheParameterGroupName()));
        }
        if (describeCacheParametersRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(describeCacheParametersRequest.getSource()));
        }
        if (describeCacheParametersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeCacheParametersRequest.getMaxRecords()));
        }
        if (describeCacheParametersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeCacheParametersRequest.getMarker()));
        }
        return request;
    }
}

