/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetVisibleToAllUsersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> jobFlowIds;
    private Boolean visibleToAllUsers;

    public List<String> getJobFlowIds() {
        if (this.jobFlowIds == null) {
            this.jobFlowIds = new ListWithAutoConstructFlag();
            this.jobFlowIds.setAutoConstruct(true);
        }
        return this.jobFlowIds;
    }

    public void setJobFlowIds(Collection<String> jobFlowIds) {
        if (jobFlowIds == null) {
            this.jobFlowIds = null;
            return;
        }
        ListWithAutoConstructFlag jobFlowIdsCopy = new ListWithAutoConstructFlag(jobFlowIds.size());
        jobFlowIdsCopy.addAll(jobFlowIds);
        this.jobFlowIds = jobFlowIdsCopy;
    }

    public SetVisibleToAllUsersRequest withJobFlowIds(String ... jobFlowIds) {
        if (this.getJobFlowIds() == null) {
            this.setJobFlowIds(new ArrayList<String>(jobFlowIds.length));
        }
        for (String value : jobFlowIds) {
            this.getJobFlowIds().add(value);
        }
        return this;
    }

    public SetVisibleToAllUsersRequest withJobFlowIds(Collection<String> jobFlowIds) {
        if (jobFlowIds == null) {
            this.jobFlowIds = null;
        } else {
            ListWithAutoConstructFlag jobFlowIdsCopy = new ListWithAutoConstructFlag(jobFlowIds.size());
            jobFlowIdsCopy.addAll(jobFlowIds);
            this.jobFlowIds = jobFlowIdsCopy;
        }
        return this;
    }

    public Boolean isVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public void setVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
    }

    public SetVisibleToAllUsersRequest withVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
        return this;
    }

    public Boolean getVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobFlowIds() != null) {
            sb.append("JobFlowIds: " + this.getJobFlowIds() + ",");
        }
        if (this.isVisibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: " + this.isVisibleToAllUsers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobFlowIds() == null ? 0 : this.getJobFlowIds().hashCode());
        hashCode = 31 * hashCode + (this.isVisibleToAllUsers() == null ? 0 : this.isVisibleToAllUsers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetVisibleToAllUsersRequest)) {
            return false;
        }
        SetVisibleToAllUsersRequest other = (SetVisibleToAllUsersRequest)obj;
        if (other.getJobFlowIds() == null ^ this.getJobFlowIds() == null) {
            return false;
        }
        if (other.getJobFlowIds() != null && !other.getJobFlowIds().equals(this.getJobFlowIds())) {
            return false;
        }
        if (other.isVisibleToAllUsers() == null ^ this.isVisibleToAllUsers() == null) {
            return false;
        }
        return other.isVisibleToAllUsers() == null || other.isVisibleToAllUsers().equals(this.isVisibleToAllUsers());
    }

    @Override
    public SetVisibleToAllUsersRequest clone() {
        return (SetVisibleToAllUsersRequest)super.clone();
    }
}

