/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.logs.AWSLogsAsync;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DeleteLogGroupRequest;
import com.amazonaws.services.logs.model.DeleteLogStreamRequest;
import com.amazonaws.services.logs.model.DeleteMetricFilterRequest;
import com.amazonaws.services.logs.model.DeleteRetentionPolicyRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.DescribeMetricFiltersRequest;
import com.amazonaws.services.logs.model.DescribeMetricFiltersResult;
import com.amazonaws.services.logs.model.FilterLogEventsRequest;
import com.amazonaws.services.logs.model.FilterLogEventsResult;
import com.amazonaws.services.logs.model.GetLogEventsRequest;
import com.amazonaws.services.logs.model.GetLogEventsResult;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.PutMetricFilterRequest;
import com.amazonaws.services.logs.model.PutRetentionPolicyRequest;
import com.amazonaws.services.logs.model.TestMetricFilterRequest;
import com.amazonaws.services.logs.model.TestMetricFilterResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSLogsAsyncClient
extends AWSLogsClient
implements AWSLogsAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSLogsAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSLogsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> putRetentionPolicyAsync(final PutRetentionPolicyRequest putRetentionPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.putRetentionPolicy(putRetentionPolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putRetentionPolicyAsync(final PutRetentionPolicyRequest putRetentionPolicyRequest, final AsyncHandler<PutRetentionPolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.putRetentionPolicy(putRetentionPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putRetentionPolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeMetricFiltersResult> describeMetricFiltersAsync(final DescribeMetricFiltersRequest describeMetricFiltersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMetricFiltersResult>(){

            @Override
            public DescribeMetricFiltersResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeMetricFilters(describeMetricFiltersRequest);
            }
        });
    }

    @Override
    public Future<DescribeMetricFiltersResult> describeMetricFiltersAsync(final DescribeMetricFiltersRequest describeMetricFiltersRequest, final AsyncHandler<DescribeMetricFiltersRequest, DescribeMetricFiltersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMetricFiltersResult>(){

            @Override
            public DescribeMetricFiltersResult call() throws Exception {
                DescribeMetricFiltersResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeMetricFilters(describeMetricFiltersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeMetricFiltersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLogStreamsResult> describeLogStreamsAsync(final DescribeLogStreamsRequest describeLogStreamsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogStreamsResult>(){

            @Override
            public DescribeLogStreamsResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeLogStreams(describeLogStreamsRequest);
            }
        });
    }

    @Override
    public Future<DescribeLogStreamsResult> describeLogStreamsAsync(final DescribeLogStreamsRequest describeLogStreamsRequest, final AsyncHandler<DescribeLogStreamsRequest, DescribeLogStreamsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogStreamsResult>(){

            @Override
            public DescribeLogStreamsResult call() throws Exception {
                DescribeLogStreamsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeLogStreams(describeLogStreamsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeLogStreamsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteLogGroupAsync(final DeleteLogGroupRequest deleteLogGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteLogGroup(deleteLogGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLogGroupAsync(final DeleteLogGroupRequest deleteLogGroupRequest, final AsyncHandler<DeleteLogGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteLogGroup(deleteLogGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteLogGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createLogGroupAsync(final CreateLogGroupRequest createLogGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.createLogGroup(createLogGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createLogGroupAsync(final CreateLogGroupRequest createLogGroupRequest, final AsyncHandler<CreateLogGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.createLogGroup(createLogGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createLogGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<TestMetricFilterResult> testMetricFilterAsync(final TestMetricFilterRequest testMetricFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TestMetricFilterResult>(){

            @Override
            public TestMetricFilterResult call() throws Exception {
                return AWSLogsAsyncClient.this.testMetricFilter(testMetricFilterRequest);
            }
        });
    }

    @Override
    public Future<TestMetricFilterResult> testMetricFilterAsync(final TestMetricFilterRequest testMetricFilterRequest, final AsyncHandler<TestMetricFilterRequest, TestMetricFilterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TestMetricFilterResult>(){

            @Override
            public TestMetricFilterResult call() throws Exception {
                TestMetricFilterResult result;
                try {
                    result = AWSLogsAsyncClient.this.testMetricFilter(testMetricFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(testMetricFilterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putMetricFilterAsync(final PutMetricFilterRequest putMetricFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.putMetricFilter(putMetricFilterRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putMetricFilterAsync(final PutMetricFilterRequest putMetricFilterRequest, final AsyncHandler<PutMetricFilterRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.putMetricFilter(putMetricFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putMetricFilterRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMetricFilterAsync(final DeleteMetricFilterRequest deleteMetricFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteMetricFilter(deleteMetricFilterRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMetricFilterAsync(final DeleteMetricFilterRequest deleteMetricFilterRequest, final AsyncHandler<DeleteMetricFilterRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteMetricFilter(deleteMetricFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteMetricFilterRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<PutLogEventsResult> putLogEventsAsync(final PutLogEventsRequest putLogEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutLogEventsResult>(){

            @Override
            public PutLogEventsResult call() throws Exception {
                return AWSLogsAsyncClient.this.putLogEvents(putLogEventsRequest);
            }
        });
    }

    @Override
    public Future<PutLogEventsResult> putLogEventsAsync(final PutLogEventsRequest putLogEventsRequest, final AsyncHandler<PutLogEventsRequest, PutLogEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutLogEventsResult>(){

            @Override
            public PutLogEventsResult call() throws Exception {
                PutLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.putLogEvents(putLogEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putLogEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<FilterLogEventsResult> filterLogEventsAsync(final FilterLogEventsRequest filterLogEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<FilterLogEventsResult>(){

            @Override
            public FilterLogEventsResult call() throws Exception {
                return AWSLogsAsyncClient.this.filterLogEvents(filterLogEventsRequest);
            }
        });
    }

    @Override
    public Future<FilterLogEventsResult> filterLogEventsAsync(final FilterLogEventsRequest filterLogEventsRequest, final AsyncHandler<FilterLogEventsRequest, FilterLogEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<FilterLogEventsResult>(){

            @Override
            public FilterLogEventsResult call() throws Exception {
                FilterLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.filterLogEvents(filterLogEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(filterLogEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteRetentionPolicyAsync(final DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteRetentionPolicy(deleteRetentionPolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRetentionPolicyAsync(final DeleteRetentionPolicyRequest deleteRetentionPolicyRequest, final AsyncHandler<DeleteRetentionPolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteRetentionPolicy(deleteRetentionPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteRetentionPolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetLogEventsResult> getLogEventsAsync(final GetLogEventsRequest getLogEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetLogEventsResult>(){

            @Override
            public GetLogEventsResult call() throws Exception {
                return AWSLogsAsyncClient.this.getLogEvents(getLogEventsRequest);
            }
        });
    }

    @Override
    public Future<GetLogEventsResult> getLogEventsAsync(final GetLogEventsRequest getLogEventsRequest, final AsyncHandler<GetLogEventsRequest, GetLogEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetLogEventsResult>(){

            @Override
            public GetLogEventsResult call() throws Exception {
                GetLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.getLogEvents(getLogEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getLogEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createLogStreamAsync(final CreateLogStreamRequest createLogStreamRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.createLogStream(createLogStreamRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createLogStreamAsync(final CreateLogStreamRequest createLogStreamRequest, final AsyncHandler<CreateLogStreamRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.createLogStream(createLogStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createLogStreamRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLogStreamAsync(final DeleteLogStreamRequest deleteLogStreamRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteLogStream(deleteLogStreamRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLogStreamAsync(final DeleteLogStreamRequest deleteLogStreamRequest, final AsyncHandler<DeleteLogStreamRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteLogStream(deleteLogStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteLogStreamRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync(final DescribeLogGroupsRequest describeLogGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogGroupsResult>(){

            @Override
            public DescribeLogGroupsResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeLogGroups(describeLogGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync(final DescribeLogGroupsRequest describeLogGroupsRequest, final AsyncHandler<DescribeLogGroupsRequest, DescribeLogGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogGroupsResult>(){

            @Override
            public DescribeLogGroupsResult call() throws Exception {
                DescribeLogGroupsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeLogGroups(describeLogGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeLogGroupsRequest, result);
                return result;
            }
        });
    }
}

