/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateHsmClientCertificateRequestMarshaller
implements Marshaller<Request<CreateHsmClientCertificateRequest>, CreateHsmClientCertificateRequest> {
    @Override
    public Request<CreateHsmClientCertificateRequest> marshall(CreateHsmClientCertificateRequest createHsmClientCertificateRequest) {
        if (createHsmClientCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateHsmClientCertificateRequest> request = new DefaultRequest<CreateHsmClientCertificateRequest>(createHsmClientCertificateRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateHsmClientCertificate");
        request.addParameter("Version", "2012-12-01");
        if (createHsmClientCertificateRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString(createHsmClientCertificateRequest.getHsmClientCertificateIdentifier()));
        }
        List<Tag> tagsList = createHsmClientCertificateRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

