/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateHsmConfigurationRequestMarshaller
implements Marshaller<Request<CreateHsmConfigurationRequest>, CreateHsmConfigurationRequest> {
    @Override
    public Request<CreateHsmConfigurationRequest> marshall(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        if (createHsmConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateHsmConfigurationRequest> request = new DefaultRequest<CreateHsmConfigurationRequest>(createHsmConfigurationRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateHsmConfiguration");
        request.addParameter("Version", "2012-12-01");
        if (createHsmConfigurationRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString(createHsmConfigurationRequest.getHsmConfigurationIdentifier()));
        }
        if (createHsmConfigurationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createHsmConfigurationRequest.getDescription()));
        }
        if (createHsmConfigurationRequest.getHsmIpAddress() != null) {
            request.addParameter("HsmIpAddress", StringUtils.fromString(createHsmConfigurationRequest.getHsmIpAddress()));
        }
        if (createHsmConfigurationRequest.getHsmPartitionName() != null) {
            request.addParameter("HsmPartitionName", StringUtils.fromString(createHsmConfigurationRequest.getHsmPartitionName()));
        }
        if (createHsmConfigurationRequest.getHsmPartitionPassword() != null) {
            request.addParameter("HsmPartitionPassword", StringUtils.fromString(createHsmConfigurationRequest.getHsmPartitionPassword()));
        }
        if (createHsmConfigurationRequest.getHsmServerPublicCertificate() != null) {
            request.addParameter("HsmServerPublicCertificate", StringUtils.fromString(createHsmConfigurationRequest.getHsmServerPublicCertificate()));
        }
        List<Tag> tagsList = createHsmConfigurationRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

