/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53domains.model.DeleteTagsForDomainRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DeleteTagsForDomainRequestMarshaller
implements Marshaller<Request<DeleteTagsForDomainRequest>, DeleteTagsForDomainRequest> {
    @Override
    public Request<DeleteTagsForDomainRequest> marshall(DeleteTagsForDomainRequest deleteTagsForDomainRequest) {
        if (deleteTagsForDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteTagsForDomainRequest> request = new DefaultRequest<DeleteTagsForDomainRequest>(deleteTagsForDomainRequest, "AmazonRoute53Domains");
        String target = "Route53Domains_v20140515.DeleteTagsForDomain";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag tagsToDeleteList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteTagsForDomainRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value(deleteTagsForDomainRequest.getDomainName());
            }
            if (!((tagsToDeleteList = (ListWithAutoConstructFlag)deleteTagsForDomainRequest.getTagsToDelete()) == null || tagsToDeleteList.isAutoConstruct() && tagsToDeleteList.isEmpty())) {
                jsonWriter.key("TagsToDelete");
                jsonWriter.array();
                for (String tagsToDeleteListValue : tagsToDeleteList) {
                    if (tagsToDeleteListValue == null) continue;
                    jsonWriter.value(tagsToDeleteListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

