/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateAssociationRequestMarshaller
implements Marshaller<Request<CreateAssociationRequest>, CreateAssociationRequest> {
    @Override
    public Request<CreateAssociationRequest> marshall(CreateAssociationRequest createAssociationRequest) {
        if (createAssociationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAssociationRequest> request = new DefaultRequest<CreateAssociationRequest>(createAssociationRequest, "AWSSimpleSystemsManagement");
        String target = "AmazonSSM.CreateAssociation";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createAssociationRequest.getName() != null) {
                jsonWriter.key("Name").value(createAssociationRequest.getName());
            }
            if (createAssociationRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(createAssociationRequest.getInstanceId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

