/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.ActivityFailureException;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityExecutionContextImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import com.amazonaws.services.simpleworkflow.flow.worker.SynchronousRetrier;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.UnknownResourceException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchronousActivityTaskPoller
implements TaskPoller {
    private static final Log log = LogFactory.getLog(SynchronousActivityTaskPoller.class);
    private AmazonSimpleWorkflow service;
    private String domain;
    private String taskListToPoll;
    private ActivityImplementationFactory activityImplementationFactory;
    private String identity = ManagementFactory.getRuntimeMXBean().getName();
    private SynchronousRetrier reportCompletionRetrier;
    private SynchronousRetrier reportFailureRetrier;
    private boolean initialized;

    public SynchronousActivityTaskPoller(AmazonSimpleWorkflow service, String domain, String taskListToPoll, ActivityImplementationFactory activityImplementationFactory) {
        this();
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = taskListToPoll;
        this.activityImplementationFactory = activityImplementationFactory;
        this.setReportCompletionRetryParameters(new ExponentialRetryParameters());
        this.setReportFailureRetryParameters(new ExponentialRetryParameters());
    }

    public SynchronousActivityTaskPoller() {
        int length = Math.min(this.identity.length(), 256);
        this.identity = this.identity.substring(0, length);
    }

    public AmazonSimpleWorkflow getService() {
        return this.service;
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.service = service;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPollTaskList() {
        return this.taskListToPoll;
    }

    public void setTaskListToPoll(String taskList) {
        this.taskListToPoll = taskList;
    }

    public ActivityImplementationFactory getActivityImplementationFactory() {
        return this.activityImplementationFactory;
    }

    public void setActivityImplementationFactory(ActivityImplementationFactory activityImplementationFactory) {
        this.activityImplementationFactory = activityImplementationFactory;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public ExponentialRetryParameters getReportCompletionRetryParameters() {
        return this.reportCompletionRetrier.getRetryParameters();
    }

    public void setReportCompletionRetryParameters(ExponentialRetryParameters reportCompletionRetryParameters) {
        this.reportCompletionRetrier = new SynchronousRetrier(reportCompletionRetryParameters, UnknownResourceException.class);
    }

    public ExponentialRetryParameters getReportFailureRetryParameters() {
        return this.reportFailureRetrier.getRetryParameters();
    }

    public void setReportFailureRetryParameters(ExponentialRetryParameters reportFailureRetryParameters) {
        this.reportFailureRetrier = new SynchronousRetrier(reportFailureRetryParameters, UnknownResourceException.class);
    }

    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public ActivityTask poll() {
        ActivityTask result;
        if (!this.initialized) {
            this.checkRequiredProperty(this.service, "service");
            this.checkRequiredProperty(this.domain, "domain");
            this.checkRequiredProperty(this.taskListToPoll, "taskListToPoll");
            this.initialized = true;
        }
        PollForActivityTaskRequest pollRequest = new PollForActivityTaskRequest();
        pollRequest.setDomain(this.domain);
        pollRequest.setIdentity(this.identity);
        pollRequest.setTaskList(new TaskList().withName(this.taskListToPoll));
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request begin: " + pollRequest));
        }
        if ((result = this.service.pollForActivityTask(pollRequest)) == null || result.getTaskToken() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"poll request returned no task");
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("poll request returned " + result));
        }
        return result;
    }

    @Override
    public boolean pollAndProcessSingleTask() throws Exception {
        ActivityTask task = this.poll();
        if (task == null) {
            return false;
        }
        this.execute(task);
        return true;
    }

    protected void execute(ActivityTask task) throws Exception {
        String output = null;
        ActivityType activityType = task.getActivityType();
        try {
            ActivityExecutionContextImpl context = new ActivityExecutionContextImpl(this.service, this.domain, task);
            ActivityImplementation activityImplementation = this.activityImplementationFactory.getActivityImplementation(activityType);
            if (activityImplementation == null) {
                throw new ActivityFailureException("Unknown activity type: " + activityType);
            }
            output = activityImplementation.execute(context);
            if (!activityImplementation.getExecutionOptions().isManualActivityCompletion()) {
                this.respondActivityTaskCompletedWithRetry(task.getTaskToken(), output);
            }
        }
        catch (CancellationException e) {
            this.respondActivityTaskCanceledWithRetry(task.getTaskToken(), null);
            return;
        }
        catch (ActivityFailureException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failure processing activity task with taskId=" + task.getStartedEventId() + ", workflowGenerationId=" + task.getWorkflowExecution().getWorkflowId() + ", activity=" + activityType + ", activityInstanceId=" + task.getActivityId()), (Throwable)e);
            }
            this.respondActivityTaskFailedWithRetry(task.getTaskToken(), e.getReason(), e.getDetails());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failure processing activity task with taskId=" + task.getStartedEventId() + ", workflowGenerationId=" + task.getWorkflowExecution().getWorkflowId() + ", activity=" + activityType + ", activityInstanceId=" + task.getActivityId()), (Throwable)e);
            }
            String reason = e.getMessage();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String details = sw.toString();
            this.respondActivityTaskFailedWithRetry(task.getTaskToken(), reason, details);
        }
    }

    protected void respondActivityTaskFailedWithRetry(final String taskToken, final String reason, final String details) {
        if (this.reportFailureRetrier == null) {
            this.respondActivityTaskFailed(taskToken, reason, details);
        } else {
            this.reportFailureRetrier.retry(new Runnable(){

                @Override
                public void run() {
                    SynchronousActivityTaskPoller.this.respondActivityTaskFailed(taskToken, reason, details);
                }
            });
        }
    }

    protected void respondActivityTaskFailed(String taskToken, String reason, String details) {
        RespondActivityTaskFailedRequest failedResponse = new RespondActivityTaskFailedRequest();
        failedResponse.setTaskToken(taskToken);
        failedResponse.setReason(WorkflowExecutionUtils.truncateReason(reason));
        failedResponse.setDetails(details);
        this.service.respondActivityTaskFailed(failedResponse);
    }

    protected void respondActivityTaskCanceledWithRetry(final String taskToken, final String details) {
        if (this.reportFailureRetrier == null) {
            this.respondActivityTaskCanceled(taskToken, details);
        } else {
            this.reportFailureRetrier.retry(new Runnable(){

                @Override
                public void run() {
                    SynchronousActivityTaskPoller.this.respondActivityTaskCanceled(taskToken, details);
                }
            });
        }
    }

    protected void respondActivityTaskCanceled(String taskToken, String details) {
        RespondActivityTaskCanceledRequest canceledResponse = new RespondActivityTaskCanceledRequest();
        canceledResponse.setTaskToken(taskToken);
        canceledResponse.setDetails(details);
        this.service.respondActivityTaskCanceled(canceledResponse);
    }

    protected void respondActivityTaskCompletedWithRetry(final String taskToken, final String output) {
        if (this.reportCompletionRetrier == null) {
            this.respondActivityTaskCompleted(taskToken, output);
        } else {
            this.reportCompletionRetrier.retry(new Runnable(){

                @Override
                public void run() {
                    SynchronousActivityTaskPoller.this.respondActivityTaskCompleted(taskToken, output);
                }
            });
        }
    }

    protected void respondActivityTaskCompleted(String taskToken, String output) {
        RespondActivityTaskCompletedRequest completedReponse = new RespondActivityTaskCompletedRequest();
        completedReponse.setTaskToken(taskToken);
        completedReponse.setResult(output);
        this.service.respondActivityTaskCompleted(completedReponse);
    }

    protected void checkRequiredProperty(Object value, String name) {
        if (value == null) {
            throw new IllegalStateException("required property " + name + " is not set");
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void shutdownNow() {
    }

    @Override
    public boolean awaitTermination(long left, TimeUnit milliseconds) throws InterruptedException {
        return true;
    }
}

