/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.FailedCreateWorkspaceRequest;
import com.amazonaws.services.workspaces.model.Workspace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateWorkspacesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<FailedCreateWorkspaceRequest> failedRequests;
    private ListWithAutoConstructFlag<Workspace> pendingRequests;

    public List<FailedCreateWorkspaceRequest> getFailedRequests() {
        if (this.failedRequests == null) {
            this.failedRequests = new ListWithAutoConstructFlag();
            this.failedRequests.setAutoConstruct(true);
        }
        return this.failedRequests;
    }

    public void setFailedRequests(Collection<FailedCreateWorkspaceRequest> failedRequests) {
        if (failedRequests == null) {
            this.failedRequests = null;
            return;
        }
        ListWithAutoConstructFlag failedRequestsCopy = new ListWithAutoConstructFlag(failedRequests.size());
        failedRequestsCopy.addAll(failedRequests);
        this.failedRequests = failedRequestsCopy;
    }

    public CreateWorkspacesResult withFailedRequests(FailedCreateWorkspaceRequest ... failedRequests) {
        if (this.getFailedRequests() == null) {
            this.setFailedRequests(new ArrayList<FailedCreateWorkspaceRequest>(failedRequests.length));
        }
        for (FailedCreateWorkspaceRequest value : failedRequests) {
            this.getFailedRequests().add(value);
        }
        return this;
    }

    public CreateWorkspacesResult withFailedRequests(Collection<FailedCreateWorkspaceRequest> failedRequests) {
        if (failedRequests == null) {
            this.failedRequests = null;
        } else {
            ListWithAutoConstructFlag failedRequestsCopy = new ListWithAutoConstructFlag(failedRequests.size());
            failedRequestsCopy.addAll(failedRequests);
            this.failedRequests = failedRequestsCopy;
        }
        return this;
    }

    public List<Workspace> getPendingRequests() {
        if (this.pendingRequests == null) {
            this.pendingRequests = new ListWithAutoConstructFlag();
            this.pendingRequests.setAutoConstruct(true);
        }
        return this.pendingRequests;
    }

    public void setPendingRequests(Collection<Workspace> pendingRequests) {
        if (pendingRequests == null) {
            this.pendingRequests = null;
            return;
        }
        ListWithAutoConstructFlag pendingRequestsCopy = new ListWithAutoConstructFlag(pendingRequests.size());
        pendingRequestsCopy.addAll(pendingRequests);
        this.pendingRequests = pendingRequestsCopy;
    }

    public CreateWorkspacesResult withPendingRequests(Workspace ... pendingRequests) {
        if (this.getPendingRequests() == null) {
            this.setPendingRequests(new ArrayList<Workspace>(pendingRequests.length));
        }
        for (Workspace value : pendingRequests) {
            this.getPendingRequests().add(value);
        }
        return this;
    }

    public CreateWorkspacesResult withPendingRequests(Collection<Workspace> pendingRequests) {
        if (pendingRequests == null) {
            this.pendingRequests = null;
        } else {
            ListWithAutoConstructFlag pendingRequestsCopy = new ListWithAutoConstructFlag(pendingRequests.size());
            pendingRequestsCopy.addAll(pendingRequests);
            this.pendingRequests = pendingRequestsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFailedRequests() != null) {
            sb.append("FailedRequests: " + this.getFailedRequests() + ",");
        }
        if (this.getPendingRequests() != null) {
            sb.append("PendingRequests: " + this.getPendingRequests());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFailedRequests() == null ? 0 : this.getFailedRequests().hashCode());
        hashCode = 31 * hashCode + (this.getPendingRequests() == null ? 0 : this.getPendingRequests().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesResult)) {
            return false;
        }
        CreateWorkspacesResult other = (CreateWorkspacesResult)obj;
        if (other.getFailedRequests() == null ^ this.getFailedRequests() == null) {
            return false;
        }
        if (other.getFailedRequests() != null && !other.getFailedRequests().equals(this.getFailedRequests())) {
            return false;
        }
        if (other.getPendingRequests() == null ^ this.getPendingRequests() == null) {
            return false;
        }
        return other.getPendingRequests() == null || other.getPendingRequests().equals(this.getPendingRequests());
    }

    public CreateWorkspacesResult clone() {
        try {
            return (CreateWorkspacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

