/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.WorkspaceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeWorkspaceBundlesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<WorkspaceBundle> bundles;
    private String nextToken;

    public List<WorkspaceBundle> getBundles() {
        if (this.bundles == null) {
            this.bundles = new ListWithAutoConstructFlag();
            this.bundles.setAutoConstruct(true);
        }
        return this.bundles;
    }

    public void setBundles(Collection<WorkspaceBundle> bundles) {
        if (bundles == null) {
            this.bundles = null;
            return;
        }
        ListWithAutoConstructFlag bundlesCopy = new ListWithAutoConstructFlag(bundles.size());
        bundlesCopy.addAll(bundles);
        this.bundles = bundlesCopy;
    }

    public DescribeWorkspaceBundlesResult withBundles(WorkspaceBundle ... bundles) {
        if (this.getBundles() == null) {
            this.setBundles(new ArrayList<WorkspaceBundle>(bundles.length));
        }
        for (WorkspaceBundle value : bundles) {
            this.getBundles().add(value);
        }
        return this;
    }

    public DescribeWorkspaceBundlesResult withBundles(Collection<WorkspaceBundle> bundles) {
        if (bundles == null) {
            this.bundles = null;
        } else {
            ListWithAutoConstructFlag bundlesCopy = new ListWithAutoConstructFlag(bundles.size());
            bundlesCopy.addAll(bundles);
            this.bundles = bundlesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeWorkspaceBundlesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBundles() != null) {
            sb.append("Bundles: " + this.getBundles() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBundles() == null ? 0 : this.getBundles().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceBundlesResult)) {
            return false;
        }
        DescribeWorkspaceBundlesResult other = (DescribeWorkspaceBundlesResult)obj;
        if (other.getBundles() == null ^ this.getBundles() == null) {
            return false;
        }
        if (other.getBundles() != null && !other.getBundles().equals(this.getBundles())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeWorkspaceBundlesResult clone() {
        try {
            return (DescribeWorkspaceBundlesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

