/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class LeftParenthesisPrinter
extends AbstractPrinter {
    private static final LeftParenthesisPrinter INSTANCE = new LeftParenthesisPrinter();

    private LeftParenthesisPrinter() {
    }

    public static LeftParenthesisPrinter getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_PAREN, false)) {
            out.print("( ", 108);
        } else {
            out.print("(", 108);
        }
        this.printCommentsAfter(node, false, true, out);
        if (out.mode == 1 && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false)) {
            block0 : switch (node.getType()) {
                case 108: {
                    JavaNode parent = ((JavaNode)node).getParent();
                    switch (parent.getType()) {
                        case 13: 
                        case 14: 
                        case 32: 
                        case 33: 
                        case 80: 
                        case 121: 
                        case 123: 
                        case 124: 
                        case 128: 
                        case 131: 
                        case 135: 
                        case 168: {
                            break block0;
                        }
                    }
                    this.wrap(node, parent, out);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void wrap(AST leftParen, JavaNode parent, NodeWriter out) throws IOException {
        TestNodeWriter tester = out.testers.get();
        AST rightParen = null;
        int count = 0;
        AST child = leftParen;
        block4: while (child != null) {
            PrinterFactory.create(child, out).print(child, tester);
            switch (child.getType()) {
                case 108: {
                    ++count;
                    break;
                }
                case 109: {
                    if (--count != 0) break;
                    rightParen = child;
                    break block4;
                }
            }
            child = child.getNextSibling();
        }
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        if (out.column + tester.length > lineLength) {
            out.printNewline();
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
            } else {
                out.indent();
            }
            out.state.parentheses.add(rightParen);
            this.printIndentation(out);
        }
        out.testers.release(tester);
    }
}

