/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input;

import org.j3d.device.input.DeviceState;

public class TrackerState
extends DeviceState {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_PRESS = 2;
    public static final int TYPE_DRAG = 4;
    public static final int TYPE_CLICK = 8;
    public static final int TYPE_RELEASE = 16;
    public static final int TYPE_MOVE = 32;
    public static final int TYPE_ORIENTATION = 64;
    public static final int TYPE_BUTTON = 128;
    public static final int TYPE_WHEEL = 256;
    public int actionMask;
    public int actionType = 0;
    public float[] devicePos = new float[3];
    public float[] deviceOri = new float[3];
    public float[] worldPos = new float[3];
    public float[] worldOri = new float[3];
    public boolean[] buttonState = new boolean[16];
    public boolean[] pickingEnabled;
    public int[] buttonMode = new int[16];
    public int numButtons = 0;
    public int wheelClicks;
    public boolean shiftModifier;
    public boolean altModifier;
    public boolean ctrlModifier;

    public TrackerState() {
        this.pickingEnabled = new boolean[16];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TrackerState: ");
        stringBuilder.append("Type: ");
        switch (this.actionType) {
            case 0: {
                stringBuilder.append("NONE ");
                break;
            }
            case 2: {
                stringBuilder.append("PRESS ");
                break;
            }
            case 4: {
                stringBuilder.append("DRAG ");
                break;
            }
            case 8: {
                stringBuilder.append("CLICK ");
                break;
            }
            case 16: {
                stringBuilder.append("RELEASE ");
                break;
            }
            case 32: {
                stringBuilder.append("MOVE ");
                break;
            }
            case 64: {
                stringBuilder.append("ORIENTATION ");
                break;
            }
            case 128: {
                stringBuilder.append("BUTTON ");
                break;
            }
            case 256: {
                stringBuilder.append("WHEEL ");
                break;
            }
            default: {
                stringBuilder.append("Unknown");
            }
        }
        stringBuilder.append("\n Device coords: ");
        stringBuilder.append(this.devicePos[0]);
        stringBuilder.append(' ');
        stringBuilder.append(this.devicePos[1]);
        stringBuilder.append(' ');
        stringBuilder.append(this.devicePos[2]);
        stringBuilder.append(' ');
        stringBuilder.append("orientation: ");
        stringBuilder.append(this.deviceOri[0]);
        stringBuilder.append(' ');
        stringBuilder.append(this.deviceOri[1]);
        stringBuilder.append(' ');
        stringBuilder.append(this.deviceOri[2]);
        stringBuilder.append("\n World coords: ");
        stringBuilder.append(this.worldPos[0]);
        stringBuilder.append(' ');
        stringBuilder.append(this.worldPos[1]);
        stringBuilder.append(' ');
        stringBuilder.append(this.worldPos[2]);
        stringBuilder.append(' ');
        stringBuilder.append("orientation: ");
        stringBuilder.append(this.worldOri[0]);
        stringBuilder.append(' ');
        stringBuilder.append(this.worldOri[1]);
        stringBuilder.append(' ');
        stringBuilder.append(this.worldOri[2]);
        return stringBuilder.toString();
    }
}

