/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.jinput;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import org.j3d.device.input.JoystickDevice;
import org.j3d.device.input.JoystickState;
import org.j3d.device.input.Tracker;
import org.j3d.device.input.TrackerDevice;
import org.j3d.device.input.jinput.AxisTracker;

public class Joystick
implements JoystickDevice,
TrackerDevice {
    private static final float DEVICE_THRESHOLD = 0.02f;
    private Controller controller;
    private Component[] axes;
    private String name;
    private Tracker[] trackers;
    private int[] controllerFuncs;
    private float[] lastVals;

    public Joystick(Controller controller, String string) {
        this.controller = controller;
        this.name = string;
        this.axes = controller.getComponents();
        this.trackers = new Tracker[1];
        Component[] componentArray = new Component[2];
        int[] nArray = new int[2];
        this.controllerFuncs = new int[this.axes.length];
        this.lastVals = new float[this.axes.length];
        for (int i = 0; i < this.axes.length; ++i) {
            if (this.axes[i].getName().equals("X Axis")) {
                componentArray[0] = this.axes[i];
                nArray[0] = 1;
                this.controllerFuncs[i] = 6;
                continue;
            }
            if (this.axes[i].getName().equals("Y Axis")) {
                componentArray[1] = this.axes[i];
                nArray[1] = 2;
                this.controllerFuncs[i] = 7;
                continue;
            }
            if (this.axes[i].getName().equals("Z Rotation")) {
                this.controllerFuncs[i] = 19;
                continue;
            }
            if (this.axes[i].getName().equals("Hat Switch")) {
                this.controllerFuncs[i] = 10;
                continue;
            }
            if (this.axes[i].getName().equals("Button 0")) {
                this.controllerFuncs[i] = 11;
                continue;
            }
            if (!this.axes[i].getName().equals("Rudder") && !this.axes[i].getName().equals("Extra") && !this.axes[i].getName().equals("Throttle")) continue;
        }
        AxisTracker axisTracker = new AxisTracker(componentArray, nArray);
        this.trackers[0] = axisTracker;
    }

    public String getName() {
        return this.name;
    }

    public void getState(JoystickState joystickState) {
        this.controller.poll();
        int n = this.axes.length;
        block8: for (int i = 0; i < n; ++i) {
            float f = this.axes[i].getPollData();
            if (Math.abs(this.lastVals[i] - f) < 0.02f) continue;
            this.lastVals[i] = f;
            switch (this.controllerFuncs[i]) {
                case 6: {
                    joystickState.stickX = f;
                    joystickState.stickX_changed = true;
                    continue block8;
                }
                case 7: {
                    joystickState.stickY = -f;
                    joystickState.stickY_changed = true;
                    continue block8;
                }
                case 19: {
                    joystickState.stickZ = -f;
                    joystickState.stickZ_changed = true;
                    continue block8;
                }
                case 10: {
                    if (f == 1.0f) {
                        joystickState.hatX = -1.0f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = 0.0f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    if (f == 0.875f) {
                        joystickState.hatX = -0.5f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = 0.5f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    if (f == 0.75f) {
                        joystickState.hatX = 0.0f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = 1.0f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    if (f == 0.625f) {
                        joystickState.hatX = 0.5f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = 0.5f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    if (f == 0.5f) {
                        joystickState.hatX = 1.0f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = 0.0f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    if (f == 0.375f) {
                        joystickState.hatX = 0.5f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = -0.5f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    if (f == 0.25f) {
                        joystickState.hatX = 0.0f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = -1.0f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    if (f == 0.125f) {
                        joystickState.hatX = -0.5f;
                        joystickState.hatX_changed = true;
                        joystickState.hatY = -0.5f;
                        joystickState.hatY_changed = true;
                        continue block8;
                    }
                    joystickState.hatX = 0.0f;
                    joystickState.hatX_changed = true;
                    joystickState.hatY = 0.0f;
                    joystickState.hatY_changed = true;
                    continue block8;
                }
                case 0: {
                    joystickState.throttleSlider = -f;
                    joystickState.throttleSlider_changed = true;
                    continue block8;
                }
                case 11: {
                    joystickState.triggerButton = f == 1.0f;
                    joystickState.triggerButton_changed = true;
                }
            }
        }
    }

    public int getTrackerCount() {
        return this.trackers.length;
    }

    public Tracker[] getTrackers() {
        return this.trackers;
    }
}

