/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.jinput;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.j3d.device.input.DeviceListener;
import org.j3d.device.input.DeviceManager;
import org.j3d.device.input.InputDevice;
import org.j3d.device.input.jinput.Gamepad;
import org.j3d.device.input.jinput.Joystick;
import org.j3d.device.input.jinput.Wheel;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.I18nManager;

public class USBManager
implements DeviceManager {
    private static final String DETECT_INTRO_PROP = "org.j3d.device.input.jinput.USBManager.detectIntroMsg";
    private static final String DETECT_LIST_PROP = "org.j3d.device.input.jinput.USBManager.detectDeviceListMsg";
    private static final String DEVICE_AXIS_DESC_PROP = "org.j3d.device.input.jinput.USBManager.deviceAxisListMsg";
    private static final String MISSING_DEVICE_NAME_PROP = "org.j3d.device.input.jinput.USBManager.missingDeviceNameMsg";
    private static final String UNKNOWN_DEVICE_PROP = "org.j3d.device.input.jinput.USBManager.unknownDeviceMsg";
    private static final String DETECT_OS_FAIL_PROP = "org.j3d.device.input.jinput.USBManager.detectOSFailMsg";
    private static final String MISSING_OS_PROP = "org.j3d.device.input.jinput.USBManager.unsupportedOSMsg";
    private ArrayList<InputDevice> devices;
    private ArrayList<DeviceListener> deviceListeners;
    private ErrorReporter errorReporter;
    private boolean deviceListInit = Package.getPackage("net.java.games.input") == null;

    public USBManager() {
        this.devices = new ArrayList();
        this.deviceListeners = new ArrayList();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public int getNumDevices() {
        if (!this.deviceListInit) {
            this.loadDevices();
        }
        return this.devices.size();
    }

    public InputDevice[] getDevices() {
        if (!this.deviceListInit) {
            this.loadDevices();
        }
        InputDevice[] inputDeviceArray = new InputDevice[this.devices.size()];
        this.devices.toArray(inputDeviceArray);
        return inputDeviceArray;
    }

    public void addDeviceListener(DeviceListener deviceListener) {
        if (!this.deviceListeners.contains(deviceListener)) {
            this.deviceListeners.add(deviceListener);
        }
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.deviceListeners.remove(deviceListener);
    }

    private void loadDevices() {
        this.setupProperties();
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        Controller[] controllerArray = controllerEnvironment.getControllers();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = controllerArray.length;
        I18nManager i18nManager = I18nManager.getManager();
        String string = i18nManager.getString(DETECT_INTRO_PROP);
        Locale locale = i18nManager.getFoundLocale();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        Object[] objectArray = new Object[]{new Float(n4)};
        Format[] formatArray = new Format[]{numberFormat};
        MessageFormat messageFormat = new MessageFormat(string, locale);
        messageFormat.setFormats(formatArray);
        String string2 = messageFormat.format(objectArray);
        this.errorReporter.messageReport(string2);
        String string3 = i18nManager.getString(DETECT_LIST_PROP);
        Format[] formatArray2 = new Format[]{null, numberFormat};
        MessageFormat messageFormat2 = new MessageFormat(string3, locale);
        messageFormat2.setFormats(formatArray);
        for (int i = 0; i < n4; ++i) {
            Controller controller = controllerArray[i];
            Object[] objectArray2 = new Object[]{controller.getName(), new Integer(controller.getRumblers().length)};
            String string4 = messageFormat2.format(objectArray2);
            this.errorReporter.messageReport(string4);
            Controller.Type type = controller.getType();
            String string5 = controller.getName();
            if (string5 == null) {
                string2 = i18nManager.getString(MISSING_DEVICE_NAME_PROP);
                this.errorReporter.warningReport(string2, null);
                continue;
            }
            if (string5.indexOf("RumblePad") > -1 || string5.indexOf("WingMan Cordless Gamepad") > -1 || string5.indexOf("Logitech Dual Action") > -1) {
                this.devices.add(new Gamepad(controller, "Gamepad-" + n));
                ++n;
                continue;
            }
            if (string5.indexOf("Extreme Digital 3D") > -1 || string5.indexOf("Freedom 2.4") > -1) {
                this.devices.add(new Joystick(controller, "Joystick-" + n2));
                ++n2;
                continue;
            }
            if (string5.indexOf("MOMO Racing") > -1 || string5.indexOf("Logitech Racing Wheel") > -1) {
                this.devices.add(new Wheel(controller, "Wheel-" + n3));
                ++n3;
                continue;
            }
            if (string5.indexOf("SpaceBall 5000") > -1 || string5.startsWith("Mouse") || string5.startsWith("Keyboard")) continue;
            string2 = i18nManager.getString(UNKNOWN_DEVICE_PROP);
            this.errorReporter.messageReport(string2);
            this.printDevice(controller);
        }
        this.deviceListInit = true;
    }

    private void setupProperties() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String string = System.getProperty("os.name").toLowerCase();
                    if (!(string.startsWith("windows") || string.startsWith("mac") || string.startsWith("linux"))) {
                        I18nManager i18nManager = I18nManager.getManager();
                        String string2 = i18nManager.getString(USBManager.MISSING_OS_PROP);
                        Locale locale = i18nManager.getFoundLocale();
                        Object[] objectArray = new Object[]{string};
                        Format[] formatArray = new Format[]{null};
                        MessageFormat messageFormat = new MessageFormat(string2, locale);
                        String string3 = messageFormat.format(objectArray);
                        messageFormat.setFormats(formatArray);
                        USBManager.this.errorReporter.warningReport(string3, null);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(DETECT_OS_FAIL_PROP);
            this.errorReporter.warningReport(string, null);
        }
    }

    private void printDevice(Controller controller) {
        Component[] componentArray = controller.getComponents();
        int n = componentArray.length;
        I18nManager i18nManager = I18nManager.getManager();
        String string = i18nManager.getString(DEVICE_AXIS_DESC_PROP);
        Locale locale = i18nManager.getFoundLocale();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        Format[] formatArray = new Format[]{null, null};
        MessageFormat messageFormat = new MessageFormat(string, locale);
        messageFormat.setFormats(formatArray);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new Object[]{componentArray[i].getName(), componentArray[i].getIdentifier().getName()};
            String string2 = messageFormat.format(objectArray);
            this.errorReporter.messageReport(string2);
        }
    }
}

