/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class TorusGenerator
extends GeometryGenerator {
    private static final float DEFAULT_INNER_RADIUS = 0.25f;
    private static final float DEFAULT_OUTER_RADIUS = 1.0f;
    private static final int DEFAULT_INNER_FACETS = 16;
    private static final int DEFAULT_OUTER_FACETS = 16;
    private float innerRadius;
    private float outerRadius;
    private int innerFacetCount;
    private int outerFacetCount;
    private float[] shapeCoordinates;
    private int numShapeValues;
    private boolean shapeChanged;
    private float[] oradiusCoordinates;

    public TorusGenerator() {
        this(0.25f, 1.0f, 16, 16);
    }

    public TorusGenerator(float f, float f2) {
        this(f, f2, 16, 16);
    }

    public TorusGenerator(int n, int n2) {
        this(0.25f, 1.0f, n, n2);
    }

    public TorusGenerator(float f, float f2, int n, int n2) {
        if (n < 4 || n2 < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Inner facets not / 2");
        }
        this.innerRadius = f;
        this.outerRadius = f2;
        this.innerFacetCount = n;
        this.outerFacetCount = n2;
        this.shapeChanged = true;
    }

    public float[] getDimensions() {
        return new float[]{this.innerRadius, this.outerRadius};
    }

    public void setDimensions(float f, float f2) {
        if (this.innerRadius != f || this.outerRadius != f2) {
            this.shapeChanged = true;
            this.innerRadius = f;
            this.outerRadius = f2;
        }
    }

    public void setFacetCount(int n, int n2) {
        if (n < 4 || n2 < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Inner facets not / 2");
        }
        this.innerFacetCount = n;
        this.outerFacetCount = n2;
        this.shapeChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.innerFacetCount * this.outerFacetCount * 6;
                break;
            }
            case 2: {
                n = this.innerFacetCount * this.outerFacetCount * 4;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n = this.innerFacetCount * (this.outerFacetCount + 1) * 2;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedQuadNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        int n4;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n5 = geometryData.vertexCount * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n5];
        } else if (geometryData.indexes.length < n5) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n5);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n5;
        int n6 = 0;
        int n7 = this.innerFacetCount / 2;
        int n8 = this.outerFacetCount - 1;
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = n4 * this.innerFacetCount;
            for (n2 = 0; n2 < n8; ++n2) {
                n = n2 + n3;
                nArray[n6++] = n + this.outerFacetCount;
                nArray[n6++] = n;
                nArray[n6++] = n + 1;
                nArray[n6++] = n + this.outerFacetCount + 1;
            }
            n = n2 + n3;
            nArray[n6++] = n + this.outerFacetCount;
            nArray[n6++] = n;
            nArray[n6++] = n3;
            nArray[n6++] = n3 + this.outerFacetCount;
        }
        for (n4 = n7 + 1; n4 <= n7 * 2; ++n4) {
            n3 = n4 * this.innerFacetCount;
            for (n2 = 0; n2 < n8; ++n2) {
                n = n2 + n3;
                nArray[n6++] = n;
                nArray[n6++] = n + this.outerFacetCount;
                nArray[n6++] = n + this.outerFacetCount + 1;
                nArray[n6++] = n + 1;
            }
            n = n2 + n3;
            nArray[n6++] = n;
            nArray[n6++] = n + this.outerFacetCount;
            nArray[n6++] = n3 + this.outerFacetCount;
            nArray[n6++] = n3;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        int n4;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n5 = geometryData.vertexCount * 6;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n5];
        } else if (geometryData.indexes.length < n5) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n5);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n5;
        int n6 = 0;
        int n7 = this.innerFacetCount / 2;
        int n8 = this.outerFacetCount - 1;
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = n4 * this.innerFacetCount;
            for (n2 = 0; n2 < n8; ++n2) {
                n = n2 + n3;
                nArray[n6++] = n + this.outerFacetCount;
                nArray[n6++] = n;
                nArray[n6++] = n + 1;
                nArray[n6++] = n + 1;
                nArray[n6++] = n + this.outerFacetCount + 1;
                nArray[n6++] = n + this.outerFacetCount;
            }
            n = n2 + n3;
            nArray[n6++] = n + this.outerFacetCount;
            nArray[n6++] = n;
            nArray[n6++] = n3;
            nArray[n6++] = n3;
            nArray[n6++] = n3 + this.outerFacetCount;
            nArray[n6++] = n + this.outerFacetCount;
        }
        for (n4 = n7 + 1; n4 <= n7 * 2; ++n4) {
            n3 = n4 * this.innerFacetCount;
            for (n2 = 0; n2 < n8; ++n2) {
                n = n2 + n3;
                nArray[n6++] = n;
                nArray[n6++] = n + this.outerFacetCount;
                nArray[n6++] = n + this.outerFacetCount + 1;
                nArray[n6++] = n + this.outerFacetCount + 1;
                nArray[n6++] = n + 1;
                nArray[n6++] = n;
            }
            n = n2 + n3;
            nArray[n6++] = n;
            nArray[n6++] = n + this.outerFacetCount;
            nArray[n6++] = n3 + this.outerFacetCount;
            nArray[n6++] = n3 + this.outerFacetCount;
            nArray[n6++] = n3;
            nArray[n6++] = n;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.innerFacetCount;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = this.outerFacetCount + 1 << 1;
        int[] nArray = geometryData.stripCounts;
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
        geometryData.numStrips = n;
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        int n4;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n5 = this.innerFacetCount * (this.outerFacetCount + 1) * 2;
        int n6 = this.innerFacetCount;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n5];
        } else if (geometryData.indexes.length < n5) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n5);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n6];
        } else if (geometryData.stripCounts.length < n6) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n6);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n5;
        geometryData.numStrips = n6;
        int n7 = 0;
        int n8 = this.innerFacetCount / 2;
        for (n4 = 0; n4 < n8; ++n4) {
            n3 = n4 * this.innerFacetCount;
            nArray2[n4] = this.outerFacetCount + 1 << 1;
            for (n2 = 0; n2 < this.outerFacetCount; ++n2) {
                n = n2 + n3;
                nArray[n7++] = n + this.outerFacetCount;
                nArray[n7++] = n;
            }
            nArray[n7++] = n3 + this.outerFacetCount;
            nArray[n7++] = n3;
        }
        for (n4 = n8; n4 < n8 * 2; ++n4) {
            n3 = (n4 + 1) * this.innerFacetCount;
            nArray2[n4] = this.outerFacetCount + 1 << 1;
            for (n2 = 0; n2 < this.outerFacetCount; ++n2) {
                n = n2 + n3;
                nArray[n7++] = n;
                nArray[n7++] = n + this.outerFacetCount;
            }
            nArray[n7++] = n3;
            nArray[n7++] = n3 + this.outerFacetCount;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.innerFacetCount * this.outerFacetCount * 6;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n2 * 3];
        } else if (geometryData.coordinates.length < n2 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n2 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n2;
        this.generateShape();
        int n3 = this.innerFacetCount / 2;
        int n4 = this.outerFacetCount * 3;
        int n5 = this.outerFacetCount - 1;
        int n6 = 0;
        for (n = 0; n < n3; ++n) {
            int n7;
            int n8;
            int n9 = n * n4;
            for (n8 = 0; n8 < n5; ++n8) {
                n7 = n8 * 3 + n9;
                fArray[n6++] = this.shapeCoordinates[n7 + n4];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 1];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 2];
                fArray[n6++] = this.shapeCoordinates[n7];
                fArray[n6++] = this.shapeCoordinates[n7 + 1];
                fArray[n6++] = this.shapeCoordinates[n7 + 2];
                fArray[n6++] = this.shapeCoordinates[n7 + 3];
                fArray[n6++] = this.shapeCoordinates[n7 + 4];
                fArray[n6++] = this.shapeCoordinates[n7 + 5];
                fArray[n6++] = this.shapeCoordinates[n7 + 3];
                fArray[n6++] = this.shapeCoordinates[n7 + 4];
                fArray[n6++] = this.shapeCoordinates[n7 + 5];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 3];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 4];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 5];
                fArray[n6++] = this.shapeCoordinates[n7 + n4];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 1];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 2];
            }
            n7 = n8 * 3 + n9;
            fArray[n6++] = this.shapeCoordinates[n7 + n4];
            fArray[n6++] = this.shapeCoordinates[n7 + n4 + 1];
            fArray[n6++] = this.shapeCoordinates[n7 + n4 + 2];
            fArray[n6++] = this.shapeCoordinates[n7];
            fArray[n6++] = this.shapeCoordinates[n7 + 1];
            fArray[n6++] = this.shapeCoordinates[n7 + 2];
            fArray[n6++] = this.shapeCoordinates[n9];
            fArray[n6++] = this.shapeCoordinates[n9 + 1];
            fArray[n6++] = this.shapeCoordinates[n9 + 2];
            fArray[n6++] = this.shapeCoordinates[n9];
            fArray[n6++] = this.shapeCoordinates[n9 + 1];
            fArray[n6++] = this.shapeCoordinates[n9 + 2];
            fArray[n6++] = this.shapeCoordinates[n9 + n4];
            fArray[n6++] = this.shapeCoordinates[n9 + n4 + 1];
            fArray[n6++] = this.shapeCoordinates[n9 + n4 + 2];
            fArray[n6++] = this.shapeCoordinates[n7 + n4];
            fArray[n6++] = this.shapeCoordinates[n7 + n4 + 1];
            fArray[n6++] = this.shapeCoordinates[n7 + n4 + 2];
        }
        int n10 = n6;
        for (n = 0; n < n10; n += 18) {
            fArray[n6++] = fArray[n + 6];
            fArray[n6++] = -fArray[n + 7];
            fArray[n6++] = fArray[n + 8];
            fArray[n6++] = fArray[n + 3];
            fArray[n6++] = -fArray[n + 4];
            fArray[n6++] = fArray[n + 5];
            fArray[n6++] = fArray[n + 0];
            fArray[n6++] = -fArray[n + 1];
            fArray[n6++] = fArray[n + 2];
            fArray[n6++] = fArray[n + 15];
            fArray[n6++] = -fArray[n + 16];
            fArray[n6++] = fArray[n + 17];
            fArray[n6++] = fArray[n + 12];
            fArray[n6++] = -fArray[n + 13];
            fArray[n6++] = fArray[n + 14];
            fArray[n6++] = fArray[n + 9];
            fArray[n6++] = -fArray[n + 10];
            fArray[n6++] = fArray[n + 11];
        }
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.innerFacetCount * this.outerFacetCount * 4;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n2 * 3];
        } else if (geometryData.coordinates.length < n2 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n2 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n2;
        this.generateShape();
        int n3 = this.innerFacetCount / 2;
        int n4 = this.outerFacetCount * 3;
        int n5 = this.outerFacetCount - 1;
        int n6 = 0;
        for (n = 0; n < n3; ++n) {
            int n7;
            int n8;
            int n9 = n * n4;
            for (n8 = 0; n8 < n5; ++n8) {
                n7 = n8 * 3 + n9;
                fArray[n6++] = this.shapeCoordinates[n7 + n4];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 1];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 2];
                fArray[n6++] = this.shapeCoordinates[n7];
                fArray[n6++] = this.shapeCoordinates[n7 + 1];
                fArray[n6++] = this.shapeCoordinates[n7 + 2];
                fArray[n6++] = this.shapeCoordinates[n7 + 3];
                fArray[n6++] = this.shapeCoordinates[n7 + 4];
                fArray[n6++] = this.shapeCoordinates[n7 + 5];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 3];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 4];
                fArray[n6++] = this.shapeCoordinates[n7 + n4 + 5];
            }
            n7 = n8 * 3 + n9;
            fArray[n6++] = this.shapeCoordinates[n7 + n4];
            fArray[n6++] = this.shapeCoordinates[n7 + n4 + 1];
            fArray[n6++] = this.shapeCoordinates[n7 + n4 + 2];
            fArray[n6++] = this.shapeCoordinates[n7];
            fArray[n6++] = this.shapeCoordinates[n7 + 1];
            fArray[n6++] = this.shapeCoordinates[n7 + 2];
            fArray[n6++] = this.shapeCoordinates[n9];
            fArray[n6++] = this.shapeCoordinates[n9 + 1];
            fArray[n6++] = this.shapeCoordinates[n9 + 2];
            fArray[n6++] = this.shapeCoordinates[n9 + n4];
            fArray[n6++] = this.shapeCoordinates[n9 + n4 + 1];
            fArray[n6++] = this.shapeCoordinates[n9 + n4 + 2];
        }
        int n10 = n6;
        for (n = 0; n < n10; n += 12) {
            fArray[n6++] = fArray[n + 3];
            fArray[n6++] = -fArray[n + 4];
            fArray[n6++] = fArray[n + 5];
            fArray[n6++] = fArray[n];
            fArray[n6++] = -fArray[n + 1];
            fArray[n6++] = fArray[n + 2];
            fArray[n6++] = fArray[n + 9];
            fArray[n6++] = -fArray[n + 10];
            fArray[n6++] = fArray[n + 11];
            fArray[n6++] = fArray[n + 6];
            fArray[n6++] = -fArray[n + 7];
            fArray[n6++] = fArray[n + 8];
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.innerFacetCount * (this.outerFacetCount + 1) * 2;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n2 * 3];
        } else if (geometryData.coordinates.length < n2 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n2 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n2;
        this.generateShape();
        int n3 = this.innerFacetCount / 2;
        int n4 = this.outerFacetCount * 3;
        int n5 = 0;
        for (n = 0; n < n3; ++n) {
            int n6 = n * n4;
            for (int i = 0; i < this.outerFacetCount; ++i) {
                int n7 = i * 3 + n6;
                fArray[n5++] = this.shapeCoordinates[n7 + n4];
                fArray[n5++] = this.shapeCoordinates[n7 + n4 + 1];
                fArray[n5++] = this.shapeCoordinates[n7 + n4 + 2];
                fArray[n5++] = this.shapeCoordinates[n7];
                fArray[n5++] = this.shapeCoordinates[n7 + 1];
                fArray[n5++] = this.shapeCoordinates[n7 + 2];
            }
            fArray[n5++] = this.shapeCoordinates[n6 + n4];
            fArray[n5++] = this.shapeCoordinates[n6 + n4 + 1];
            fArray[n5++] = this.shapeCoordinates[n6 + n4 + 2];
            fArray[n5++] = this.shapeCoordinates[n6];
            fArray[n5++] = this.shapeCoordinates[n6 + 1];
            fArray[n5++] = this.shapeCoordinates[n6 + 2];
        }
        int n8 = n5;
        for (n = 0; n < n8; n += 6) {
            fArray[n5++] = fArray[n + 3];
            fArray[n5++] = -fArray[n + 4];
            fArray[n5++] = fArray[n + 5];
            fArray[n5++] = fArray[n];
            fArray[n5++] = -fArray[n + 1];
            fArray[n5++] = fArray[n + 2];
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.generateShape();
        System.arraycopy(this.shapeCoordinates, 0, geometryData.coordinates, 0, this.numShapeValues);
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n2 = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n3 = 0;
        float[] fArray2 = new float[3];
        int n4 = 0;
        int n5 = this.outerFacetCount * 4;
        for (n = 0; n < n2; ++n) {
            Vector3f vector3f;
            n4 = 0;
            int n6 = this.outerFacetCount;
            while (--n6 > 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4 + 3);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4 + 3);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4 + 3);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                n4 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, 0);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, 0);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, 0);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
        }
        int n7 = n3;
        for (n = 0; n < n7; n += 18) {
            fArray[n3++] = fArray[n + 6];
            fArray[n3++] = -fArray[n + 7];
            fArray[n3++] = fArray[n + 8];
            fArray[n3++] = fArray[n + 3];
            fArray[n3++] = -fArray[n + 4];
            fArray[n3++] = fArray[n + 5];
            fArray[n3++] = fArray[n + 0];
            fArray[n3++] = -fArray[n + 1];
            fArray[n3++] = fArray[n + 2];
            fArray[n3++] = fArray[n + 15];
            fArray[n3++] = -fArray[n + 16];
            fArray[n3++] = fArray[n + 17];
            fArray[n3++] = fArray[n + 12];
            fArray[n3++] = -fArray[n + 13];
            fArray[n3++] = fArray[n + 14];
            fArray[n3++] = fArray[n + 9];
            fArray[n3++] = -fArray[n + 10];
            fArray[n3++] = fArray[n + 11];
        }
    }

    private void generateUnindexedQuadNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n2 = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n3 = 0;
        float[] fArray2 = new float[3];
        int n4 = 0;
        int n5 = this.outerFacetCount * 4;
        for (n = 0; n < n2; ++n) {
            n4 = 0;
            Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            int n6 = this.outerFacetCount;
            while (--n6 > 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4 += 3);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                fArray[n3 + 6] = vector3f.x;
                fArray[n3 + 7] = vector3f.y;
                fArray[n3 + 8] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                n3 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, 0);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, 0);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
        }
        int n7 = n3;
        for (n = 0; n < n7; n += 12) {
            fArray[n3++] = fArray[n + 3];
            fArray[n3++] = -fArray[n + 4];
            fArray[n3++] = fArray[n + 5];
            fArray[n3++] = fArray[n];
            fArray[n3++] = -fArray[n + 1];
            fArray[n3++] = fArray[n + 2];
            fArray[n3++] = fArray[n + 9];
            fArray[n3++] = -fArray[n + 10];
            fArray[n3++] = fArray[n + 11];
            fArray[n3++] = fArray[n + 6];
            fArray[n3++] = -fArray[n + 7];
            fArray[n3++] = fArray[n + 8];
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n2 = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n3 = 0;
        float[] fArray2 = new float[3];
        int n4 = 0;
        int n5 = this.outerFacetCount * 4;
        for (n = 0; n < n2; ++n) {
            Vector3f vector3f;
            n4 = 0;
            int n6 = this.outerFacetCount;
            while (--n6 >= 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                n4 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, 0);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, 0);
            fArray[n3++] = vector3f.x;
            fArray[n3++] = vector3f.y;
            fArray[n3++] = vector3f.z;
        }
        int n7 = n3;
        for (n = 0; n < n7; n += 6) {
            fArray[n3++] = fArray[n + 3];
            fArray[n3++] = -fArray[n + 4];
            fArray[n3++] = fArray[n + 5];
            fArray[n3++] = fArray[n];
            fArray[n3++] = -fArray[n + 1];
            fArray[n3++] = fArray[n + 2];
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n2 = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n3 = 0;
        float[] fArray2 = new float[3];
        int n4 = 0;
        for (int i = 0; i <= n2; ++i) {
            n4 = 0;
            n = this.outerFacetCount;
            while (--n >= 0) {
                Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                n4 += 3;
            }
        }
        int n5 = n3;
        System.arraycopy(fArray, 0, fArray, n5, n5);
        for (n = geometryData.vertexCount * 3 - 2; n > n5; n -= 3) {
            fArray[n] = -fArray[n];
        }
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateShape() {
        int n;
        if (!this.shapeChanged) {
            return;
        }
        this.shapeChanged = false;
        int n2 = (this.innerFacetCount * this.outerFacetCount + this.outerFacetCount * 2) * 3;
        if (this.shapeCoordinates == null || n2 > this.shapeCoordinates.length) {
            this.shapeCoordinates = new float[n2];
            this.oradiusCoordinates = new float[this.outerFacetCount * 3];
        }
        this.numShapeValues = n2;
        double d = Math.PI * 2 * (double)this.outerRadius / (double)this.outerFacetCount;
        float f = (float)(d / (double)this.outerRadius);
        d = Math.PI * 2 * (double)this.innerRadius / (double)this.innerFacetCount;
        float f2 = (float)(d / (double)this.innerRadius);
        int n3 = this.innerFacetCount / 2;
        int n4 = 0;
        float f3 = this.outerRadius + this.innerRadius;
        float[] fArray = new float[this.outerFacetCount];
        float[] fArray2 = new float[this.outerFacetCount];
        for (n = 0; n < this.outerFacetCount; ++n) {
            fArray[n] = (float)Math.cos(f * (float)n);
            fArray2[n] = (float)Math.sin(f * (float)n);
            this.shapeCoordinates[n4] = f3 * fArray[n];
            this.shapeCoordinates[n4 + 1] = 0.0f;
            this.shapeCoordinates[n4 + 2] = -f3 * fArray2[n];
            this.oradiusCoordinates[n4++] = this.outerRadius * fArray[n];
            this.oradiusCoordinates[n4++] = 0.0f;
            this.oradiusCoordinates[n4++] = -this.outerRadius * fArray2[n];
        }
        for (int i = 1; i < n3; ++i) {
            f3 = this.outerRadius + this.innerRadius * (float)Math.cos(f2 * (float)i);
            float f4 = this.innerRadius * (float)Math.sin(f2 * (float)i);
            for (n = 0; n < this.outerFacetCount; ++n) {
                this.shapeCoordinates[n4++] = f3 * fArray[n];
                this.shapeCoordinates[n4++] = f4;
                this.shapeCoordinates[n4++] = -f3 * fArray2[n];
            }
        }
        f3 = this.outerRadius - this.innerRadius;
        for (n = 0; n < this.outerFacetCount; ++n) {
            this.shapeCoordinates[n4++] = f3 * fArray[n];
            this.shapeCoordinates[n4++] = 0.0f;
            this.shapeCoordinates[n4++] = -f3 * fArray2[n];
        }
        int n5 = n4;
        System.arraycopy(this.shapeCoordinates, 0, this.shapeCoordinates, n5, n5);
        for (n = this.shapeCoordinates.length - 2; n > n5; n -= 3) {
            this.shapeCoordinates[n] = -this.shapeCoordinates[n];
        }
    }
}

