/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.hanim;

import org.j3d.geom.hanim.HAnimDisplacer;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.util.I18nManager;

public class HAnimSegment
extends HAnimObject {
    private static final String MIN_ARRAY_SIZE_PROP = "org.j3d.geom.hanim.HAnimSegment.minArraySizeMsg";
    protected float[] bboxCenter = new float[3];
    protected float[] bboxSize = new float[3];
    private float[] centerOfMass;
    private float[] momentsOfInertia = new float[9];
    private int numMoments;
    private float[] coords;
    private int numCoords;
    protected Object[] children;
    protected int numChildren;
    private HAnimDisplacer[] displacers;
    private int numDisplacers;
    private float mass = -1.0f;

    public HAnimSegment() {
        this.centerOfMass = new float[3];
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float f) {
        this.mass = f;
    }

    public void getBboxCenter(float[] fArray) {
        fArray[0] = this.bboxCenter[0];
        fArray[1] = this.bboxCenter[1];
        fArray[2] = this.bboxCenter[2];
    }

    public void setBboxCenter(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(MIN_ARRAY_SIZE_PROP) + "bboxCenter";
            throw new IllegalArgumentException(string);
        }
        this.bboxCenter[0] = fArray[0];
        this.bboxCenter[1] = fArray[1];
        this.bboxCenter[2] = fArray[2];
    }

    public void getBboxSize(float[] fArray) {
        fArray[0] = this.bboxSize[0];
        fArray[1] = this.bboxSize[1];
        fArray[2] = this.bboxSize[2];
    }

    public void setBboxSize(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(MIN_ARRAY_SIZE_PROP) + "bboxSize";
            throw new IllegalArgumentException(string);
        }
        this.bboxSize[0] = fArray[0];
        this.bboxSize[1] = fArray[1];
        this.bboxSize[2] = fArray[2];
    }

    public void getCenterOfMass(float[] fArray) {
        fArray[0] = this.centerOfMass[0];
        fArray[1] = this.centerOfMass[1];
        fArray[2] = this.centerOfMass[2];
    }

    public void setCenterOfMass(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(MIN_ARRAY_SIZE_PROP) + "displacements";
            throw new IllegalArgumentException(string);
        }
        this.centerOfMass[0] = fArray[0];
        this.centerOfMass[1] = fArray[1];
        this.centerOfMass[2] = fArray[2];
    }

    public int numMomentsOfInertia() {
        return this.numMoments;
    }

    public void getMomentsOfInertia(float[] fArray) {
        System.arraycopy(this.momentsOfInertia, 0, fArray, 0, this.numMoments);
    }

    public void setMomentsOfInertia(float[] fArray, int n) {
        if (fArray == null) {
            this.numMoments = 0;
        } else {
            if (this.momentsOfInertia.length < n) {
                this.momentsOfInertia = new float[n];
            }
            System.arraycopy(fArray, 0, this.momentsOfInertia, 0, n);
            this.numMoments = n;
        }
    }

    public int numCoord() {
        return this.numCoords / 3;
    }

    public void getCoord(float[] fArray) {
        System.arraycopy(this.coords, 0, fArray, 0, this.numCoords);
    }

    public void setCoord(float[] fArray, int n) {
        if (fArray == null || fArray.length < n * 3) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(MIN_ARRAY_SIZE_PROP) + "coord";
            throw new IllegalArgumentException(string);
        }
        if (this.coords == null || this.coords.length < n * 3) {
            this.coords = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.coords, 0, n * 3);
        this.numCoords = n * 3;
    }

    public int numChildren() {
        return this.numChildren;
    }

    public void getChildren(Object[] objectArray) {
        System.arraycopy(this.children, 0, objectArray, 0, this.numChildren);
    }

    public void setChildren(Object[] objectArray, int n) {
        if (this.children == null || this.children.length < n) {
            this.children = new Object[n];
        }
        if (n != 0) {
            System.arraycopy(objectArray, 0, this.children, 0, n);
        }
        for (int i = n; i < this.numChildren; ++i) {
            this.children[i] = null;
        }
        this.numChildren = n;
    }

    public void addChild(Object object) {
        if (this.children == null || this.children.length == this.numChildren) {
            this.children = new Object[this.numChildren + 4];
        }
        this.children[this.numChildren++] = object;
    }

    public void removeChild(Object object) {
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] != object) continue;
            System.arraycopy(this.children, i + 1, this.children, i, this.numChildren - i - 1);
            break;
        }
    }

    public void setDisplacers(HAnimDisplacer[] hAnimDisplacerArray, int n) {
        if (this.displacers == null || this.displacers.length < n) {
            this.displacers = new HAnimDisplacer[n];
        }
        if (n != 0) {
            System.arraycopy(hAnimDisplacerArray, 0, this.displacers, 0, n);
        }
        for (int i = n; i < this.numDisplacers; ++i) {
            this.displacers[i] = null;
        }
        this.numDisplacers = n;
    }
}

