/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.j3d.geom.triangulation.Triangulator;

class Clean {
    Clean() {
    }

    static void initPUnsorted(Triangulator triangulator, int n) {
        if (n > triangulator.maxNumPUnsorted) {
            triangulator.maxNumPUnsorted = n;
            triangulator.pUnsorted = new Point2f[triangulator.maxNumPUnsorted];
            for (int i = 0; i < triangulator.maxNumPUnsorted; ++i) {
                triangulator.pUnsorted[i] = new Point2f();
            }
        }
    }

    static int cleanPolyhedralFace(Triangulator triangulator, int n, int n2) {
        int n3;
        int n4;
        Clean.initPUnsorted(triangulator, triangulator.numPoints);
        for (n4 = 0; n4 < triangulator.numPoints; ++n4) {
            triangulator.pUnsorted[n4].set((Tuple2f)triangulator.points[n4]);
        }
        Clean.sort(triangulator.points, triangulator.numPoints);
        n4 = 0;
        for (n3 = 1; n3 < triangulator.numPoints; ++n3) {
            if (Clean.pComp(triangulator.points[n4], triangulator.points[n3]) == 0) continue;
            triangulator.points[++n4] = triangulator.points[n3];
        }
        int n5 = n4 + 1;
        int n6 = triangulator.numPoints - n5;
        for (n4 = n; n4 < n2; ++n4) {
            int n7 = triangulator.loops[n4];
            int n8 = triangulator.fetchNextData(n7);
            int n9 = triangulator.fetchData(n8);
            while (n8 != n7) {
                n3 = Clean.findPInd(triangulator.points, n5, triangulator.pUnsorted[n9]);
                triangulator.updateIndex(n8, n3);
                n8 = triangulator.fetchNextData(n8);
                n9 = triangulator.fetchData(n8);
            }
            n3 = Clean.findPInd(triangulator.points, n5, triangulator.pUnsorted[n9]);
            triangulator.updateIndex(n8, n3);
        }
        triangulator.numPoints = n5;
        return n6;
    }

    static void sort(Point2f[] point2fArray, int n) {
        Point2f point2f = new Point2f();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (Clean.pComp(point2fArray[i], point2fArray[j]) <= 0) continue;
                point2f.set((Tuple2f)point2fArray[i]);
                point2fArray[i].set((Tuple2f)point2fArray[j]);
                point2fArray[j].set((Tuple2f)point2f);
            }
        }
    }

    static int findPInd(Point2f[] point2fArray, int n, Point2f point2f) {
        for (int i = 0; i < n; ++i) {
            if (point2f.x != point2fArray[i].x || point2f.y != point2fArray[i].y) continue;
            return i;
        }
        return -1;
    }

    static int pComp(Point2f point2f, Point2f point2f2) {
        if (point2f.x < point2f2.x) {
            return -1;
        }
        if (point2f.x > point2f2.x) {
            return 1;
        }
        if (point2f.y < point2f2.y) {
            return -1;
        }
        if (point2f.y > point2f2.y) {
            return 1;
        }
        return 0;
    }
}

