/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import org.j3d.geom.triangulation.HeapNode;
import org.j3d.geom.triangulation.Triangulator;

class Heap {
    Heap() {
    }

    static void printHeapData(Triangulator triangulator) {
    }

    static void initHeap(Triangulator triangulator) {
        triangulator.maxNumHeap = triangulator.numPoints;
        triangulator.heap = new HeapNode[triangulator.maxNumHeap];
        triangulator.numHeap = 0;
        triangulator.numZero = 0;
    }

    static void storeHeapData(Triangulator triangulator, int n, double d, int n2, int n3, int n4) {
        triangulator.heap[n] = new HeapNode();
        triangulator.heap[n].ratio = d;
        triangulator.heap[n].index = n2;
        triangulator.heap[n].prev = n3;
        triangulator.heap[n].next = n4;
    }

    static void dumpOnHeap(Triangulator triangulator, double d, int n, int n2, int n3) {
        int n4;
        if (triangulator.numHeap >= triangulator.maxNumHeap) {
            HeapNode[] heapNodeArray = triangulator.heap;
            triangulator.maxNumHeap += triangulator.numPoints;
            triangulator.heap = new HeapNode[triangulator.maxNumHeap];
            System.arraycopy(heapNodeArray, 0, triangulator.heap, 0, heapNodeArray.length);
        }
        if (d == 0.0) {
            if (triangulator.numZero < triangulator.numHeap) {
                if (triangulator.heap[triangulator.numHeap] == null) {
                    Heap.storeHeapData(triangulator, triangulator.numHeap, triangulator.heap[triangulator.numZero].ratio, triangulator.heap[triangulator.numZero].index, triangulator.heap[triangulator.numZero].prev, triangulator.heap[triangulator.numZero].next);
                } else {
                    triangulator.heap[triangulator.numHeap].copy(triangulator.heap[triangulator.numZero]);
                }
            }
            n4 = triangulator.numZero++;
        } else {
            n4 = triangulator.numHeap;
        }
        Heap.storeHeapData(triangulator, n4, d, n, n2, n3);
        ++triangulator.numHeap;
    }

    static void insertIntoHeap(Triangulator triangulator, double d, int n, int n2, int n3) {
        Heap.dumpOnHeap(triangulator, d, n, n2, n3);
    }

    static boolean deleteFromHeap(Triangulator triangulator, int[] nArray, int[] nArray2, int[] nArray3) {
        if (triangulator.numZero > 0) {
            --triangulator.numZero;
            --triangulator.numHeap;
            nArray[0] = triangulator.heap[triangulator.numZero].index;
            nArray2[0] = triangulator.heap[triangulator.numZero].prev;
            nArray3[0] = triangulator.heap[triangulator.numZero].next;
            if (triangulator.numZero < triangulator.numHeap) {
                triangulator.heap[triangulator.numZero].copy(triangulator.heap[triangulator.numHeap]);
            }
            return true;
        }
        if (triangulator.earsRandom) {
            if (triangulator.numHeap <= 0) {
                triangulator.numHeap = 0;
                return false;
            }
            double d = triangulator.randomGen.nextDouble();
            int n = (int)(d * (double)triangulator.numHeap);
            --triangulator.numHeap;
            if (n > triangulator.numHeap) {
                n = triangulator.numHeap;
            }
            nArray[0] = triangulator.heap[n].index;
            nArray2[0] = triangulator.heap[n].prev;
            nArray3[0] = triangulator.heap[n].next;
            if (n < triangulator.numHeap) {
                triangulator.heap[n].copy(triangulator.heap[triangulator.numHeap]);
            }
            return true;
        }
        if (triangulator.numHeap <= 0) {
            triangulator.numHeap = 0;
            return false;
        }
        --triangulator.numHeap;
        nArray[0] = triangulator.heap[triangulator.numHeap].index;
        nArray2[0] = triangulator.heap[triangulator.numHeap].prev;
        nArray3[0] = triangulator.heap[triangulator.numHeap].next;
        return true;
    }
}

