/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.triangulation;

import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.j3d.geom.triangulation.Basic;
import org.j3d.geom.triangulation.Triangulator;

class Numerics {
    Numerics() {
    }

    static double max3(double d, double d2, double d3) {
        return d > d2 ? (d > d3 ? d : d3) : (d2 > d3 ? d2 : d3);
    }

    static double min3(double d, double d2, double d3) {
        return d < d2 ? (d < d3 ? d : d3) : (d2 < d3 ? d2 : d3);
    }

    static boolean lt(double d, double d2) {
        return d < -d2;
    }

    static boolean le(double d, double d2) {
        return d <= d2;
    }

    static boolean ge(double d, double d2) {
        return !(d <= -d2);
    }

    static boolean eq(double d, double d2) {
        return d <= d2 && !(d < -d2);
    }

    static boolean gt(double d, double d2) {
        return !(d <= d2);
    }

    static double baseLength(Tuple2f tuple2f, Tuple2f tuple2f2) {
        double d = tuple2f2.x - tuple2f.x;
        double d2 = tuple2f2.y - tuple2f.y;
        return Math.abs(d) + Math.abs(d2);
    }

    static double sideLength(Tuple2f tuple2f, Tuple2f tuple2f2) {
        double d = tuple2f2.x - tuple2f.x;
        double d2 = tuple2f2.y - tuple2f.y;
        return d * d + d2 * d2;
    }

    static boolean inBetween(int n, int n2, int n3) {
        return n <= n3 && n3 <= n2;
    }

    static boolean strictlyInBetween(int n, int n2, int n3) {
        return n < n3 && n3 < n2;
    }

    static double stableDet2D(Triangulator triangulator, int n, int n2, int n3) {
        double d;
        if (n == n2 || n == n3 || n2 == n3) {
            d = 0.0;
        } else {
            Point2f point2f = triangulator.points[n];
            Point2f point2f2 = triangulator.points[n2];
            Point2f point2f3 = triangulator.points[n3];
            d = n < n2 ? (n2 < n3 ? Basic.det2D((Tuple2f)point2f, (Tuple2f)point2f2, (Tuple2f)point2f3) : (n < n3 ? -Basic.det2D((Tuple2f)point2f, (Tuple2f)point2f3, (Tuple2f)point2f2) : Basic.det2D((Tuple2f)point2f3, (Tuple2f)point2f, (Tuple2f)point2f2))) : (n < n3 ? -Basic.det2D((Tuple2f)point2f2, (Tuple2f)point2f, (Tuple2f)point2f3) : (n2 < n3 ? Basic.det2D((Tuple2f)point2f2, (Tuple2f)point2f3, (Tuple2f)point2f) : -Basic.det2D((Tuple2f)point2f3, (Tuple2f)point2f2, (Tuple2f)point2f)));
        }
        return d;
    }

    static int orientation(Triangulator triangulator, int n, int n2, int n3) {
        double d = Numerics.stableDet2D(triangulator, n, n2, n3);
        int n4 = Numerics.lt(d, triangulator.epsilon) ? -1 : (Numerics.gt(d, triangulator.epsilon) ? 1 : 0);
        return n4;
    }

    static boolean isInCone(Triangulator triangulator, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = true;
        if (bl) {
            if (n != n2) {
                int n5 = Numerics.orientation(triangulator, n, n2, n4);
                if (n5 < 0) {
                    bl2 = false;
                } else if (n5 == 0) {
                    if (n < n2) {
                        if (!Numerics.inBetween(n, n2, n4)) {
                            bl2 = false;
                        }
                    } else if (!Numerics.inBetween(n2, n, n4)) {
                        bl2 = false;
                    }
                }
            }
            if (n2 != n3 && bl2) {
                int n6 = Numerics.orientation(triangulator, n2, n3, n4);
                if (n6 < 0) {
                    bl2 = false;
                } else if (n6 == 0) {
                    if (n2 < n3) {
                        if (!Numerics.inBetween(n2, n3, n4)) {
                            bl2 = false;
                        }
                    } else if (!Numerics.inBetween(n3, n2, n4)) {
                        bl2 = false;
                    }
                }
            }
        } else {
            int n7;
            int n8 = Numerics.orientation(triangulator, n, n2, n4);
            if (n8 <= 0 && (n7 = Numerics.orientation(triangulator, n2, n3, n4)) < 0) {
                bl2 = false;
            }
        }
        return bl2;
    }

    static int isConvexAngle(Triangulator triangulator, int n, int n2, int n3, int n4) {
        int n5;
        if (n == n2) {
            if (n2 == n3) {
                return 1;
            }
            return 1;
        }
        if (n2 == n3) {
            return -1;
        }
        int n6 = Numerics.orientation(triangulator, n, n2, n3);
        if (n6 > 0) {
            n5 = 1;
        } else if (n6 < 0) {
            n5 = -1;
        } else {
            Point2f point2f = new Point2f();
            Point2f point2f2 = new Point2f();
            Basic.vectorSub2D((Tuple2f)triangulator.points[n], (Tuple2f)triangulator.points[n2], (Tuple2f)point2f);
            Basic.vectorSub2D((Tuple2f)triangulator.points[n3], (Tuple2f)triangulator.points[n2], (Tuple2f)point2f2);
            double d = Basic.dotProduct2D((Tuple2f)point2f, (Tuple2f)point2f2);
            n5 = d < 0.0 ? 0 : Numerics.spikeAngle(triangulator, n, n2, n3, n4);
        }
        return n5;
    }

    static boolean pntInTriangle(Triangulator triangulator, int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = Numerics.orientation(triangulator, n2, n3, n4);
        if (n5 >= 0 && (n5 = Numerics.orientation(triangulator, n, n2, n4)) >= 0 && (n5 = Numerics.orientation(triangulator, n3, n, n4)) >= 0) {
            bl = true;
        }
        return bl;
    }

    static boolean vtxInTriangle(Triangulator triangulator, int n, int n2, int n3, int n4, int[] nArray) {
        boolean bl = false;
        int n5 = Numerics.orientation(triangulator, n2, n3, n4);
        if (n5 >= 0) {
            n5 = Numerics.orientation(triangulator, n, n2, n4);
            if (n5 > 0) {
                n5 = Numerics.orientation(triangulator, n3, n, n4);
                if (n5 > 0) {
                    bl = true;
                    nArray[0] = 0;
                } else if (n5 == 0) {
                    bl = true;
                    nArray[0] = 1;
                }
            } else if (n5 == 0) {
                n5 = Numerics.orientation(triangulator, n3, n, n4);
                if (n5 > 0) {
                    bl = true;
                    nArray[0] = 2;
                } else if (n5 == 0) {
                    bl = true;
                    nArray[0] = 3;
                }
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean segIntersect(Triangulator triangulator, int n, int n2, int n3, int n4, int n5) {
        if (n == n2 || n3 == n4) {
            return false;
        }
        if (n == n3 && n2 == n4) {
            return true;
        }
        if (n3 == n5 || n4 == n5) {
            ++triangulator.identCntr;
        }
        int n6 = Numerics.orientation(triangulator, n, n2, n3);
        int n7 = Numerics.orientation(triangulator, n, n2, n4);
        if (n6 == 1 && n7 == 1 || n6 == -1 && n7 == -1) {
            return false;
        }
        if (n6 == 0) {
            if (Numerics.strictlyInBetween(n, n2, n3)) {
                return true;
            }
            if (n7 != 0) return false;
            if (Numerics.strictlyInBetween(n, n2, n4)) {
                return true;
            }
        } else if (n7 == 0) {
            return Numerics.strictlyInBetween(n, n2, n4);
        }
        int n8 = Numerics.orientation(triangulator, n3, n4, n);
        int n9 = Numerics.orientation(triangulator, n3, n4, n2);
        return (n8 > 0 || n9 > 0) && (n8 < 0 || n9 < 0);
    }

    static double getRatio(Triangulator triangulator, int n, int n2, int n3) {
        Point2f point2f = triangulator.points[n];
        Point2f point2f2 = triangulator.points[n2];
        Point2f point2f3 = triangulator.points[n3];
        double d = Numerics.baseLength((Tuple2f)point2f, (Tuple2f)point2f2);
        double d2 = Numerics.baseLength((Tuple2f)point2f, (Tuple2f)point2f3);
        double d3 = Numerics.baseLength((Tuple2f)point2f3, (Tuple2f)point2f2);
        double d4 = Numerics.max3(d, d2, d3);
        if (10.0 * d < Math.min(d2, d3)) {
            return 0.1;
        }
        double d5 = Numerics.stableDet2D(triangulator, n, n2, n3);
        if (Numerics.lt(d5, triangulator.epsilon)) {
            d5 = -d5;
        } else if (!Numerics.gt(d5, triangulator.epsilon)) {
            if (d4 > d) {
                return 0.1;
            }
            return Double.MAX_VALUE;
        }
        double d6 = d4 * d4 / d5;
        if (d6 < 10.0) {
            return d6;
        }
        if (d < d4) {
            return 0.1;
        }
        return d6;
    }

    static int spikeAngle(Triangulator triangulator, int n, int n2, int n3, int n4) {
        int n5 = n4;
        int n6 = triangulator.fetchData(n5);
        int n7 = triangulator.fetchPrevData(n5);
        int n8 = triangulator.fetchData(n7);
        int n9 = triangulator.fetchNextData(n5);
        int n10 = triangulator.fetchData(n9);
        return Numerics.recSpikeAngle(triangulator, n, n2, n3, n7, n9);
    }

    static int recSpikeAngle(Triangulator triangulator, int n, int n2, int n3, int n4, int n5) {
        if (n4 == n5) {
            return -2;
        }
        if (n != n3) {
            int n6;
            int n7;
            if (n < n2) {
                n7 = n;
                n6 = n2;
            } else {
                n7 = n2;
                n6 = n;
            }
            if (Numerics.inBetween(n7, n6, n3)) {
                n2 = n3;
                n5 = triangulator.fetchNextData(n5);
                n3 = triangulator.fetchData(n5);
                if (n4 == n5) {
                    return 2;
                }
                int n8 = Numerics.orientation(triangulator, n, n2, n3);
                if (n8 > 0) {
                    return 2;
                }
                if (n8 < 0) {
                    return -2;
                }
                return Numerics.recSpikeAngle(triangulator, n, n2, n3, n4, n5);
            }
            n2 = n;
            n4 = triangulator.fetchPrevData(n4);
            n = triangulator.fetchData(n4);
            if (n4 == n5) {
                return 2;
            }
            int n9 = Numerics.orientation(triangulator, n, n2, n3);
            if (n9 > 0) {
                return 2;
            }
            if (n9 < 0) {
                return -2;
            }
            return Numerics.recSpikeAngle(triangulator, n, n2, n3, n4, n5);
        }
        int n10 = n2;
        n2 = n;
        n4 = triangulator.fetchPrevData(n4);
        n = triangulator.fetchData(n4);
        if (n4 == n5) {
            return 2;
        }
        n5 = triangulator.fetchNextData(n5);
        n3 = triangulator.fetchData(n5);
        if (n4 == n5) {
            return 2;
        }
        int n11 = Numerics.orientation(triangulator, n, n2, n3);
        if (n11 > 0) {
            int n12;
            int n13 = Numerics.orientation(triangulator, n, n2, n10);
            if (n13 > 0 && (n12 = Numerics.orientation(triangulator, n2, n3, n10)) > 0) {
                return -2;
            }
            return 2;
        }
        if (n11 < 0) {
            int n14;
            int n15 = Numerics.orientation(triangulator, n2, n, n10);
            if (n15 > 0 && (n14 = Numerics.orientation(triangulator, n3, n2, n10)) > 0) {
                return 2;
            }
            return -2;
        }
        Point2f point2f = new Point2f();
        Basic.vectorSub2D((Tuple2f)triangulator.points[n], (Tuple2f)triangulator.points[n2], (Tuple2f)point2f);
        Point2f point2f2 = new Point2f();
        Basic.vectorSub2D((Tuple2f)triangulator.points[n3], (Tuple2f)triangulator.points[n2], (Tuple2f)point2f2);
        double d = Basic.dotProduct2D((Tuple2f)point2f, (Tuple2f)point2f2);
        if (d < 0.0) {
            n11 = Numerics.orientation(triangulator, n2, n, n10);
            if (n11 > 0) {
                return 2;
            }
            return -2;
        }
        return Numerics.recSpikeAngle(triangulator, n, n2, n3, n4, n5);
    }

    static double angle(Triangulator triangulator, Point2f point2f, Point2f point2f2, Point2f point2f3) {
        double d;
        int n = Basic.signEps(Basic.det2D((Tuple2f)point2f3, (Tuple2f)point2f, (Tuple2f)point2f2), triangulator.epsilon);
        if (n == 0) {
            return 0.0;
        }
        Point2f point2f4 = new Point2f();
        Point2f point2f5 = new Point2f();
        Basic.vectorSub2D((Tuple2f)point2f2, (Tuple2f)point2f, (Tuple2f)point2f4);
        Basic.vectorSub2D((Tuple2f)point2f3, (Tuple2f)point2f, (Tuple2f)point2f5);
        double d2 = Math.atan2(point2f4.y, point2f4.x);
        double d3 = Math.atan2(point2f5.y, point2f5.x);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d = d2 - d3) > Math.PI) {
            d = Math.PI * 2 - d;
        } else if (d < -Math.PI) {
            d = Math.PI * 2 + d;
        }
        if (n == 1) {
            if (d < 0.0) {
                return -d;
            }
            return d;
        }
        if (d > 0.0) {
            return -d;
        }
        return d;
    }
}

