/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d;

public class Ac3dSurface {
    private int numrefs = 0;
    private int flags = 0;
    private int material = -1;
    private int[] vertices;
    private float[] textureCoordinates;
    public static final int FLAG_POLYGON = 0;
    public static final int FLAG_CLOSEDLINE = 1;
    public static final int FLAG_LINE = 2;
    public static final int FLAG_SHADED = 16;
    public static final int FLAG_TWOSIDED = 32;

    public void setNumrefs(int n) {
        this.numrefs = n;
        this.vertices = new int[n];
        this.textureCoordinates = new float[n * 2];
    }

    public int getNumrefs() {
        return this.numrefs;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setMaterial(int n) {
        this.material = n;
    }

    public int getMaterial() {
        return this.material;
    }

    public void addRef(int n, int n2, float[] fArray) {
        this.vertices[n] = n2;
        this.textureCoordinates[2 * n] = fArray[0];
        this.textureCoordinates[2 * n + 1] = fArray[1];
    }

    public int[] getVerticesIndex() {
        return this.vertices;
    }

    public float[] getTextureCoordinates() {
        return this.textureCoordinates;
    }

    public boolean checkFlag(int n) {
        return this.checkFlag(n, this.flags);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ flags=");
        stringBuffer.append(this.flags);
        stringBuffer.append(" { ");
        this.stringifyFlags(this.flags, stringBuffer);
        stringBuffer.append(" }, mat=");
        stringBuffer.append(this.material);
        stringBuffer.append(", numrefs=");
        stringBuffer.append(this.numrefs);
        stringBuffer.append(", refs= { ");
        for (int i = 0; i < this.vertices.length; ++i) {
            stringBuffer.append(this.vertices[i]);
            stringBuffer.append("@(");
            stringBuffer.append(this.textureCoordinates[2 * i]);
            stringBuffer.append(", ");
            stringBuffer.append(this.textureCoordinates[2 * i + 1]);
            stringBuffer.append(") ");
        }
        stringBuffer.append(" } ]");
        return stringBuffer.toString();
    }

    private void stringifyFlags(int n, StringBuffer stringBuffer) {
        if (this.checkFlag(0, n)) {
            stringBuffer.append("FLAG_POLYGON");
        }
        if (this.checkFlag(1, n)) {
            stringBuffer.append("FLAG_CLOSEDLINE");
        }
        if (this.checkFlag(2, n)) {
            stringBuffer.append("FLAG_LINE");
        }
        if (this.checkFlag(16, n)) {
            stringBuffer.append(" | FLAG_SHADED");
        }
        if (this.checkFlag(32, n)) {
            stringBuffer.append(" | FLAG_TWOSIDED");
        }
    }

    private boolean checkFlag(int n, int n2) {
        return (n2 & n) == n;
    }
}

