/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.c3d;

public class C3DHeader {
    public int numTrajectories;
    public int numTrajectorySamples;
    public float trajectorySampleRate;
    public int numAnalogChannels;
    public int numAnalogSamplesPer3DFrame;
    public float analogSampleRate;
    public int maxInterpolationGap;
    public float scaleFactor;
    public boolean hasRangeData;
    public int numTimeEvents;
    public float[] eventTimes;
    public boolean[] eventDisplayFlag;
    public String[] eventLabels;
    int start3DFrame;
    int end3DFrame;
    int startDataBlock;
    int rangeDataStart;
    int processorType;
    int startParamBlock;

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("C3DHeader: ");
        stringBuffer.append(" encoding ");
        switch (this.processorType) {
            case 1: {
                stringBuffer.append("Intel");
                break;
            }
            case 2: {
                stringBuffer.append("DEC/VAX");
                break;
            }
            case 3: {
                stringBuffer.append("SGI/MIPS");
            }
        }
        stringBuffer.append("\n Trajectories: ");
        stringBuffer.append(this.numTrajectories);
        stringBuffer.append(" samples: ");
        stringBuffer.append(this.numTrajectorySamples);
        stringBuffer.append(" rate ");
        stringBuffer.append(this.trajectorySampleRate);
        stringBuffer.append("\n Analog Channels: ");
        stringBuffer.append(this.numAnalogChannels);
        stringBuffer.append(" samples per frame: ");
        stringBuffer.append(this.numAnalogSamplesPer3DFrame);
        stringBuffer.append(" rate: ");
        stringBuffer.append(this.analogSampleRate);
        stringBuffer.append("\n Interpolation Gap: ");
        stringBuffer.append(this.maxInterpolationGap);
        stringBuffer.append(" scale factor: ");
        stringBuffer.append(this.scaleFactor);
        stringBuffer.append("\n Range data available?: ");
        stringBuffer.append(this.hasRangeData ? "Yes" : "No");
        stringBuffer.append("\n Time Events");
        for (int i = 0; i < this.numTimeEvents; ++i) {
            stringBuffer.append("\n  '");
            stringBuffer.append(this.eventLabels[i]);
            stringBuffer.append("' at time ");
            stringBuffer.append(this.eventTimes[i]);
            stringBuffer.append(" display? ");
            stringBuffer.append(this.eventDisplayFlag[i] ? "Yes" : "No");
        }
        if (bl) {
            stringBuffer.append("\n Param block starts at ");
            stringBuffer.append(this.startParamBlock);
            stringBuffer.append("\n 3D frame range: ");
            stringBuffer.append(this.start3DFrame);
            stringBuffer.append(" to ");
            stringBuffer.append(this.end3DFrame);
            stringBuffer.append("\n Data block starts at: ");
            stringBuffer.append(this.startDataBlock);
            stringBuffer.append("\n Range data starts at: ");
            stringBuffer.append(this.rangeDataStart);
        }
        return stringBuffer.toString();
    }
}

