/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.c3d;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.j3d.io.BlockDataInputStream;
import org.j3d.loaders.c3d.BufferReader;
import org.j3d.loaders.c3d.C3DAnalogData;
import org.j3d.loaders.c3d.C3DByteParameter;
import org.j3d.loaders.c3d.C3DFloatParameter;
import org.j3d.loaders.c3d.C3DHeader;
import org.j3d.loaders.c3d.C3DIntParameter;
import org.j3d.loaders.c3d.C3DParameter;
import org.j3d.loaders.c3d.C3DParameterGroup;
import org.j3d.loaders.c3d.C3DParseObserver;
import org.j3d.loaders.c3d.C3DStringParameter;
import org.j3d.loaders.c3d.C3DTrajectoryData;
import org.j3d.loaders.c3d.DECBufferReader;
import org.j3d.loaders.c3d.IntelBufferReader;
import org.j3d.loaders.c3d.MIPSBufferReader;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.IntHashMap;

public class C3DParser {
    private static final String INVALID_FILE_FORMAT = "The stream does not represent a C3D file. The binary ID is incorrect";
    private static final String USER_HEADER_ERR = "User code implementing C3DParseObserver has generated an exception during the headerComplete() callback.";
    private static final String USER_PARAM_ERR = "User code implementing C3DParseObserver has generated an exception during the parametersComplete() callback.";
    private static final String PARAM_BLOCK_SIZE_MSG = "The file incorrectly states the size of the parameter block for the number of parameters we've attempted to read. Some parameters will be invalid or truncated";
    private static final String LABEL_PARAM_MISSING_ERR = "The label parameter values are missing from the file";
    private static final String DESC_PARAM_MISSING_ERR = "The description parameter values are missing from the file";
    private byte[] buffer = new byte[512];
    private InputStream inputStream;
    private int currentBlock = 0;
    private BufferReader reader;
    private C3DHeader header;
    private C3DParameterGroup[] parameters;
    private C3DTrajectoryData[] trajectories;
    private C3DAnalogData[] analogSamples;
    private String[] markerLabels;
    private String[] markerDescriptions;
    private String[] analogLabels;
    private String[] analogDescriptions;
    private C3DParseObserver observer;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    public C3DParser() {
    }

    public C3DParser(InputStream inputStream) {
        this();
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.inputStream = new BlockDataInputStream(bufferedInputStream);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void setParseObserver(C3DParseObserver c3DParseObserver) {
        this.observer = c3DParseObserver;
    }

    public C3DHeader getHeader() {
        return this.header;
    }

    public C3DParameterGroup[] getParameters() {
        return this.parameters;
    }

    public C3DTrajectoryData[] getTrajectories() {
        return this.trajectories;
    }

    public C3DAnalogData[] getAnalogSamples() {
        return this.analogSamples;
    }

    public void clear() {
        this.header = null;
        this.parameters = null;
        this.trajectories = null;
        this.currentBlock = 0;
        this.inputStream = null;
    }

    public void reset(InputStream inputStream) {
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.inputStream = new BlockDataInputStream(bufferedInputStream);
        this.header = null;
        this.currentBlock = 0;
    }

    public void parse(boolean bl) throws IOException {
        if (this.parseHeader() && this.parseParams(bl)) {
            this.parseTrajectories(bl);
        }
        if (!bl) {
            this.header = null;
        }
    }

    private boolean parseHeader() throws IOException {
        int n;
        int n2;
        this.readBlocks(1);
        if (this.buffer[1] != 80) {
            throw new IOException(INVALID_FILE_FORMAT);
        }
        int n3 = this.buffer[0] & 0xFF;
        byte[] byArray = this.buffer;
        this.buffer = new byte[512];
        for (n2 = 1; n2 < n3; ++n2) {
            this.readBlocks(1);
        }
        n2 = this.buffer[3] - 83;
        switch (n2) {
            case 1: {
                this.reader = new IntelBufferReader();
                break;
            }
            case 2: {
                this.reader = new DECBufferReader();
                break;
            }
            case 3: {
                this.reader = new MIPSBufferReader();
            }
        }
        byte[] byArray2 = byArray;
        byArray = this.buffer;
        this.buffer = byArray2;
        this.reader.setBuffer(this.buffer);
        this.header = new C3DHeader();
        this.header.processorType = n2;
        this.header.startParamBlock = n3;
        this.header.numTrajectories = this.reader.readShort(2);
        this.header.numAnalogChannels = this.reader.readShort(4);
        this.header.start3DFrame = this.reader.readShort(6) - 1;
        this.header.end3DFrame = this.reader.readShort(8) - 1;
        this.header.numTrajectorySamples = this.header.end3DFrame - this.header.start3DFrame + 1;
        this.header.maxInterpolationGap = this.reader.readShort(10);
        this.header.scaleFactor = this.reader.readFloat(12);
        this.header.startDataBlock = this.reader.readShort(16);
        this.header.numAnalogSamplesPer3DFrame = this.reader.readShort(18);
        this.header.trajectorySampleRate = this.reader.readFloat(20);
        this.header.hasRangeData = this.reader.readShort(294) == 12345;
        this.header.rangeDataStart = this.reader.readShort(296);
        boolean bl = this.reader.readShort(298) != 12345;
        this.header.numTimeEvents = this.reader.readShort(300);
        if (this.header.numTimeEvents > 18) {
            this.header.numTimeEvents = 18;
        }
        this.header.eventTimes = new float[this.header.numTimeEvents];
        this.header.eventLabels = new String[this.header.numTimeEvents];
        this.header.eventDisplayFlag = new boolean[this.header.numTimeEvents];
        for (n = 0; n < this.header.numTimeEvents; ++n) {
            this.header.eventTimes[n] = this.reader.readFloat(304 + (n << 2));
        }
        for (n = 0; n < this.header.numTimeEvents; ++n) {
            this.header.eventDisplayFlag[n] = this.buffer[376 + n] == 0;
        }
        for (n = 0; n < this.header.numTimeEvents; ++n) {
            this.header.eventLabels[n] = this.reader.readString(396 + (n << 2), 4);
        }
        this.buffer = byArray;
        this.reader.setBuffer(this.buffer);
        this.header.numAnalogChannels /= this.header.numAnalogSamplesPer3DFrame;
        this.header.analogSampleRate = this.header.trajectorySampleRate * (float)this.header.numAnalogSamplesPer3DFrame;
        n = 1;
        if (this.observer != null) {
            try {
                n = this.observer.headerComplete(this.header);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(USER_HEADER_ERR, exception);
            }
        }
        return n != 0;
    }

    private boolean parseParams(boolean bl) throws IOException {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        IntHashMap intHashMap = new IntHashMap();
        int n5 = this.buffer[2] & 0xFF;
        int n6 = 0;
        int n7 = 0;
        byte[] byArray = this.buffer;
        this.buffer = new byte[512 * (n5 + 1)];
        this.readBlocks(n5);
        System.arraycopy(this.buffer, 0, this.buffer, 512, 512 * n5);
        System.arraycopy(byArray, 0, this.buffer, 0, 512);
        this.reader.setBuffer(this.buffer);
        boolean bl2 = true;
        int n8 = 4;
        while (bl2) {
            Object object2;
            Object object3;
            n4 = this.buffer[n8];
            boolean bl3 = false;
            n3 = this.buffer[n8 + 1];
            if (n4 < 0) {
                bl3 = true;
                n4 = -n4;
            }
            object = this.reader.readString(n8 + 2, n4);
            object = ((String)object).toUpperCase();
            n2 = this.reader.readShort(n8 + 2 + n4);
            if (n2 == 0) {
                bl2 = false;
            }
            if (n3 < 0) {
                n = this.buffer[n8 + 4 + n4];
                String string = this.reader.readString(n8 + 5 + n4, n);
                object3 = (C3DParameterGroup)intHashMap.get(n3);
                if (object3 != null) {
                    ((C3DParameterGroup)object3).setName((String)object);
                    ((C3DParameterGroup)object3).setDescription(string);
                    ((C3DParameterGroup)object3).setLocked(bl3);
                } else {
                    object3 = new C3DParameterGroup((String)object, bl3, n3, string);
                    intHashMap.put(n3, object3);
                }
                if (((String)object).equals("ANALOG")) {
                    n6 = n3;
                } else if (((String)object).equals("POINT")) {
                    n7 = n3;
                }
                n8 += 5 + n4 + n;
                continue;
            }
            n = this.buffer[n8 + 4 + n4];
            int n9 = this.buffer[n8 + 5 + n4];
            object3 = new int[n9];
            for (int i = 0; i < n9; ++i) {
                object3[i] = this.buffer[n8 + 6 + n4 + i] & 0xFF;
            }
            n8 += 6 + n4 + n9;
            C3DParameterGroup c3DParameterGroup = (C3DParameterGroup)intHashMap.get(-n3);
            if (c3DParameterGroup == null) {
                c3DParameterGroup = new C3DParameterGroup(null, false, -n3, null);
                intHashMap.put(-n3, c3DParameterGroup);
            }
            try {
                switch (n) {
                    case -1: {
                        C3DStringParameter c3DStringParameter = new C3DStringParameter((String)object, false, n3);
                        n8 = this.readStringParams(c3DStringParameter, (int[])object3, n8);
                        c3DStringParameter.setLocked(bl3);
                        c3DParameterGroup.addParameterUnlocked(c3DStringParameter);
                        break;
                    }
                    case 1: {
                        object2 = new C3DByteParameter((String)object, false, n3);
                        n8 = this.readByteParams((C3DByteParameter)object2, (int[])object3, n8);
                        ((C3DParameter)object2).setLocked(bl3);
                        c3DParameterGroup.addParameterUnlocked((C3DParameter)object2);
                        break;
                    }
                    case 2: {
                        C3DIntParameter c3DIntParameter = new C3DIntParameter((String)object, false, n3);
                        n8 = this.readIntParams(c3DIntParameter, (int[])object3, n8);
                        c3DIntParameter.setLocked(bl3);
                        c3DParameterGroup.addParameterUnlocked(c3DIntParameter);
                        break;
                    }
                    case 4: {
                        C3DFloatParameter c3DFloatParameter = new C3DFloatParameter((String)object, false, n3);
                        n8 = this.readFloatParams(c3DFloatParameter, (int[])object3, n8);
                        c3DFloatParameter.setLocked(bl3);
                        c3DParameterGroup.addParameterUnlocked(c3DFloatParameter);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.errorReporter.errorReport(PARAM_BLOCK_SIZE_MSG, null);
                bl2 = false;
            }
            byte by = this.buffer[n8];
            object2 = this.reader.readString(n8 + 1, by);
            n8 += 1 + by;
        }
        n4 = 1;
        if (bl || this.observer != null) {
            int[] nArray = intHashMap.keySet();
            this.parameters = new C3DParameterGroup[nArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this.parameters[n3] = (C3DParameterGroup)intHashMap.get(nArray[n3]);
            }
        }
        if (this.observer != null) {
            try {
                n4 = this.observer.parametersComplete(this.parameters) ? 1 : 0;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(USER_PARAM_ERR, exception);
            }
            if (!bl) {
                this.parameters = null;
            }
        }
        if (this.header.numTrajectories != 0) {
            this.markerLabels = new String[this.header.numTrajectories];
            this.markerDescriptions = new String[this.header.numTrajectories];
            C3DParameterGroup c3DParameterGroup = (C3DParameterGroup)intHashMap.get(n7);
            C3DStringParameter c3DStringParameter = (C3DStringParameter)c3DParameterGroup.getParameter("LABELS");
            if (c3DStringParameter == null) {
                this.errorReporter.errorReport(LABEL_PARAM_MISSING_ERR, null);
            } else {
                object = (String[])c3DStringParameter.getValue();
                n2 = ((String[])object).length < this.header.numTrajectories ? ((String[])object).length : this.header.numTrajectories;
                System.arraycopy(object, 0, this.markerLabels, 0, n2);
            }
            object = (C3DStringParameter)c3DParameterGroup.getParameter("DESCRIPTIONS");
            if (object == null) {
                this.errorReporter.errorReport(DESC_PARAM_MISSING_ERR, null);
            } else {
                String[] stringArray = (String[])((C3DParameter)object).getValue();
                n = stringArray.length < this.header.numTrajectories ? stringArray.length : this.header.numTrajectories;
                System.arraycopy(stringArray, 0, this.markerDescriptions, 0, n);
            }
        }
        if (this.header.numAnalogChannels != 0) {
            this.analogLabels = new String[this.header.numAnalogChannels];
            this.analogDescriptions = new String[this.header.numAnalogChannels];
            C3DParameterGroup c3DParameterGroup = (C3DParameterGroup)intHashMap.get(n6);
            C3DStringParameter c3DStringParameter = (C3DStringParameter)c3DParameterGroup.getParameter("LABELS");
            if (c3DStringParameter == null) {
                this.errorReporter.errorReport(LABEL_PARAM_MISSING_ERR, null);
            } else {
                object = (String[])c3DStringParameter.getValue();
                int n10 = ((String[])object).length < this.header.numAnalogChannels ? ((Object)object).length : this.header.numAnalogChannels;
                System.arraycopy(object, 0, this.analogLabels, 0, n10);
            }
            object = (C3DStringParameter)c3DParameterGroup.getParameter("DESCRIPTIONS");
            if (object == null) {
                this.errorReporter.errorReport(DESC_PARAM_MISSING_ERR, null);
            } else {
                String[] stringArray = (String[])((C3DParameter)object).getValue();
                n = stringArray.length < this.header.numAnalogChannels ? stringArray.length : this.header.numAnalogChannels;
                System.arraycopy(stringArray, 0, this.analogDescriptions, 0, n);
            }
        }
        return n4 != 0;
    }

    private void parseTrajectories(boolean bl) throws IOException {
        int n;
        if (this.header.numTrajectories != 0) {
            this.trajectories = new C3DTrajectoryData[this.header.numTrajectories];
            for (n = 0; n < this.header.numTrajectories; ++n) {
                this.trajectories[n] = new C3DTrajectoryData(this.markerLabels[n], this.markerDescriptions[n], this.header.numTrajectorySamples);
            }
        }
        if (this.header.numAnalogChannels != 0) {
            this.analogSamples = new C3DAnalogData[this.header.numAnalogChannels];
            for (n = 0; n < this.header.numAnalogChannels; ++n) {
                this.analogSamples[n] = new C3DAnalogData(n + 1, this.analogLabels[n], this.analogDescriptions[n], this.header.numTrajectorySamples, this.header.numAnalogSamplesPer3DFrame);
            }
        }
        this.markerLabels = null;
        this.markerDescriptions = null;
        this.analogLabels = null;
        this.analogDescriptions = null;
        if (this.header.scaleFactor < 0.0f) {
            this.parseFloatTrajectories(bl);
        } else {
            this.parseIntTrajectories(bl);
        }
    }

    private void parseFloatTrajectories(boolean bl) throws IOException {
        int n = 0;
        for (int i = 0; i < this.header.numTrajectorySamples; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.header.numTrajectories; ++n3) {
                this.trajectories[n3].coordinates[i * 3] = this.reader.readFloat(n);
                if (n + 4 == 512) {
                    this.readBlocks(1);
                    n = -4;
                }
                this.trajectories[n3].coordinates[i * 3 + 1] = this.reader.readFloat(n + 4);
                if (n + 8 == 512) {
                    this.readBlocks(1);
                    n = -8;
                }
                this.trajectories[n3].coordinates[i * 3 + 2] = this.reader.readFloat(n + 8);
                if (n + 12 == 512) {
                    this.readBlocks(1);
                    n = -12;
                }
                n2 = this.reader.readInt(n + 12);
                this.trajectories[n3].cameraMasks[i] = (short)(n2 & 0xFF);
                this.trajectories[n3].residuals[i] = (float)(n2 & 0xFF00) * this.header.scaleFactor;
                if ((n += 16) != 512) continue;
                this.readBlocks(1);
                n = 0;
            }
            for (n3 = 0; n3 < this.header.numAnalogSamplesPer3DFrame; ++n3) {
                for (n2 = 0; n2 < this.header.numAnalogChannels; ++n2) {
                    this.analogSamples[n2].analogSamples[i * this.header.numAnalogSamplesPer3DFrame + n3] = this.reader.readFloat(n);
                    if ((n += 4) != 512) continue;
                    this.readBlocks(1);
                    n = 0;
                }
            }
        }
    }

    private void parseIntTrajectories(boolean bl) throws IOException {
        int n = 0;
        for (int i = 0; i < this.header.numTrajectorySamples; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.header.numTrajectories; ++n3) {
                this.trajectories[n3].coordinates[i * 3] = (float)this.reader.readShort(n) * this.header.scaleFactor;
                if (n + 2 == 512) {
                    this.readBlocks(1);
                    n = -2;
                }
                this.trajectories[n3].coordinates[i * 3 + 1] = this.reader.readFloat(n + 2) * this.header.scaleFactor;
                if (n + 4 == 512) {
                    this.readBlocks(1);
                    n = -4;
                }
                this.trajectories[n3].coordinates[i * 3 + 2] = this.reader.readFloat(n + 6) * this.header.scaleFactor;
                if (n + 6 == 512) {
                    this.readBlocks(1);
                    n = -6;
                }
                n2 = this.reader.readShort(n + 8);
                this.trajectories[n3].cameraMasks[i] = (short)(n2 & 0xFF);
                this.trajectories[n3].residuals[i] = (float)(n2 & 0xFF00) * this.header.scaleFactor;
                if ((n += 8) != 512) continue;
                this.readBlocks(1);
                n = 0;
            }
            for (n3 = 0; n3 < this.header.numAnalogSamplesPer3DFrame; ++n3) {
                for (n2 = 0; n2 < this.header.numAnalogChannels; ++n2) {
                    this.analogSamples[n2].analogSamples[i * this.header.numAnalogSamplesPer3DFrame + n3] = this.reader.readFloat(n);
                    if ((n += 4) != 512) continue;
                    this.readBlocks(1);
                    n = 0;
                }
            }
        }
    }

    private void readBlocks(int n) throws IOException {
        if (this.inputStream != null) {
            this.inputStream.read(this.buffer, 0, 512 * n);
            this.currentBlock += n;
        }
    }

    private int readStringParams(C3DStringParameter c3DStringParameter, int[] nArray, int n) {
        switch (nArray.length) {
            case 0: {
                String string = this.reader.readString(n, 1);
                ++n;
                c3DStringParameter.setValue(string);
                break;
            }
            case 1: {
                String string = this.reader.readString(n, nArray[0]);
                n += nArray[0];
                c3DStringParameter.setValue(string);
                break;
            }
            case 2: {
                String[] stringArray = new String[nArray[1]];
                for (int i = 0; i < nArray[1]; ++i) {
                    stringArray[i] = this.reader.readString(n + nArray[0] * i, nArray[0]);
                }
                n += nArray[0] * nArray[1];
                c3DStringParameter.setValue(stringArray, nArray);
                break;
            }
            case 3: {
                String[][] stringArray = new String[nArray[2]][nArray[1]];
                for (int i = 0; i < nArray[2]; ++i) {
                    for (int j = 0; j < nArray[1]; ++j) {
                        stringArray[i][j] = this.reader.readString(n + nArray[0] * i * j, nArray[0]);
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2];
                c3DStringParameter.setValue(stringArray, nArray);
                break;
            }
            case 4: {
                String[][][] stringArray = new String[nArray[3]][nArray[2]][nArray[1]];
                for (int i = 0; i < nArray[3]; ++i) {
                    for (int j = 0; j < nArray[2]; ++j) {
                        for (int k = 0; k < nArray[1]; ++k) {
                            stringArray[i][j][k] = this.reader.readString(n + nArray[0] * i * j * k, nArray[0]);
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3];
                c3DStringParameter.setValue(stringArray, nArray);
                break;
            }
            case 5: {
                String[][][][] stringArray = new String[nArray[4]][nArray[3]][nArray[2]][nArray[1]];
                for (int i = 0; i < nArray[4]; ++i) {
                    for (int j = 0; j < nArray[3]; ++j) {
                        for (int k = 0; k < nArray[2]; ++k) {
                            for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                stringArray[i][j][k][i2] = this.reader.readString(n + nArray[0] * i * j * k * i2, nArray[0]);
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4];
                c3DStringParameter.setValue(stringArray, nArray);
                break;
            }
            case 6: {
                String[][][][][] stringArray = new String[nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]];
                for (int i = 0; i < nArray[5]; ++i) {
                    for (int j = 0; j < nArray[4]; ++j) {
                        for (int k = 0; k < nArray[3]; ++k) {
                            for (int i3 = 0; i3 < nArray[2]; ++i3) {
                                for (int i4 = 0; i4 < nArray[1]; ++i4) {
                                    stringArray[i][j][k][i3][i4] = this.reader.readString(n + nArray[0] * i * j * k * i3 * i4, nArray[0]);
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5];
                c3DStringParameter.setValue(stringArray, nArray);
                break;
            }
            case 7: {
                String[][][][][][] stringArray = new String[nArray[6]][nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]];
                for (int i = 0; i < nArray[6]; ++i) {
                    for (int j = 0; j < nArray[5]; ++j) {
                        for (int k = 0; k < nArray[4]; ++k) {
                            for (int i5 = 0; i5 < nArray[3]; ++i5) {
                                for (int i6 = 0; i6 < nArray[2]; ++i6) {
                                    for (int i7 = 0; i7 < nArray[1]; ++i7) {
                                        stringArray[i][j][k][i5][i6][i7] = this.reader.readString(n + nArray[0] * i * j * k * i5 * i6 * i7, nArray[0]);
                                    }
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5] * nArray[6];
                c3DStringParameter.setValue(stringArray, nArray);
            }
        }
        return n;
    }

    private int readByteParams(C3DByteParameter c3DByteParameter, int[] nArray, int n) {
        switch (nArray.length) {
            case 0: {
                byte by = this.buffer[n];
                ++n;
                c3DByteParameter.setValue(by);
                break;
            }
            case 1: {
                byte[] byArray = new byte[nArray[0]];
                System.arraycopy(this.buffer, n, byArray, 0, nArray[0]);
                n += nArray[0];
                c3DByteParameter.setValue(byArray, nArray);
                break;
            }
            case 2: {
                byte[][] byArray = new byte[nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[1]; ++i) {
                    System.arraycopy(this.buffer, n + nArray[0] * i, byArray[i], 0, nArray[0]);
                }
                n += nArray[0] * nArray[1];
                c3DByteParameter.setValue(byArray, nArray);
                break;
            }
            case 3: {
                byte[][][] byArray = new byte[nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[2]; ++i) {
                    for (int j = 0; j < nArray[1]; ++j) {
                        System.arraycopy(this.buffer, n + nArray[0] * i * j, byArray[i][j], 0, nArray[0]);
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2];
                c3DByteParameter.setValue(byArray, nArray);
                break;
            }
            case 4: {
                byte[][][][] byArray = new byte[nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[3]; ++i) {
                    for (int j = 0; j < nArray[2]; ++j) {
                        for (int k = 0; k < nArray[1]; ++k) {
                            System.arraycopy(this.buffer, n + nArray[0] * i * j * k, byArray[i][j][k], 0, nArray[0]);
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3];
                c3DByteParameter.setValue(byArray, nArray);
                break;
            }
            case 5: {
                byte[][][][][] byArray = new byte[nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[4]; ++i) {
                    for (int j = 0; j < nArray[3]; ++j) {
                        for (int k = 0; k < nArray[2]; ++k) {
                            for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                System.arraycopy(this.buffer, n + nArray[0] * i * j * k * i2, byArray[i][j][k][i2], 0, nArray[0]);
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4];
                c3DByteParameter.setValue(byArray, nArray);
                break;
            }
            case 6: {
                byte[][][][][][] byArray = new byte[nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[5]; ++i) {
                    for (int j = 0; j < nArray[4]; ++j) {
                        for (int k = 0; k < nArray[3]; ++k) {
                            for (int i3 = 0; i3 < nArray[2]; ++i3) {
                                for (int i4 = 0; i4 < nArray[1]; ++i4) {
                                    System.arraycopy(this.buffer, n + nArray[0] * i * j * k * i3 * i4, byArray[i][j][k][i3][i4], 0, nArray[0]);
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5];
                c3DByteParameter.setValue(byArray, nArray);
                break;
            }
            case 7: {
                byte[][][][][][][] byArray = new byte[nArray[6]][nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[6]; ++i) {
                    for (int j = 0; j < nArray[5]; ++j) {
                        for (int k = 0; k < nArray[4]; ++k) {
                            for (int i5 = 0; i5 < nArray[3]; ++i5) {
                                for (int i6 = 0; i6 < nArray[2]; ++i6) {
                                    for (int i7 = 0; i7 < nArray[1]; ++i7) {
                                        System.arraycopy(this.buffer, n + nArray[0] * i * j * k * i5 * i6 * i7, byArray[i][j][k][i5][i6][i7], 0, nArray[0]);
                                    }
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5] * nArray[6];
                c3DByteParameter.setValue(byArray, nArray);
            }
        }
        return n;
    }

    private int readIntParams(C3DIntParameter c3DIntParameter, int[] nArray, int n) {
        switch (nArray.length) {
            case 0: {
                int n2 = this.reader.readShort(n);
                n += 2;
                c3DIntParameter.setValue(n2);
                break;
            }
            case 1: {
                int[] nArray2 = new int[nArray[0]];
                for (int i = 0; i < nArray[0]; ++i) {
                    nArray2[i] = this.reader.readShort(n + 2 * i);
                }
                n += nArray[0] * 2;
                c3DIntParameter.setValue(nArray2, nArray);
                break;
            }
            case 2: {
                int[][] nArray3 = new int[nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[1]; ++i) {
                    for (int j = 0; j < nArray[0]; ++j) {
                        nArray3[i][j] = this.reader.readShort(n + 2 * i * j);
                    }
                }
                n += nArray[0] * nArray[1] * 2;
                c3DIntParameter.setValue(nArray3, nArray);
                break;
            }
            case 3: {
                int[][][] nArray4 = new int[nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[2]; ++i) {
                    for (int j = 0; j < nArray[1]; ++j) {
                        for (int k = 0; k < nArray[0]; ++k) {
                            nArray4[i][j][k] = this.reader.readShort(n + 2 * i * j * k);
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * 2;
                c3DIntParameter.setValue(nArray4, nArray);
                break;
            }
            case 4: {
                int[][][][] nArray5 = new int[nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[3]; ++i) {
                    for (int j = 0; j < nArray[2]; ++j) {
                        for (int k = 0; k < nArray[1]; ++k) {
                            for (int i2 = 0; i2 < nArray[0]; ++i2) {
                                nArray5[i][j][k][i2] = this.reader.readShort(n + 2 * i * j * k * i2);
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * 2;
                c3DIntParameter.setValue(nArray5, nArray);
                break;
            }
            case 5: {
                int[][][][][] nArray6 = new int[nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[4]; ++i) {
                    for (int j = 0; j < nArray[3]; ++j) {
                        for (int k = 0; k < nArray[2]; ++k) {
                            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                                    nArray6[i][j][k][i3][i4] = this.reader.readShort(n + 2 * i * j * k * i3 * i4);
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * 2;
                c3DIntParameter.setValue(nArray6, nArray);
                break;
            }
            case 6: {
                int[][][][][][] nArray7 = new int[nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[5]; ++i) {
                    for (int j = 0; j < nArray[4]; ++j) {
                        for (int k = 0; k < nArray[3]; ++k) {
                            for (int i5 = 0; i5 < nArray[2]; ++i5) {
                                for (int i6 = 0; i6 < nArray[1]; ++i6) {
                                    for (int i7 = 0; i7 < nArray[0]; ++i7) {
                                        nArray7[i][j][k][i5][i6][i7] = this.reader.readShort(n + 2 * i * j * k * i5 * i6 * i7);
                                    }
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5] * 2;
                c3DIntParameter.setValue(nArray7, nArray);
                break;
            }
            case 7: {
                int[][][][][][][] nArray8 = new int[nArray[6]][nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[6]; ++i) {
                    for (int j = 0; j < nArray[5]; ++j) {
                        for (int k = 0; k < nArray[4]; ++k) {
                            for (int i8 = 0; i8 < nArray[3]; ++i8) {
                                for (int i9 = 0; i9 < nArray[2]; ++i9) {
                                    for (int i10 = 0; i10 < nArray[1]; ++i10) {
                                        for (int i11 = 0; i11 < nArray[0]; ++i11) {
                                            nArray8[i][j][k][i8][i9][i10][i11] = this.reader.readShort(n + 2 * i * j * k * i8 * i9 * i10 * i11);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5] * nArray[6] * 2;
                c3DIntParameter.setValue(nArray8, nArray);
            }
        }
        return n;
    }

    private int readFloatParams(C3DFloatParameter c3DFloatParameter, int[] nArray, int n) {
        switch (nArray.length) {
            case 0: {
                float f = this.reader.readFloat(n);
                n += 4;
                c3DFloatParameter.setValue(f);
                break;
            }
            case 1: {
                float[] fArray = new float[nArray[0]];
                for (int i = 0; i < nArray[0]; ++i) {
                    fArray[i] = this.reader.readFloat(n + 4 * i);
                }
                n += nArray[0] * 4;
                c3DFloatParameter.setValue(fArray, nArray);
                break;
            }
            case 2: {
                float[][] fArray = new float[nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[1]; ++i) {
                    for (int j = 0; j < nArray[0]; ++j) {
                        fArray[i][j] = this.reader.readFloat(n + 4 * i * j);
                    }
                }
                n += nArray[0] * nArray[1] * 4;
                c3DFloatParameter.setValue(fArray, nArray);
                break;
            }
            case 3: {
                float[][][] fArray = new float[nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[2]; ++i) {
                    for (int j = 0; j < nArray[1]; ++j) {
                        for (int k = 0; k < nArray[0]; ++k) {
                            fArray[i][j][k] = this.reader.readFloat(n + 4 * i * j * k);
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * 4;
                c3DFloatParameter.setValue(fArray, nArray);
                break;
            }
            case 4: {
                float[][][][] fArray = new float[nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[3]; ++i) {
                    for (int j = 0; j < nArray[2]; ++j) {
                        for (int k = 0; k < nArray[1]; ++k) {
                            for (int i2 = 0; i2 < nArray[0]; ++i2) {
                                fArray[i][j][k][i2] = this.reader.readFloat(n + 4 * i * j * k * i2);
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * 4;
                c3DFloatParameter.setValue(fArray, nArray);
                break;
            }
            case 5: {
                float[][][][][] fArray = new float[nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[4]; ++i) {
                    for (int j = 0; j < nArray[3]; ++j) {
                        for (int k = 0; k < nArray[2]; ++k) {
                            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                                    fArray[i][j][k][i3][i4] = this.reader.readFloat(n + 4 * i * j * k * i3 * i4);
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * 4;
                c3DFloatParameter.setValue(fArray, nArray);
                break;
            }
            case 6: {
                float[][][][][][] fArray = new float[nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[5]; ++i) {
                    for (int j = 0; j < nArray[4]; ++j) {
                        for (int k = 0; k < nArray[3]; ++k) {
                            for (int i5 = 0; i5 < nArray[2]; ++i5) {
                                for (int i6 = 0; i6 < nArray[1]; ++i6) {
                                    for (int i7 = 0; i7 < nArray[0]; ++i7) {
                                        fArray[i][j][k][i5][i6][i7] = this.reader.readFloat(n + 4 * i * j * k * i5 * i6 * i7);
                                    }
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5] * 4;
                c3DFloatParameter.setValue(fArray, nArray);
                break;
            }
            case 7: {
                float[][][][][][][] fArray = new float[nArray[6]][nArray[5]][nArray[4]][nArray[3]][nArray[2]][nArray[1]][nArray[0]];
                for (int i = 0; i < nArray[6]; ++i) {
                    for (int j = 0; j < nArray[5]; ++j) {
                        for (int k = 0; k < nArray[4]; ++k) {
                            for (int i8 = 0; i8 < nArray[3]; ++i8) {
                                for (int i9 = 0; i9 < nArray[2]; ++i9) {
                                    for (int i10 = 0; i10 < nArray[1]; ++i10) {
                                        for (int i11 = 0; i11 < nArray[0]; ++i11) {
                                            fArray[i][j][k][i8][i9][i10][i11] = this.reader.readFloat(n + 4 * i * j * k * i8 * i9 * i10 * i11);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                n += nArray[0] * nArray[1] * nArray[2] * nArray[3] * nArray[4] * nArray[5] * nArray[6] * 4;
                c3DFloatParameter.setValue(fArray, nArray);
            }
        }
        return n;
    }
}

