/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ProgressMonitorInputStream;
import org.j3d.loaders.InvalidFormatException;
import org.j3d.loaders.stl.STLParser;
import org.j3d.util.I18nManager;

class STLASCIIParser
extends STLParser {
    private static final String UNKNOWN_KEYWORD_MSG_PROP = "org.j3d.loaders.stl.STLASCIIParser.invalidKeywordMsg";
    private static final String EMPTY_FILE_MSG_PROP = "org.j3d.loaders.stl.STLASCIIParser.emptyFileMsg";
    private static final String INVALID_DATA_MSG_PROP = "org.j3d.loaders.stl.STLASCIIParser.invalidDataMsg";
    private static final String EOF_WTF_MSG_PROP = "org.j3d.loaders.stl.STLASCIIParser.unexpectedEofMsg";
    private BufferedReader itsReader;
    private int lineCount;

    public void close() throws IOException {
        if (this.itsReader != null) {
            this.itsReader.close();
        }
    }

    public boolean getNextFacet(double[] dArray, double[][] dArray2) throws IOException {
        String string = this.itsReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("solid")) {
            string = this.itsReader.readLine();
            stringTokenizer = new StringTokenizer(string);
            string2 = stringTokenizer.nextToken();
            this.lineCount = 1;
        }
        if (string2.equals("endsolid") || string2.equals("end solid")) {
            return false;
        }
        if (!string2.equals("facet")) {
            this.close();
            I18nManager i18nManager = I18nManager.getManager();
            String string3 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
            throw new InvalidFormatException(string3);
        }
        string2 = stringTokenizer.nextToken();
        if (!string2.equals("normal")) {
            this.close();
            I18nManager i18nManager = I18nManager.getManager();
            String string4 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
            throw new InvalidFormatException(string4);
        }
        this.readVector(stringTokenizer, dArray);
        string = this.itsReader.readLine();
        stringTokenizer = new StringTokenizer(string);
        string2 = stringTokenizer.nextToken();
        ++this.lineCount;
        if (!string2.equals("outer")) {
            this.close();
            I18nManager i18nManager = I18nManager.getManager();
            String string5 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
            throw new InvalidFormatException(string5);
        }
        string2 = stringTokenizer.nextToken();
        if (!string2.equals("loop")) {
            this.close();
            I18nManager i18nManager = I18nManager.getManager();
            String string6 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
            throw new InvalidFormatException(string6);
        }
        for (int i = 0; i < 3; ++i) {
            string = this.itsReader.readLine();
            stringTokenizer = new StringTokenizer(string);
            ++this.lineCount;
            string2 = stringTokenizer.nextToken();
            if (!string2.equals("vertex")) {
                this.close();
                I18nManager i18nManager = I18nManager.getManager();
                String string7 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
                throw new InvalidFormatException(string7);
            }
            this.readVector(stringTokenizer, dArray2[i]);
        }
        string = this.itsReader.readLine();
        stringTokenizer = new StringTokenizer(string);
        string2 = stringTokenizer.nextToken();
        ++this.lineCount;
        if (!string2.equals("endloop")) {
            this.close();
            I18nManager i18nManager = I18nManager.getManager();
            String string8 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
            throw new InvalidFormatException(string8);
        }
        string = this.itsReader.readLine();
        stringTokenizer = new StringTokenizer(string);
        string2 = stringTokenizer.nextToken();
        ++this.lineCount;
        if (!string2.equals("endfacet")) {
            this.close();
            I18nManager i18nManager = I18nManager.getManager();
            String string9 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
            throw new InvalidFormatException(string9);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(URL uRL, Component component) throws InterruptedIOException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw iOException;
        }
        inputStream = new ProgressMonitorInputStream(component, "analyzing " + uRL.toString(), inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        try {
            bl = this.parse(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
        if (!bl) {
            return false;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
        inputStream = new ProgressMonitorInputStream(component, "parsing " + uRL.toString(), inputStream);
        this.itsReader = bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw iOException;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        try {
            bl = this.parse(bufferedReader);
        }
        catch (InterruptedIOException interruptedIOException) {
            interruptedIOException.printStackTrace();
        }
        finally {
            bufferedReader.close();
        }
        if (!bl) {
            return false;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
        this.itsReader = bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return true;
    }

    private boolean parse(BufferedReader bufferedReader) throws IOException, InvalidFormatException {
        int n;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
        ArrayList<String> arrayList2 = new ArrayList<String>(10);
        boolean bl = true;
        String string = bufferedReader.readLine();
        int n4 = 1;
        if (!string.startsWith("solid")) {
            return false;
        }
        if ((string = string.trim()).length() > 6) {
            arrayList2.add(string.substring(6));
        } else {
            arrayList2.add(null);
        }
        string = bufferedReader.readLine();
        if (string == null) {
            I18nManager i18nManager = I18nManager.getManager();
            String string2 = i18nManager.getString(EMPTY_FILE_MSG_PROP);
            throw new InvalidFormatException(string2);
        }
        while (string != null) {
            ++n4;
            if (string.indexOf("facet") >= 0) {
                ++n3;
                for (n = 0; n < 6; ++n) {
                    bufferedReader.readLine();
                }
                n4 += 6;
            } else if (string.indexOf("endsolid") >= 0 || string.indexOf("end solid") >= 0) {
                arrayList.add(new Integer(n3));
                n3 = 0;
                ++n2;
            } else if (string.indexOf("solid") >= 0) {
                if ((string = string.trim()).length() > 6) {
                    arrayList2.add(string.substring(6));
                }
            } else if ((string = string.trim()).length() != 0) {
                I18nManager i18nManager = I18nManager.getManager();
                String string3 = i18nManager.getString(UNKNOWN_KEYWORD_MSG_PROP) + this.lineCount;
                throw new InvalidFormatException(string3);
            }
            string = bufferedReader.readLine();
        }
        this.itsNumOfObjects = n2;
        this.itsNumOfFacets = new int[n2];
        this.itsNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            Integer n5 = (Integer)arrayList.get(n);
            this.itsNumOfFacets[n] = n5;
            this.itsNames[n] = (String)arrayList2.get(n);
        }
        return true;
    }

    private void readVector(StringTokenizer stringTokenizer, double[] dArray) throws IOException {
        for (int i = 0; i < 3; ++i) {
            String string = stringTokenizer.nextToken();
            try {
                dArray[i] = Double.parseDouble(string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                I18nManager i18nManager = I18nManager.getManager();
                String string2 = i18nManager.getString(INVALID_DATA_MSG_PROP) + string;
                throw new InvalidFormatException(string2);
            }
        }
    }
}

