/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.terrain.TerrainData;
import org.j3d.ui.navigation.HeightMapGeometry;
import org.j3d.util.I18nManager;
import org.j3d.util.frustum.ViewFrustum;

public abstract class Landscape
implements HeightMapGeometry {
    private static final String NULL_VIEW_FRUSTUM_MSG_PROP = "org.j3d.terrain.Landscape.nullViewFrustumMsg";
    private static final String NULL_TERRAIN_MSG_PROP = "org.j3d.terrain.Landscape.nullTerrainDataMsg";
    protected ViewFrustum landscapeView;
    protected TerrainData terrainData;

    public Landscape(ViewFrustum viewFrustum, TerrainData terrainData) {
        if (viewFrustum == null) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NULL_VIEW_FRUSTUM_MSG_PROP);
            throw new IllegalArgumentException(string);
        }
        if (terrainData == null) {
            I18nManager i18nManager = I18nManager.getManager();
            String string = i18nManager.getString(NULL_TERRAIN_MSG_PROP);
            throw new IllegalArgumentException(string);
        }
        this.terrainData = terrainData;
        this.landscapeView = viewFrustum;
    }

    public float getHeight(float f, float f2) {
        return this.terrainData.getHeight(f, f2);
    }

    public abstract void initialize(Tuple3f var1, Vector3f var2);

    public abstract void setView(Tuple3f var1, Vector3f var2);
}

