/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.lang.reflect.Array;
import java.util.Collection;
import org.j3d.util.ObjectArray;

public class CircularList {
    private static ObjectArray entryCache = new ObjectArray();
    private Entry current;
    private int count;

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object next() {
        if (this.count == 0) {
            return null;
        }
        this.current = this.current.next;
        return this.current.value;
    }

    public Object previous() {
        if (this.count == 0) {
            return null;
        }
        this.current = this.current.prev;
        return this.current.value;
    }

    public Object current() {
        if (this.count == 0) {
            return null;
        }
        return this.current.value;
    }

    public boolean contains(Object object) {
        boolean bl = false;
        if (object != null && this.count != 0) {
            Entry entry = this.current.next;
            while (entry != this.current && !bl) {
                bl = entry == object || entry.equals(object);
            }
        }
        return bl;
    }

    public void add(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempting to add null object");
        }
        Entry entry = CircularList.newEntry();
        entry.value = object;
        if (this.current == null) {
            entry.prev = entry;
            entry.next = entry;
        } else {
            entry.prev = this.current.prev;
            entry.next = this.current;
            this.current.prev = entry;
            entry.prev.next = entry;
        }
        ++this.count;
    }

    public boolean remove(Object object) {
        if (object == null || this.count == 0) {
            return false;
        }
        boolean bl = false;
        Entry entry = this.current.next;
        while (entry != this.current && !bl) {
            bl = entry == object || entry.equals(object);
        }
        if (bl) {
            Entry entry2 = entry.next;
            entry.prev.next = entry.next;
            entry2.next.prev = entry;
            entry.next = null;
            entry.prev = null;
            entry.value = null;
            if (this.current == entry) {
                this.current = this.count == 1 ? null : entry2;
            }
            --this.count;
            CircularList.freeEntry(entry);
        }
        return bl;
    }

    public void clear() {
        if (this.count == 0) {
            return;
        }
        Entry entry = this.current;
        do {
            this.current = entry;
            entry = this.current.next;
            this.current.prev = null;
            this.current.next = null;
            this.current.value = null;
            CircularList.freeEntry(this.current);
        } while (entry != null && entry != this.current);
        this.current = null;
        this.count = 0;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            if (this.contains(e)) continue;
            this.add(e);
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() == 0 || this.count == 0) {
            return false;
        }
        boolean bl = false;
        for (Object e : collection) {
            if (!this.remove(e)) continue;
            bl = true;
        }
        return bl;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.count];
        Entry entry = this.current;
        for (int i = 0; i < this.count; ++i) {
            objectArray[i] = entry;
            entry = entry.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object object;
        int n = this.count;
        if (objectArray.length < n) {
            object = objectArray.getClass();
            objectArray = (Object[])Array.newInstance(((Class)object).getComponentType(), n);
        }
        object = this.current;
        for (int i = 0; i < this.count; ++i) {
            objectArray[i] = object;
            object = ((Entry)object).next;
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CircularList)) {
            return false;
        }
        CircularList circularList = (CircularList)object;
        if (circularList.count != this.count && !circularList.contains(this.current)) {
            return false;
        }
        Entry entry = circularList.current;
        while (entry != this.current) {
            entry = entry.next;
        }
        boolean bl = true;
        Entry entry2 = this.current;
        for (int i = 0; i < this.count && bl; ++i) {
            bl = entry2 == entry && entry2.equals(entry);
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        Entry entry = this.current;
        for (int i = 0; i < this.count; ++i) {
            n += entry.value.hashCode();
            entry = entry.next;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Entry entry = this.current;
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append(entry.value);
            if (i < this.count - 1) {
                stringBuffer.append(", ");
            }
            entry = entry.next;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void clearCachedObjects() {
        entryCache.clear();
    }

    private static synchronized Entry newEntry() {
        return entryCache.size() == 0 ? new Entry() : (Entry)entryCache.remove(0);
    }

    private static void freeEntry(Entry entry) {
        entryCache.add(entry);
    }

    private static class Entry {
        Object value;
        Entry next;
        Entry prev;

        private Entry() {
        }
    }
}

