/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class I18nManager {
    private static final String INVALID_LANG_LENGTH = "The language code is not the required 2 characters in length: ";
    private static final String INVALID_COUNTRY_LENGTH = "The country code is not the required 2 characters in length: ";
    private static final String COUNTRY_PREF = "countryCode";
    private static final String LANGUAGE_PREF = "languageCode";
    private static final String VARIANT_PREF = "variantCode";
    private static final String DEFAULT_RESOURCES_FILE = "config.i18n.j3dorgResources";
    private static I18nManager instance;
    private String applicationName;
    private String resourceFileName;
    private String countryCode;
    private String languageCode;
    private String variantCode;
    private ResourceBundle stringResources;

    private I18nManager() {
        Preferences preferences = Preferences.userNodeForPackage(I18nManager.class);
        this.countryCode = preferences.get(COUNTRY_PREF, null);
        this.languageCode = preferences.get(LANGUAGE_PREF, null);
        this.variantCode = preferences.get(VARIANT_PREF, null);
        Locale locale = this.findLocale();
        this.resourceFileName = DEFAULT_RESOURCES_FILE;
        this.stringResources = ResourceBundle.getBundle(this.resourceFileName, locale);
    }

    public static I18nManager getManager() {
        if (instance == null) {
            instance = new I18nManager();
        }
        return instance;
    }

    public void setApplication(String string, String string2) {
        Object object;
        Preferences preferences = Preferences.userNodeForPackage(I18nManager.class);
        boolean bl = false;
        try {
            bl = preferences.nodeExists(string);
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        if (bl) {
            object = preferences.node(string);
            this.countryCode = ((Preferences)object).get(COUNTRY_PREF, null);
            this.languageCode = ((Preferences)object).get(LANGUAGE_PREF, null);
            this.variantCode = ((Preferences)object).get(VARIANT_PREF, null);
        } else {
            object = preferences.node(string);
            this.countryCode = null;
            this.languageCode = null;
            this.variantCode = null;
        }
        this.applicationName = string;
        this.resourceFileName = string2 == null ? DEFAULT_RESOURCES_FILE : string2;
        object = this.findLocale();
        this.stringResources = ResourceBundle.getBundle(this.resourceFileName, (Locale)object);
    }

    public String getApplication() {
        return this.applicationName;
    }

    public String getResourceName() {
        return this.resourceFileName;
    }

    public void changeLocale(String string, String string2, String string3) throws IllegalArgumentException {
        Object object;
        if (string != null && string.length() != 2) {
            throw new IllegalArgumentException(INVALID_LANG_LENGTH + string);
        }
        if (string2 != null && string2.length() != 2) {
            throw new IllegalArgumentException(INVALID_COUNTRY_LENGTH + string2);
        }
        if (this.applicationName != null) {
            object = Preferences.userNodeForPackage(I18nManager.class);
            Preferences preferences = ((Preferences)object).node(this.applicationName);
            if (string2 == null) {
                preferences.remove(COUNTRY_PREF);
            } else {
                preferences.put(COUNTRY_PREF, string2);
            }
            if (string == null) {
                preferences.remove(LANGUAGE_PREF);
            } else {
                preferences.put(LANGUAGE_PREF, string);
            }
            if (string3 == null) {
                preferences.remove(VARIANT_PREF);
            } else {
                preferences.put(VARIANT_PREF, string3);
            }
        }
        this.languageCode = string;
        this.countryCode = string2;
        this.variantCode = string3;
        object = this.findLocale();
        this.stringResources = ResourceBundle.getBundle(this.resourceFileName, (Locale)object);
    }

    public Locale getFoundLocale() {
        return this.stringResources.getLocale();
    }

    public String getRequestedLanguage() {
        return this.languageCode;
    }

    public String getRequestedCountry() {
        return this.countryCode;
    }

    public String getRequestedLanguageVariant() {
        return this.variantCode;
    }

    public String getString(String string) {
        return this.stringResources.getString(string);
    }

    private Locale findLocale() {
        Locale locale = this.languageCode == null ? Locale.getDefault() : (this.countryCode == null ? new Locale(this.languageCode) : (this.variantCode == null ? new Locale(this.languageCode, this.countryCode) : new Locale(this.languageCode, this.countryCode, this.variantCode)));
        return locale;
    }
}

