/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.I18nManager;

public class ImageLoader {
    private static final String BAD_URL_MSG_PROP = "org.j3d.util.ImageLoader.urlFormatErrorMsg";
    private static final int DEFAULT_SIZE = 10;
    private static HashMap<String, WeakReference> loadedImages;
    private static HashMap<String, WeakReference> loadedIcons;
    private static ErrorReporter errorReporter;

    public static void setErrorReporter(ErrorReporter errorReporter) {
        ImageLoader.errorReporter = errorReporter;
        if (errorReporter == null) {
            ImageLoader.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public static Icon loadIcon(String string) {
        Image image;
        Icon icon = null;
        WeakReference weakReference = loadedIcons.get(string);
        if (weakReference != null && (icon = (Icon)weakReference.get()) == null) {
            loadedIcons.remove(string);
        }
        if (icon == null && (image = ImageLoader.loadImage(string)) != null) {
            icon = new ImageIcon(image, string);
            loadedIcons.put(string, new WeakReference<Icon>(icon));
        }
        return icon;
    }

    public static Image loadImage(String string) {
        URL uRL;
        Image image = null;
        WeakReference weakReference = loadedImages.get(string);
        if (weakReference != null && (image = (Image)weakReference.get()) == null) {
            loadedIcons.remove(string);
        }
        if (image == null && (uRL = ImageLoader.findFile(string)) != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            image = toolkit.createImage(uRL);
            loadedImages.put(string, new WeakReference<Image>(image));
        }
        return image;
    }

    private static URL findFile(final String string) {
        URL uRL = null;
        if (string.startsWith("http:") || string.startsWith("file:")) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                I18nManager i18nManager = I18nManager.getManager();
                String string2 = i18nManager.getString(BAD_URL_MSG_PROP) + string;
                errorReporter.errorReport(string2, null);
            }
        } else {
            uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    URL uRL = ClassLoader.getSystemResource(string);
                    if (uRL == null) {
                        classLoader = ImageLoader.class.getClassLoader();
                        uRL = classLoader.getResource(string);
                    }
                    return uRL;
                }
            });
        }
        return uRL;
    }

    static {
        errorReporter = DefaultErrorReporter.getDefaultReporter();
        loadedImages = new HashMap(10);
        loadedIcons = new HashMap(10);
    }
}

